/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.storage.impl.local.paginated.wal.po.cluster.clusterpositionmapbucket;

import com.orientechnologies.orient.core.storage.cache.OCacheEntry;
import com.orientechnologies.orient.core.storage.cluster.OClusterPositionMapBucket;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.po.PageOperationRecord;
import java.nio.ByteBuffer;

public final class ClusterPositionMapBucketTruncateLastEntryPO
extends PageOperationRecord {
    private byte recordStatus;
    private int recordPageIndex;
    private int recordPosition;

    public ClusterPositionMapBucketTruncateLastEntryPO() {
    }

    public ClusterPositionMapBucketTruncateLastEntryPO(byte recordStatus, int recordPageIndex, int recordPosition) {
        this.recordStatus = recordStatus;
        this.recordPageIndex = recordPageIndex;
        this.recordPosition = recordPosition;
    }

    public byte getRecordStatus() {
        return this.recordStatus;
    }

    public int getRecordPageIndex() {
        return this.recordPageIndex;
    }

    public int getRecordPosition() {
        return this.recordPosition;
    }

    @Override
    public void redo(OCacheEntry cacheEntry) {
        OClusterPositionMapBucket bucket = new OClusterPositionMapBucket(cacheEntry);
        bucket.truncateLastEntry();
    }

    @Override
    public void undo(OCacheEntry cacheEntry) {
        OClusterPositionMapBucket bucket = new OClusterPositionMapBucket(cacheEntry);
        bucket.add(this.recordPageIndex, this.recordPosition, this.recordStatus);
    }

    @Override
    public int getId() {
        return 38;
    }

    @Override
    public int serializedSize() {
        return super.serializedSize() + 1 + 8;
    }

    @Override
    protected void serializeToByteBuffer(ByteBuffer buffer) {
        super.serializeToByteBuffer(buffer);
        buffer.put(this.recordStatus);
        buffer.putInt(this.recordPageIndex);
        buffer.putInt(this.recordPosition);
    }

    @Override
    protected void deserializeFromByteBuffer(ByteBuffer buffer) {
        super.deserializeFromByteBuffer(buffer);
        this.recordStatus = buffer.get();
        this.recordPageIndex = buffer.getInt();
        this.recordPosition = buffer.getInt();
    }
}

