/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.storage.impl.local.paginated.wal.po.cluster.clusterpositionmapbucket;

import com.orientechnologies.orient.core.storage.cache.OCacheEntry;
import com.orientechnologies.orient.core.storage.cluster.OClusterPositionMapBucket;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.po.PageOperationRecord;
import java.nio.ByteBuffer;

public final class ClusterPositionMapBucketUpdateEntryPO
extends PageOperationRecord {
    private int index;
    private byte oldRecordStatus;
    private int oldRecordPageIndex;
    private int oldRecordPosition;
    private byte recordStatus;
    private int recordPageIndex;
    private int recordPosition;

    public ClusterPositionMapBucketUpdateEntryPO() {
    }

    public ClusterPositionMapBucketUpdateEntryPO(int index, byte oldRecordStatus, int oldRecordPageIndex, int oldRecordPosition, byte recordStatus, int recordPageIndex, int recordPosition) {
        this.index = index;
        this.oldRecordStatus = oldRecordStatus;
        this.oldRecordPageIndex = oldRecordPageIndex;
        this.oldRecordPosition = oldRecordPosition;
        this.recordStatus = recordStatus;
        this.recordPageIndex = recordPageIndex;
        this.recordPosition = recordPosition;
    }

    public int getIndex() {
        return this.index;
    }

    public byte getOldRecordStatus() {
        return this.oldRecordStatus;
    }

    public int getOldRecordPageIndex() {
        return this.oldRecordPageIndex;
    }

    public int getOldRecordPosition() {
        return this.oldRecordPosition;
    }

    public byte getRecordStatus() {
        return this.recordStatus;
    }

    public int getRecordPageIndex() {
        return this.recordPageIndex;
    }

    public int getRecordPosition() {
        return this.recordPosition;
    }

    @Override
    public void redo(OCacheEntry cacheEntry) {
        OClusterPositionMapBucket bucket = new OClusterPositionMapBucket(cacheEntry);
        bucket.updateEntry(this.index, this.recordPageIndex, this.recordPosition, this.recordStatus);
    }

    @Override
    public void undo(OCacheEntry cacheEntry) {
        OClusterPositionMapBucket bucket = new OClusterPositionMapBucket(cacheEntry);
        bucket.updateEntry(this.index, this.oldRecordPageIndex, this.oldRecordPosition, this.oldRecordStatus);
    }

    @Override
    public int getId() {
        return 40;
    }

    @Override
    public int serializedSize() {
        return super.serializedSize() + 4 + 18;
    }

    @Override
    protected void serializeToByteBuffer(ByteBuffer buffer) {
        super.serializeToByteBuffer(buffer);
        buffer.putInt(this.index);
        buffer.put(this.oldRecordStatus);
        buffer.putInt(this.oldRecordPageIndex);
        buffer.putInt(this.oldRecordPosition);
        buffer.put(this.recordStatus);
        buffer.putInt(this.recordPageIndex);
        buffer.putInt(this.recordPosition);
    }

    @Override
    protected void deserializeFromByteBuffer(ByteBuffer buffer) {
        super.deserializeFromByteBuffer(buffer);
        this.index = buffer.getInt();
        this.oldRecordStatus = buffer.get();
        this.oldRecordPageIndex = buffer.getInt();
        this.oldRecordPosition = buffer.getInt();
        this.recordStatus = buffer.get();
        this.recordPageIndex = buffer.getInt();
        this.recordPosition = buffer.getInt();
    }
}

