/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.storage.impl.local.paginated.wal.po.cluster.v0.paginatedclusterstate;

import com.orientechnologies.orient.core.storage.cache.OCacheEntry;
import com.orientechnologies.orient.core.storage.cluster.v0.OPaginatedClusterStateV0;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.po.PageOperationRecord;
import java.nio.ByteBuffer;

public final class PaginatedClusterStateV0SetRecordsSizePO
extends PageOperationRecord {
    private long oldRecordsSize;
    private long newRecordsSize;

    public PaginatedClusterStateV0SetRecordsSizePO() {
    }

    public PaginatedClusterStateV0SetRecordsSizePO(long oldRecordsSize, long newRecordsSize) {
        this.oldRecordsSize = oldRecordsSize;
        this.newRecordsSize = newRecordsSize;
    }

    public long getOldRecordsSize() {
        return this.oldRecordsSize;
    }

    public long getNewRecordsSize() {
        return this.newRecordsSize;
    }

    @Override
    public void redo(OCacheEntry cacheEntry) {
        OPaginatedClusterStateV0 paginatedClusterStateV0 = new OPaginatedClusterStateV0(cacheEntry);
        paginatedClusterStateV0.setRecordsSize(this.newRecordsSize);
    }

    @Override
    public void undo(OCacheEntry cacheEntry) {
        OPaginatedClusterStateV0 paginatedClusterStateV0 = new OPaginatedClusterStateV0(cacheEntry);
        paginatedClusterStateV0.setRecordsSize(this.oldRecordsSize);
    }

    @Override
    public int getId() {
        return 50;
    }

    @Override
    public int serializedSize() {
        return super.serializedSize() + 16;
    }

    @Override
    protected void serializeToByteBuffer(ByteBuffer buffer) {
        super.serializeToByteBuffer(buffer);
        buffer.putLong(this.oldRecordsSize);
        buffer.putLong(this.newRecordsSize);
    }

    @Override
    protected void deserializeFromByteBuffer(ByteBuffer buffer) {
        super.deserializeFromByteBuffer(buffer);
        this.oldRecordsSize = buffer.getLong();
        this.newRecordsSize = buffer.getLong();
    }
}

