/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.storage.impl.local.paginated.wal.po.cluster.v0.paginatedclusterstate;

import com.orientechnologies.orient.core.storage.cache.OCacheEntry;
import com.orientechnologies.orient.core.storage.cluster.v0.OPaginatedClusterStateV0;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.po.PageOperationRecord;
import java.nio.ByteBuffer;

public final class PaginatedClusterStateV0SetSizePO
extends PageOperationRecord {
    private long oldSize;
    private long newSize;

    public PaginatedClusterStateV0SetSizePO() {
    }

    public PaginatedClusterStateV0SetSizePO(long oldSize, long newSize) {
        this.oldSize = oldSize;
        this.newSize = newSize;
    }

    public long getOldSize() {
        return this.oldSize;
    }

    public long getNewSize() {
        return this.newSize;
    }

    @Override
    public void redo(OCacheEntry cacheEntry) {
        OPaginatedClusterStateV0 paginatedClusterStateV0 = new OPaginatedClusterStateV0(cacheEntry);
        paginatedClusterStateV0.setSize(this.newSize);
    }

    @Override
    public void undo(OCacheEntry cacheEntry) {
        OPaginatedClusterStateV0 paginatedClusterStateV0 = new OPaginatedClusterStateV0(cacheEntry);
        paginatedClusterStateV0.setSize(this.oldSize);
    }

    @Override
    public int getId() {
        return 49;
    }

    @Override
    public int serializedSize() {
        return super.serializedSize() + 16;
    }

    @Override
    protected void serializeToByteBuffer(ByteBuffer buffer) {
        super.serializeToByteBuffer(buffer);
        buffer.putLong(this.oldSize);
        buffer.putLong(this.newSize);
    }

    @Override
    protected void deserializeFromByteBuffer(ByteBuffer buffer) {
        super.deserializeFromByteBuffer(buffer);
        this.oldSize = buffer.getLong();
        this.newSize = buffer.getLong();
    }
}

