/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.storage.impl.local.paginated.wal.po.cluster.v1.paginatedclusterstate;

import com.orientechnologies.orient.core.storage.cache.OCacheEntry;
import com.orientechnologies.orient.core.storage.cluster.v1.OPaginatedClusterStateV1;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.po.PageOperationRecord;
import java.nio.ByteBuffer;

public final class PaginatedClusterStateV1SetFileSizePO
extends PageOperationRecord {
    private int oldFileSize;
    private int newFileSize;

    public PaginatedClusterStateV1SetFileSizePO() {
    }

    public PaginatedClusterStateV1SetFileSizePO(int oldFileSize, int newFileSize) {
        this.oldFileSize = oldFileSize;
        this.newFileSize = newFileSize;
    }

    public int getOldFileSize() {
        return this.oldFileSize;
    }

    public int getNewFileSize() {
        return this.newFileSize;
    }

    @Override
    public void redo(OCacheEntry cacheEntry) {
        OPaginatedClusterStateV1 paginatedClusterStateV1 = new OPaginatedClusterStateV1(cacheEntry);
        paginatedClusterStateV1.setFileSize(this.newFileSize);
    }

    @Override
    public void undo(OCacheEntry cacheEntry) {
        OPaginatedClusterStateV1 paginatedClusterStateV1 = new OPaginatedClusterStateV1(cacheEntry);
        paginatedClusterStateV1.setFileSize(this.oldFileSize);
    }

    @Override
    public int getId() {
        return 55;
    }

    @Override
    public int serializedSize() {
        return super.serializedSize() + 8;
    }

    @Override
    protected void serializeToByteBuffer(ByteBuffer buffer) {
        super.serializeToByteBuffer(buffer);
        buffer.putInt(this.oldFileSize);
        buffer.putInt(this.newFileSize);
    }

    @Override
    protected void deserializeFromByteBuffer(ByteBuffer buffer) {
        super.deserializeFromByteBuffer(buffer);
        this.oldFileSize = buffer.getInt();
        this.newFileSize = buffer.getInt();
    }
}

