/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.storage.impl.local.paginated.wal.po.cluster.v2.paginatedclusterstate;

import com.orientechnologies.orient.core.storage.cache.OCacheEntry;
import com.orientechnologies.orient.core.storage.cluster.v2.OPaginatedClusterStateV2;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.po.PageOperationRecord;
import java.nio.ByteBuffer;

public final class PaginatedClusterStateV2SetSizePO
extends PageOperationRecord {
    private int oldSize;
    private int newSize;

    public PaginatedClusterStateV2SetSizePO() {
    }

    public PaginatedClusterStateV2SetSizePO(int oldSize, int newSize) {
        this.oldSize = oldSize;
        this.newSize = newSize;
    }

    public long getOldSize() {
        return this.oldSize;
    }

    public long getNewSize() {
        return this.newSize;
    }

    @Override
    public void redo(OCacheEntry cacheEntry) {
        OPaginatedClusterStateV2 paginatedClusterStateV2 = new OPaginatedClusterStateV2(cacheEntry);
        paginatedClusterStateV2.setSize(this.newSize);
    }

    @Override
    public void undo(OCacheEntry cacheEntry) {
        OPaginatedClusterStateV2 paginatedClusterStateV2 = new OPaginatedClusterStateV2(cacheEntry);
        paginatedClusterStateV2.setSize(this.oldSize);
    }

    @Override
    public int getId() {
        return 59;
    }

    @Override
    public int serializedSize() {
        return super.serializedSize() + 8;
    }

    @Override
    protected void serializeToByteBuffer(ByteBuffer buffer) {
        super.serializeToByteBuffer(buffer);
        buffer.putInt(this.oldSize);
        buffer.putInt(this.newSize);
    }

    @Override
    protected void deserializeFromByteBuffer(ByteBuffer buffer) {
        super.deserializeFromByteBuffer(buffer);
        this.oldSize = buffer.getInt();
        this.newSize = buffer.getInt();
    }
}

