/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.storage.impl.local.paginated.wal.po.localhashtable.v2.bucket;

import com.orientechnologies.orient.core.storage.cache.OCacheEntry;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.po.PageOperationRecord;
import com.orientechnologies.orient.core.storage.index.hashindex.local.v2.HashIndexBucketV2;
import java.nio.ByteBuffer;

public final class LocalHashTableV2BucketSetDepthPO
extends PageOperationRecord {
    private byte depth;
    private byte oldDepth;

    public LocalHashTableV2BucketSetDepthPO() {
    }

    public LocalHashTableV2BucketSetDepthPO(byte depth, byte oldDepth) {
        this.depth = depth;
        this.oldDepth = oldDepth;
    }

    public byte getDepth() {
        return this.depth;
    }

    public byte getOldDepth() {
        return this.oldDepth;
    }

    @Override
    public void redo(OCacheEntry cacheEntry) {
        HashIndexBucketV2 bucket = new HashIndexBucketV2(cacheEntry);
        bucket.setDepth(this.depth);
    }

    @Override
    public void undo(OCacheEntry cacheEntry) {
        HashIndexBucketV2 bucket = new HashIndexBucketV2(cacheEntry);
        bucket.setDepth(this.oldDepth);
    }

    @Override
    public int getId() {
        return 178;
    }

    @Override
    public int serializedSize() {
        return super.serializedSize() + 2;
    }

    @Override
    protected void serializeToByteBuffer(ByteBuffer buffer) {
        super.serializeToByteBuffer(buffer);
        buffer.put(this.depth);
        buffer.put(this.oldDepth);
    }

    @Override
    protected void deserializeFromByteBuffer(ByteBuffer buffer) {
        super.deserializeFromByteBuffer(buffer);
        this.depth = buffer.get();
        this.oldDepth = buffer.get();
    }
}

