/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.storage.impl.local.paginated.wal.po.localhashtable.v2.bucket;

import com.orientechnologies.orient.core.storage.cache.OCacheEntry;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.po.PageOperationRecord;
import com.orientechnologies.orient.core.storage.index.hashindex.local.v2.HashIndexBucketV2;
import java.nio.ByteBuffer;

public final class LocalHashTableV2BucketUpdateEntryPO
extends PageOperationRecord {
    private int keySize;
    private int index;
    private byte[] value;
    private byte[] oldValue;

    public LocalHashTableV2BucketUpdateEntryPO() {
    }

    public LocalHashTableV2BucketUpdateEntryPO(int index, byte[] value, byte[] oldValue, int keySize) {
        this.index = index;
        this.value = value;
        this.oldValue = oldValue;
        this.keySize = keySize;
    }

    public int getKeySize() {
        return this.keySize;
    }

    public int getIndex() {
        return this.index;
    }

    public byte[] getValue() {
        return this.value;
    }

    public byte[] getOldValue() {
        return this.oldValue;
    }

    @Override
    public void redo(OCacheEntry cacheEntry) {
        HashIndexBucketV2 bucket = new HashIndexBucketV2(cacheEntry);
        bucket.updateEntry(this.index, this.value, this.oldValue, this.keySize);
    }

    @Override
    public void undo(OCacheEntry cacheEntry) {
        HashIndexBucketV2 bucket = new HashIndexBucketV2(cacheEntry);
        bucket.updateEntry(this.index, this.oldValue, this.value, this.keySize);
    }

    @Override
    public int getId() {
        return 175;
    }

    @Override
    public int serializedSize() {
        return super.serializedSize() + 16 + this.value.length + this.oldValue.length;
    }

    @Override
    protected void serializeToByteBuffer(ByteBuffer buffer) {
        super.serializeToByteBuffer(buffer);
        buffer.putInt(this.keySize);
        buffer.putInt(this.index);
        buffer.putInt(this.value.length);
        buffer.put(this.value);
        buffer.putInt(this.oldValue.length);
        buffer.put(this.oldValue);
    }

    @Override
    protected void deserializeFromByteBuffer(ByteBuffer buffer) {
        super.deserializeFromByteBuffer(buffer);
        this.keySize = buffer.getInt();
        this.index = buffer.getInt();
        int valueLen = buffer.getInt();
        this.value = new byte[valueLen];
        buffer.get(this.value);
        int oldValueLen = buffer.getInt();
        this.oldValue = new byte[oldValueLen];
        buffer.get(this.oldValue);
    }
}

