/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.storage.impl.local.paginated.wal.po.localhashtable.v2.directoryfirstpage;

import com.orientechnologies.orient.core.storage.cache.OCacheEntry;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.po.PageOperationRecord;
import com.orientechnologies.orient.core.storage.index.hashindex.local.v2.DirectoryFirstPageV2;
import java.nio.ByteBuffer;

public final class LocalHashTableV2DirectoryFirstPageSetMaxRightChildDepthPO
extends PageOperationRecord {
    private int localNodeIndex;
    private byte maxRightChildDepth;
    private byte pastMaxRightChildDepth;

    public LocalHashTableV2DirectoryFirstPageSetMaxRightChildDepthPO() {
    }

    public LocalHashTableV2DirectoryFirstPageSetMaxRightChildDepthPO(int localNodeIndex, byte maxRightChildDepth, byte pastMaxRightChildDepth) {
        this.localNodeIndex = localNodeIndex;
        this.maxRightChildDepth = maxRightChildDepth;
        this.pastMaxRightChildDepth = pastMaxRightChildDepth;
    }

    public int getLocalNodeIndex() {
        return this.localNodeIndex;
    }

    public byte getMaxRightChildDepth() {
        return this.maxRightChildDepth;
    }

    public byte getPastMaxRightChildDepth() {
        return this.pastMaxRightChildDepth;
    }

    @Override
    public void redo(OCacheEntry cacheEntry) {
        DirectoryFirstPageV2 page = new DirectoryFirstPageV2(cacheEntry);
        page.setMaxRightChildDepth(this.localNodeIndex, this.maxRightChildDepth);
    }

    @Override
    public void undo(OCacheEntry cacheEntry) {
        DirectoryFirstPageV2 page = new DirectoryFirstPageV2(cacheEntry);
        page.setMaxRightChildDepth(this.localNodeIndex, this.pastMaxRightChildDepth);
    }

    @Override
    public int getId() {
        return 191;
    }

    @Override
    public int serializedSize() {
        return super.serializedSize() + 4 + 2;
    }

    @Override
    protected void serializeToByteBuffer(ByteBuffer buffer) {
        super.serializeToByteBuffer(buffer);
        buffer.putInt(this.localNodeIndex);
        buffer.put(this.maxRightChildDepth);
        buffer.put(this.pastMaxRightChildDepth);
    }

    @Override
    protected void deserializeFromByteBuffer(ByteBuffer buffer) {
        super.deserializeFromByteBuffer(buffer);
        this.localNodeIndex = buffer.getInt();
        this.maxRightChildDepth = buffer.get();
        this.pastMaxRightChildDepth = buffer.get();
    }
}

