/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.storage.impl.local.paginated.wal.po.localhashtable.v2.directoryfirstpage;

import com.orientechnologies.orient.core.storage.cache.OCacheEntry;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.po.PageOperationRecord;
import com.orientechnologies.orient.core.storage.index.hashindex.local.v2.DirectoryFirstPageV2;
import java.nio.ByteBuffer;

public final class LocalHashTableV2DirectoryFirstPageSetPointerPO
extends PageOperationRecord {
    private int localNodeIndex;
    private int index;
    private long pointer;
    private long pastPointer;

    public LocalHashTableV2DirectoryFirstPageSetPointerPO() {
    }

    public LocalHashTableV2DirectoryFirstPageSetPointerPO(int localNodeIndex, int index, long pointer, long pastPointer) {
        this.localNodeIndex = localNodeIndex;
        this.index = index;
        this.pointer = pointer;
        this.pastPointer = pastPointer;
    }

    public int getLocalNodeIndex() {
        return this.localNodeIndex;
    }

    public int getIndex() {
        return this.index;
    }

    public long getPointer() {
        return this.pointer;
    }

    public long getPastPointer() {
        return this.pastPointer;
    }

    @Override
    public void redo(OCacheEntry cacheEntry) {
        DirectoryFirstPageV2 page = new DirectoryFirstPageV2(cacheEntry);
        page.setPointer(this.localNodeIndex, this.index, this.pointer);
    }

    @Override
    public void undo(OCacheEntry cacheEntry) {
        DirectoryFirstPageV2 page = new DirectoryFirstPageV2(cacheEntry);
        page.setPointer(this.localNodeIndex, this.index, this.pastPointer);
    }

    @Override
    public int getId() {
        return 193;
    }

    @Override
    public int serializedSize() {
        return super.serializedSize() + 8 + 16;
    }

    @Override
    protected void serializeToByteBuffer(ByteBuffer buffer) {
        super.serializeToByteBuffer(buffer);
        buffer.putInt(this.localNodeIndex);
        buffer.putInt(this.index);
        buffer.putLong(this.pointer);
        buffer.putLong(this.pastPointer);
    }

    @Override
    protected void deserializeFromByteBuffer(ByteBuffer buffer) {
        super.deserializeFromByteBuffer(buffer);
        this.localNodeIndex = buffer.getInt();
        this.index = buffer.getInt();
        this.pointer = buffer.getLong();
        this.pastPointer = buffer.getLong();
    }
}

