/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.storage.impl.local.paginated.wal.po.localhashtable.v2.nullbucket;

import com.orientechnologies.orient.core.storage.cache.OCacheEntry;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.po.PageOperationRecord;
import com.orientechnologies.orient.core.storage.index.hashindex.local.v2.HashIndexNullBucketV2;
import java.nio.ByteBuffer;

public class LocalHashTableV2NullBucketSetValuePO
extends PageOperationRecord {
    private byte[] prevValue;
    private byte[] value;

    public LocalHashTableV2NullBucketSetValuePO(byte[] prevValue, byte[] value) {
        this.prevValue = prevValue;
        this.value = value;
    }

    public LocalHashTableV2NullBucketSetValuePO() {
    }

    public byte[] getPrevValue() {
        return this.prevValue;
    }

    public byte[] getValue() {
        return this.value;
    }

    @Override
    public void redo(OCacheEntry cacheEntry) {
        HashIndexNullBucketV2 bucket = new HashIndexNullBucketV2(cacheEntry);
        bucket.setValue(this.value, this.prevValue);
    }

    @Override
    public void undo(OCacheEntry cacheEntry) {
        HashIndexNullBucketV2 bucket = new HashIndexNullBucketV2(cacheEntry);
        if (this.prevValue == null) {
            bucket.removeValue(this.value);
        } else {
            bucket.setValue(this.prevValue, this.value);
        }
    }

    @Override
    public int getId() {
        return 188;
    }

    @Override
    public int serializedSize() {
        int size = 4 + this.value.length + 1;
        if (this.prevValue != null) {
            size += 4 + this.prevValue.length;
        }
        return super.serializedSize() + size;
    }

    @Override
    protected void serializeToByteBuffer(ByteBuffer buffer) {
        super.serializeToByteBuffer(buffer);
        buffer.putInt(this.value.length);
        buffer.put(this.value);
        buffer.put(this.prevValue != null ? (byte)1 : 0);
        if (this.prevValue != null) {
            buffer.putInt(this.prevValue.length);
            buffer.put(this.prevValue);
        }
    }

    @Override
    protected void deserializeFromByteBuffer(ByteBuffer buffer) {
        super.deserializeFromByteBuffer(buffer);
        int valLen = buffer.getInt();
        this.value = new byte[valLen];
        buffer.get(this.value);
        if (buffer.get() > 0) {
            int pastValueLen = buffer.getInt();
            this.prevValue = new byte[pastValueLen];
            buffer.get(this.prevValue);
        }
    }
}

