/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.storage.impl.local.paginated.wal.po.sbtree.v1.bucket;

import com.orientechnologies.orient.core.storage.cache.OCacheEntry;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.po.PageOperationRecord;
import com.orientechnologies.orient.core.storage.index.sbtree.local.v1.OSBTreeBucketV1;
import java.nio.ByteBuffer;

public final class SBTreeBucketV1SetTreeSizePO
extends PageOperationRecord {
    private long prevTreeSize;
    private long treeSize;

    public SBTreeBucketV1SetTreeSizePO() {
    }

    public SBTreeBucketV1SetTreeSizePO(long prevTreeSize, long treeSize) {
        this.prevTreeSize = prevTreeSize;
        this.treeSize = treeSize;
    }

    public long getPrevTreeSize() {
        return this.prevTreeSize;
    }

    public long getTreeSize() {
        return this.treeSize;
    }

    @Override
    public void redo(OCacheEntry cacheEntry) {
        OSBTreeBucketV1 bucket = new OSBTreeBucketV1(cacheEntry);
        bucket.setTreeSize(this.treeSize);
    }

    @Override
    public void undo(OCacheEntry cacheEntry) {
        OSBTreeBucketV1 bucket = new OSBTreeBucketV1(cacheEntry);
        bucket.setTreeSize(this.prevTreeSize);
    }

    @Override
    public int getId() {
        return 119;
    }

    @Override
    public int serializedSize() {
        return super.serializedSize() + 16;
    }

    @Override
    protected void serializeToByteBuffer(ByteBuffer buffer) {
        super.serializeToByteBuffer(buffer);
        buffer.putLong(this.prevTreeSize);
        buffer.putLong(this.treeSize);
    }

    @Override
    protected void deserializeFromByteBuffer(ByteBuffer buffer) {
        super.deserializeFromByteBuffer(buffer);
        this.prevTreeSize = buffer.getLong();
        this.treeSize = buffer.getLong();
    }
}

