/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.storage.impl.local.paginated.wal.po.sbtree.v2.bucket;

import com.orientechnologies.common.serialization.types.OBinarySerializer;
import com.orientechnologies.orient.core.serialization.serializer.binary.OBinarySerializerFactory;
import com.orientechnologies.orient.core.storage.cache.OCacheEntry;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.po.PageOperationRecord;
import com.orientechnologies.orient.core.storage.index.sbtree.local.v2.OSBTreeBucketV2;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;

public final class SBTreeBucketV2AddAllPO
extends PageOperationRecord {
    private int prevSize;
    private List<byte[]> rawRecords;
    private OBinarySerializer keySerializer;
    private OBinarySerializer valueSerializer;

    public SBTreeBucketV2AddAllPO() {
    }

    public SBTreeBucketV2AddAllPO(int prevSize, List<byte[]> rawRecords, OBinarySerializer keySerializer, OBinarySerializer valueSerializer) {
        this.prevSize = prevSize;
        this.rawRecords = rawRecords;
        this.keySerializer = keySerializer;
        this.valueSerializer = valueSerializer;
    }

    public int getPrevSize() {
        return this.prevSize;
    }

    public List<byte[]> getRawRecords() {
        return this.rawRecords;
    }

    public OBinarySerializer getKeySerializer() {
        return this.keySerializer;
    }

    public OBinarySerializer getValueSerializer() {
        return this.valueSerializer;
    }

    @Override
    public void redo(OCacheEntry cacheEntry) {
        OSBTreeBucketV2 bucket = new OSBTreeBucketV2(cacheEntry);
        bucket.addAll(this.rawRecords, this.keySerializer, this.valueSerializer);
    }

    @Override
    public void undo(OCacheEntry cacheEntry) {
        OSBTreeBucketV2 bucket = new OSBTreeBucketV2(cacheEntry);
        bucket.shrink(this.prevSize, this.keySerializer, this.valueSerializer);
    }

    @Override
    public int getId() {
        return 109;
    }

    @Override
    public int serializedSize() {
        int serializedSize = 10 + 4 * this.rawRecords.size();
        for (byte[] record : this.rawRecords) {
            serializedSize += record.length;
        }
        return super.serializedSize() + serializedSize;
    }

    @Override
    protected void serializeToByteBuffer(ByteBuffer buffer) {
        super.serializeToByteBuffer(buffer);
        buffer.putInt(this.prevSize);
        buffer.put(this.keySerializer.getId());
        buffer.put(this.valueSerializer.getId());
        buffer.putInt(this.rawRecords.size());
        for (byte[] record : this.rawRecords) {
            buffer.putInt(record.length);
            buffer.put(record);
        }
    }

    @Override
    protected void deserializeFromByteBuffer(ByteBuffer buffer) {
        super.deserializeFromByteBuffer(buffer);
        this.prevSize = buffer.getInt();
        this.keySerializer = OBinarySerializerFactory.getInstance().getObjectSerializer(buffer.get());
        this.valueSerializer = OBinarySerializerFactory.getInstance().getObjectSerializer(buffer.get());
        this.rawRecords = new ArrayList<byte[]>();
        int recordsSize = buffer.getInt();
        for (int i = 0; i < recordsSize; ++i) {
            int recordSize = buffer.getInt();
            byte[] record = new byte[recordSize];
            buffer.get(record);
            this.rawRecords.add(record);
        }
    }
}

