/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.storage.impl.local.paginated.wal.po.sbtree.v2.bucket;

import com.orientechnologies.orient.core.storage.cache.OCacheEntry;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.po.PageOperationRecord;
import com.orientechnologies.orient.core.storage.index.sbtree.local.v2.OSBTreeBucketV2;
import java.nio.ByteBuffer;

public final class SBTreeBucketV2SetTreeSizePO
extends PageOperationRecord {
    private long prevTreeSize;
    private long treeSize;

    public SBTreeBucketV2SetTreeSizePO() {
    }

    public SBTreeBucketV2SetTreeSizePO(long prevTreeSize, long treeSize) {
        this.prevTreeSize = prevTreeSize;
        this.treeSize = treeSize;
    }

    public long getPrevTreeSize() {
        return this.prevTreeSize;
    }

    public long getTreeSize() {
        return this.treeSize;
    }

    @Override
    public void redo(OCacheEntry cacheEntry) {
        OSBTreeBucketV2 bucket = new OSBTreeBucketV2(cacheEntry);
        bucket.setTreeSize(this.treeSize);
    }

    @Override
    public void undo(OCacheEntry cacheEntry) {
        OSBTreeBucketV2 bucket = new OSBTreeBucketV2(cacheEntry);
        bucket.setTreeSize(this.prevTreeSize);
    }

    @Override
    public int getId() {
        return 120;
    }

    @Override
    public int serializedSize() {
        return super.serializedSize() + 16;
    }

    @Override
    protected void serializeToByteBuffer(ByteBuffer buffer) {
        super.serializeToByteBuffer(buffer);
        buffer.putLong(this.prevTreeSize);
        buffer.putLong(this.treeSize);
    }

    @Override
    protected void deserializeFromByteBuffer(ByteBuffer buffer) {
        super.deserializeFromByteBuffer(buffer);
        this.prevTreeSize = buffer.getLong();
        this.treeSize = buffer.getLong();
    }
}

