/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.storage.index.hashindex.local;

import com.orientechnologies.orient.core.exception.OConfigurationException;
import com.orientechnologies.orient.core.index.OIndexDictionary;
import com.orientechnologies.orient.core.index.OIndexException;
import com.orientechnologies.orient.core.index.OIndexFactory;
import com.orientechnologies.orient.core.index.OIndexInternal;
import com.orientechnologies.orient.core.index.OIndexNotUnique;
import com.orientechnologies.orient.core.index.OIndexUnique;
import com.orientechnologies.orient.core.index.engine.OBaseIndexEngine;
import com.orientechnologies.orient.core.index.engine.OIndexEngine;
import com.orientechnologies.orient.core.metadata.schema.OClass;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.storage.OStorage;
import com.orientechnologies.orient.core.storage.impl.local.OAbstractPaginatedStorage;
import com.orientechnologies.orient.core.storage.index.engine.OHashTableIndexEngine;
import com.orientechnologies.orient.core.storage.index.engine.ORemoteIndexEngine;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public final class OHashIndexFactory
implements OIndexFactory {
    private static final Set<String> TYPES;
    public static final String HASH_INDEX_ALGORITHM = "HASH_INDEX";
    private static final Set<String> ALGORITHMS;

    @Override
    public final Set<String> getTypes() {
        return TYPES;
    }

    @Override
    public final Set<String> getAlgorithms() {
        return ALGORITHMS;
    }

    @Override
    public final OIndexInternal createIndex(String name, OStorage storage, String indexType, String algorithm, String valueContainerAlgorithm, ODocument metadata, int version) throws OConfigurationException {
        if (version < 0) {
            version = this.getLastVersion(algorithm);
        }
        if (valueContainerAlgorithm == null) {
            valueContainerAlgorithm = "NONE";
        }
        int binaryFormatVersion = storage.getConfiguration().getBinaryFormatVersion();
        if (OClass.INDEX_TYPE.UNIQUE_HASH_INDEX.toString().equals(indexType)) {
            return new OIndexUnique(name, indexType, algorithm, version, (OAbstractPaginatedStorage)storage.getUnderlying(), valueContainerAlgorithm, metadata, binaryFormatVersion);
        }
        if (OClass.INDEX_TYPE.NOTUNIQUE_HASH_INDEX.toString().equals(indexType)) {
            return new OIndexNotUnique(name, indexType, algorithm, version, (OAbstractPaginatedStorage)storage.getUnderlying(), valueContainerAlgorithm, metadata, binaryFormatVersion);
        }
        if (OClass.INDEX_TYPE.DICTIONARY_HASH_INDEX.toString().equals(indexType)) {
            return new OIndexDictionary(name, indexType, algorithm, version, (OAbstractPaginatedStorage)storage.getUnderlying(), valueContainerAlgorithm, metadata, binaryFormatVersion);
        }
        throw new OConfigurationException("Unsupported type: " + indexType);
    }

    @Override
    public final int getLastVersion(String algorithm) {
        return 3;
    }

    @Override
    public final OBaseIndexEngine createIndexEngine(int indexId, String algorithm, String name, Boolean durableInNonTxMode, OStorage storage, int version, int apiVersion, boolean multiValue, Map<String, String> engineProperties) {
        OIndexEngine indexEngine;
        String storageType;
        switch (storageType = storage.getType()) {
            case "memory": 
            case "plocal": {
                indexEngine = new OHashTableIndexEngine(name, indexId, (OAbstractPaginatedStorage)storage, version);
                break;
            }
            case "distributed": {
                indexEngine = new OHashTableIndexEngine(name, indexId, (OAbstractPaginatedStorage)storage.getUnderlying(), version);
                break;
            }
            case "remote": {
                indexEngine = new ORemoteIndexEngine(indexId, name);
                break;
            }
            default: {
                throw new OIndexException("Unsupported storage type: " + storageType);
            }
        }
        return indexEngine;
    }

    static {
        HashSet<String> types = new HashSet<String>(4);
        types.add(OClass.INDEX_TYPE.UNIQUE_HASH_INDEX.toString());
        types.add(OClass.INDEX_TYPE.NOTUNIQUE_HASH_INDEX.toString());
        types.add(OClass.INDEX_TYPE.DICTIONARY_HASH_INDEX.toString());
        TYPES = Collections.unmodifiableSet(types);
        HashSet<String> algorithms = new HashSet<String>(1);
        algorithms.add(HASH_INDEX_ALGORITHM);
        ALGORITHMS = Collections.unmodifiableSet(algorithms);
    }
}

