/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.storage.index.hashindex.local.v2;

import com.orientechnologies.common.serialization.types.OBinarySerializer;
import com.orientechnologies.orient.core.storage.cache.OCacheEntry;
import com.orientechnologies.orient.core.storage.impl.local.paginated.base.ODurablePage;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.po.localhashtable.v2.nullbucket.LocalHashTableV2NullBucketInitPO;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.po.localhashtable.v2.nullbucket.LocalHashTableV2NullBucketRemoveValuePO;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.po.localhashtable.v2.nullbucket.LocalHashTableV2NullBucketSetValuePO;

public final class HashIndexNullBucketV2<V>
extends ODurablePage {
    public HashIndexNullBucketV2(OCacheEntry cacheEntry) {
        super(cacheEntry);
    }

    public void init() {
        this.setByteValue(28, (byte)0);
        this.addPageOperation(new LocalHashTableV2NullBucketInitPO());
    }

    public void setValue(byte[] value, byte[] oldValue) {
        assert (value != null);
        this.setByteValue(28, (byte)1);
        this.setBinaryValue(29, value);
        this.addPageOperation(new LocalHashTableV2NullBucketSetValuePO(oldValue, value));
    }

    public byte[] getRawValue(OBinarySerializer<V> valueSerializer) {
        if (this.getByteValue(28) == 0) {
            return null;
        }
        int valueSize = this.getObjectSizeInDirectMemory(valueSerializer, 29);
        return this.getBinaryValue(29, valueSize);
    }

    public V getValue(OBinarySerializer<V> valueSerializer) {
        if (this.getByteValue(28) == 0) {
            return null;
        }
        return this.deserializeFromDirectMemory(valueSerializer, 29);
    }

    public void removeValue(byte[] prevValue) {
        if (this.getByteValue(28) == 0) {
            return;
        }
        this.setByteValue(28, (byte)0);
        this.addPageOperation(new LocalHashTableV2NullBucketRemoveValuePO(prevValue));
    }
}

