/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.storage.index.hashindex.local.v2;

import com.orientechnologies.orient.core.storage.cache.OCacheEntry;
import com.orientechnologies.orient.core.storage.impl.local.OAbstractPaginatedStorage;
import com.orientechnologies.orient.core.storage.impl.local.paginated.atomicoperations.OAtomicOperation;
import com.orientechnologies.orient.core.storage.impl.local.paginated.base.ODurableComponent;
import com.orientechnologies.orient.core.storage.index.hashindex.local.v2.DirectoryFirstPageV2;
import com.orientechnologies.orient.core.storage.index.hashindex.local.v2.DirectoryPageV2;
import java.io.IOException;

public class HashTableDirectory
extends ODurableComponent {
    static final int ITEM_SIZE = 8;
    private static final int LEVEL_SIZE = 256;
    static final int BINARY_LEVEL_SIZE = 2051;
    private long fileId;
    private final long firstEntryIndex;

    HashTableDirectory(String defaultExtension, String name, String lockName, OAbstractPaginatedStorage storage) {
        super(storage, name, defaultExtension, lockName);
        this.firstEntryIndex = 0L;
    }

    public void create(OAtomicOperation atomicOperation) throws IOException {
        this.fileId = this.addFile(atomicOperation, this.getFullName());
        this.init(atomicOperation);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void init(OAtomicOperation atomicOperation) throws IOException {
        OCacheEntry firstEntry = HashTableDirectory.loadPageForWrite(atomicOperation, this.fileId, this.firstEntryIndex, true, true);
        if (firstEntry == null) {
            firstEntry = this.addPage(atomicOperation, this.fileId);
            assert (firstEntry.getPageIndex() == 0);
        }
        try {
            DirectoryFirstPageV2 firstPage = new DirectoryFirstPageV2(firstEntry);
            firstPage.setTreeSize(0);
            firstPage.setTombstone(-1);
        }
        finally {
            this.releasePageFromWrite(atomicOperation, firstEntry);
        }
    }

    public void open(OAtomicOperation atomicOperation) throws IOException {
        this.fileId = this.openFile(atomicOperation, this.getFullName());
        int filledUpTo = (int)this.getFilledUpTo(atomicOperation, this.fileId);
        for (int i = 0; i < filledUpTo; ++i) {
            OCacheEntry entry = this.loadPageForRead(atomicOperation, this.fileId, i, true);
            assert (entry != null);
            this.releasePageFromRead(atomicOperation, entry);
        }
    }

    public void close() throws IOException {
        this.readCache.closeFile(this.fileId, true, this.writeCache);
    }

    public void delete(OAtomicOperation atomicOperation) throws IOException {
        this.deleteFile(atomicOperation, this.fileId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int addNewNode(byte maxLeftChildDepth, byte maxRightChildDepth, byte nodeLocalDepth, long[] newNode, OAtomicOperation atomicOperation) throws IOException {
        int nodeIndex;
        block15: {
            OCacheEntry firstEntry = HashTableDirectory.loadPageForWrite(atomicOperation, this.fileId, this.firstEntryIndex, true, true);
            try {
                DirectoryFirstPageV2 firstPage = new DirectoryFirstPageV2(firstEntry);
                int tombstone = firstPage.getTombstone();
                if (tombstone >= 0) {
                    nodeIndex = tombstone;
                } else {
                    nodeIndex = firstPage.getTreeSize();
                    firstPage.setTreeSize(nodeIndex + 1);
                }
                if (nodeIndex < DirectoryFirstPageV2.NODES_PER_PAGE) {
                    int localNodeIndex = nodeIndex;
                    firstPage.setMaxLeftChildDepth(localNodeIndex, maxLeftChildDepth);
                    firstPage.setMaxRightChildDepth(localNodeIndex, maxRightChildDepth);
                    firstPage.setNodeLocalDepth(localNodeIndex, nodeLocalDepth);
                    if (tombstone >= 0) {
                        firstPage.setTombstone((int)firstPage.getPointer(nodeIndex, 0));
                    }
                    for (int i = 0; i < newNode.length; ++i) {
                        firstPage.setPointer(localNodeIndex, i, newNode[i]);
                    }
                    break block15;
                }
                int pageIndex = nodeIndex / DirectoryPageV2.NODES_PER_PAGE;
                int localLevel = nodeIndex % DirectoryPageV2.NODES_PER_PAGE;
                OCacheEntry cacheEntry = HashTableDirectory.loadPageForWrite(atomicOperation, this.fileId, pageIndex, true, true);
                while (cacheEntry == null || cacheEntry.getPageIndex() < pageIndex) {
                    if (cacheEntry != null) {
                        this.releasePageFromWrite(atomicOperation, cacheEntry);
                    }
                    cacheEntry = this.addPage(atomicOperation, this.fileId);
                }
                try {
                    DirectoryPageV2 page = new DirectoryPageV2(cacheEntry);
                    page.setMaxLeftChildDepth(localLevel, maxLeftChildDepth);
                    page.setMaxRightChildDepth(localLevel, maxRightChildDepth);
                    page.setNodeLocalDepth(localLevel, nodeLocalDepth);
                    if (tombstone >= 0) {
                        firstPage.setTombstone((int)page.getPointer(localLevel, 0));
                    }
                    for (int i = 0; i < newNode.length; ++i) {
                        page.setPointer(localLevel, i, newNode[i]);
                    }
                }
                finally {
                    this.releasePageFromWrite(atomicOperation, cacheEntry);
                }
            }
            finally {
                this.releasePageFromWrite(atomicOperation, firstEntry);
            }
        }
        return nodeIndex;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void deleteNode(int nodeIndex, OAtomicOperation atomicOperation) throws IOException {
        block7: {
            OCacheEntry firstEntry = HashTableDirectory.loadPageForWrite(atomicOperation, this.fileId, this.firstEntryIndex, true, true);
            try {
                DirectoryFirstPageV2 firstPage = new DirectoryFirstPageV2(firstEntry);
                if (nodeIndex < DirectoryFirstPageV2.NODES_PER_PAGE) {
                    firstPage.setPointer(nodeIndex, 0, firstPage.getTombstone());
                    firstPage.setTombstone(nodeIndex);
                    break block7;
                }
                int pageIndex = nodeIndex / DirectoryPageV2.NODES_PER_PAGE;
                int localNodeIndex = nodeIndex % DirectoryPageV2.NODES_PER_PAGE;
                OCacheEntry cacheEntry = HashTableDirectory.loadPageForWrite(atomicOperation, this.fileId, pageIndex, true, true);
                try {
                    DirectoryPageV2 page = new DirectoryPageV2(cacheEntry);
                    page.setPointer(localNodeIndex, 0, firstPage.getTombstone());
                    firstPage.setTombstone(nodeIndex);
                }
                finally {
                    this.releasePageFromWrite(atomicOperation, cacheEntry);
                }
            }
            finally {
                this.releasePageFromWrite(atomicOperation, firstEntry);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    byte getMaxLeftChildDepth(int nodeIndex, OAtomicOperation atomicOperation) throws IOException {
        DirectoryPageV2 page = this.loadPage(nodeIndex, false, atomicOperation);
        try {
            byte by = page.getMaxLeftChildDepth(HashTableDirectory.getLocalNodeIndex(nodeIndex));
            return by;
        }
        finally {
            this.releasePage(page, false, atomicOperation);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setMaxLeftChildDepth(int nodeIndex, byte maxLeftChildDepth, OAtomicOperation atomicOperation) throws IOException {
        DirectoryPageV2 page = this.loadPage(nodeIndex, true, atomicOperation);
        try {
            page.setMaxLeftChildDepth(HashTableDirectory.getLocalNodeIndex(nodeIndex), maxLeftChildDepth);
        }
        finally {
            this.releasePage(page, true, atomicOperation);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    byte getMaxRightChildDepth(int nodeIndex, OAtomicOperation atomicOperation) throws IOException {
        DirectoryPageV2 page = this.loadPage(nodeIndex, false, atomicOperation);
        try {
            byte by = page.getMaxRightChildDepth(HashTableDirectory.getLocalNodeIndex(nodeIndex));
            return by;
        }
        finally {
            this.releasePage(page, false, atomicOperation);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setMaxRightChildDepth(int nodeIndex, byte maxRightChildDepth, OAtomicOperation atomicOperation) throws IOException {
        DirectoryPageV2 page = this.loadPage(nodeIndex, true, atomicOperation);
        try {
            page.setMaxRightChildDepth(HashTableDirectory.getLocalNodeIndex(nodeIndex), maxRightChildDepth);
        }
        finally {
            this.releasePage(page, true, atomicOperation);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    byte getNodeLocalDepth(int nodeIndex, OAtomicOperation atomicOperation) throws IOException {
        DirectoryPageV2 page = this.loadPage(nodeIndex, false, atomicOperation);
        try {
            byte by = page.getNodeLocalDepth(HashTableDirectory.getLocalNodeIndex(nodeIndex));
            return by;
        }
        finally {
            this.releasePage(page, false, atomicOperation);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setNodeLocalDepth(int nodeIndex, byte localNodeDepth, OAtomicOperation atomicOperation) throws IOException {
        DirectoryPageV2 page = this.loadPage(nodeIndex, true, atomicOperation);
        try {
            page.setNodeLocalDepth(HashTableDirectory.getLocalNodeIndex(nodeIndex), localNodeDepth);
        }
        finally {
            this.releasePage(page, true, atomicOperation);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    long[] getNode(int nodeIndex, OAtomicOperation atomicOperation) throws IOException {
        long[] node = new long[256];
        DirectoryPageV2 page = this.loadPage(nodeIndex, false, atomicOperation);
        try {
            int localNodeIndex = HashTableDirectory.getLocalNodeIndex(nodeIndex);
            for (int i = 0; i < 256; ++i) {
                node[i] = page.getPointer(localNodeIndex, i);
            }
        }
        finally {
            this.releasePage(page, false, atomicOperation);
        }
        return node;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setNode(int nodeIndex, long[] node, OAtomicOperation atomicOperation) throws IOException {
        DirectoryPageV2 page = this.loadPage(nodeIndex, true, atomicOperation);
        try {
            int localNodeIndex = HashTableDirectory.getLocalNodeIndex(nodeIndex);
            for (int i = 0; i < 256; ++i) {
                page.setPointer(localNodeIndex, i, node[i]);
            }
        }
        finally {
            this.releasePage(page, true, atomicOperation);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    long getNodePointer(int nodeIndex, int index, OAtomicOperation atomicOperation) throws IOException {
        DirectoryPageV2 page = this.loadPage(nodeIndex, false, atomicOperation);
        try {
            long l = page.getPointer(HashTableDirectory.getLocalNodeIndex(nodeIndex), index);
            return l;
        }
        finally {
            this.releasePage(page, false, atomicOperation);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setNodePointer(int nodeIndex, int index, long pointer, OAtomicOperation atomicOperation) throws IOException {
        DirectoryPageV2 page = this.loadPage(nodeIndex, true, atomicOperation);
        try {
            page.setPointer(HashTableDirectory.getLocalNodeIndex(nodeIndex), index, pointer);
        }
        finally {
            this.releasePage(page, true, atomicOperation);
        }
    }

    public void clear(OAtomicOperation atomicOperation) throws IOException {
        this.truncateFile(atomicOperation, this.fileId);
        this.init(atomicOperation);
    }

    public void flush() {
        this.writeCache.flush(this.fileId);
    }

    private DirectoryPageV2 loadPage(int nodeIndex, boolean exclusiveLock, OAtomicOperation atomicOperation) throws IOException {
        if (nodeIndex < DirectoryFirstPageV2.NODES_PER_PAGE) {
            OCacheEntry cacheEntry = exclusiveLock ? HashTableDirectory.loadPageForWrite(atomicOperation, this.fileId, this.firstEntryIndex, true, true) : this.loadPageForRead(atomicOperation, this.fileId, this.firstEntryIndex, true);
            return new DirectoryFirstPageV2(cacheEntry);
        }
        int pageIndex = nodeIndex / DirectoryPageV2.NODES_PER_PAGE;
        OCacheEntry cacheEntry = exclusiveLock ? HashTableDirectory.loadPageForWrite(atomicOperation, this.fileId, pageIndex, true, true) : this.loadPageForRead(atomicOperation, this.fileId, pageIndex, true);
        return new DirectoryPageV2(cacheEntry);
    }

    private void releasePage(DirectoryPageV2 page, boolean exclusiveLock, OAtomicOperation atomicOperation) throws IOException {
        OCacheEntry cacheEntry = page.getCacheEntry();
        if (exclusiveLock) {
            this.releasePageFromWrite(atomicOperation, cacheEntry);
        } else {
            this.releasePageFromRead(atomicOperation, cacheEntry);
        }
    }

    private static int getLocalNodeIndex(int nodeIndex) {
        if (nodeIndex < DirectoryFirstPageV2.NODES_PER_PAGE) {
            return nodeIndex;
        }
        return (nodeIndex - DirectoryFirstPageV2.NODES_PER_PAGE) % DirectoryPageV2.NODES_PER_PAGE;
    }
}

