/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.storage.index.hashindex.local.v3;

import com.orientechnologies.orient.core.config.OGlobalConfiguration;
import com.orientechnologies.orient.core.storage.cache.OCacheEntry;
import com.orientechnologies.orient.core.storage.impl.local.paginated.base.ODurablePage;
import java.io.IOException;

public class ODirectoryPage
extends ODurablePage {
    private static final int ITEMS_OFFSET = 28;
    public static final int NODES_PER_PAGE = (OGlobalConfiguration.DISK_CACHE_PAGE_SIZE.getValueAsInteger() * 1024 - 28) / 2051;
    private final OCacheEntry entry;

    ODirectoryPage(OCacheEntry cacheEntry, OCacheEntry entry) {
        super(cacheEntry);
        this.entry = entry;
    }

    public OCacheEntry getEntry() {
        return this.entry;
    }

    void setMaxLeftChildDepth(int localNodeIndex, byte maxLeftChildDepth) {
        int offset = this.getItemsOffset() + localNodeIndex * 2051;
        this.setByteValue(offset, maxLeftChildDepth);
    }

    byte getMaxLeftChildDepth(int localNodeIndex) {
        int offset = this.getItemsOffset() + localNodeIndex * 2051;
        return this.getByteValue(offset);
    }

    void setMaxRightChildDepth(int localNodeIndex, byte maxRightChildDepth) {
        int offset = this.getItemsOffset() + localNodeIndex * 2051 + 1;
        this.setByteValue(offset, maxRightChildDepth);
    }

    byte getMaxRightChildDepth(int localNodeIndex) {
        int offset = this.getItemsOffset() + localNodeIndex * 2051 + 1;
        return this.getByteValue(offset);
    }

    void setNodeLocalDepth(int localNodeIndex, byte nodeLocalDepth) {
        int offset = this.getItemsOffset() + localNodeIndex * 2051 + 2;
        this.setByteValue(offset, nodeLocalDepth);
    }

    byte getNodeLocalDepth(int localNodeIndex) {
        int offset = this.getItemsOffset() + localNodeIndex * 2051 + 2;
        return this.getByteValue(offset);
    }

    void setPointer(int localNodeIndex, int index, long pointer) throws IOException {
        int offset = this.getItemsOffset() + (localNodeIndex * 2051 + 3) + index * 8;
        this.setLongValue(offset, pointer);
    }

    public long getPointer(int localNodeIndex, int index) {
        int offset = this.getItemsOffset() + (localNodeIndex * 2051 + 3) + index * 8;
        return this.getLongValue(offset);
    }

    protected int getItemsOffset() {
        return 28;
    }
}

