/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.storage.index.nkbtree.normalizers;

import com.orientechnologies.orient.core.storage.index.nkbtree.normalizers.KeyNormalizers;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.MathContext;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public class DecimalKeyNormalizer
implements KeyNormalizers {
    private static final BigInteger BIG_INT_TEN = new BigInteger("10");
    private static final BigInteger BIG_INT_ONE = new BigInteger("1");
    private static final BigInteger BIG_INT_ZERO = new BigInteger("0");
    private static final BigInteger TWO_COMPL_REF = BigInteger.ONE.shiftLeft(64);

    @Override
    public byte[] execute(Object key, int decomposition) throws IOException {
        BigDecimal matKey = (BigDecimal)key;
        ByteBuffer bb = ByteBuffer.allocate(9);
        bb.order(ByteOrder.BIG_ENDIAN);
        bb.put((byte)0);
        bb.putLong(Double.doubleToLongBits(matKey.doubleValue()) + Long.MAX_VALUE + 1L);
        return bb.array();
    }

    BigInteger unsigned(long value) {
        return BigInteger.valueOf(value >>> 1).shiftLeft(1).or(BigInteger.valueOf(value & 1L));
    }

    private BigDecimal scaleToDecimal128(BigDecimal rawValue) {
        BigDecimal value = this.clampAndRound(rawValue);
        long exponent = -value.scale();
        if (exponent >= -6176L && exponent <= 6111L) {
            if (value.unscaledValue().bitLength() > 113) {
                throw new AssertionError((Object)("Unscaled roundedValue is out of range for Decimal128 encoding:" + value.unscaledValue()));
            }
        } else {
            throw new AssertionError((Object)("Exponent is out of range for Decimal128 encoding: " + exponent));
        }
        return value;
    }

    private BigDecimal clampAndRound(BigDecimal initialValue) {
        BigDecimal value;
        if (-initialValue.scale() > 6111) {
            int diff = -initialValue.scale() - 6111;
            if (initialValue.unscaledValue().equals(BIG_INT_ZERO)) {
                value = new BigDecimal(initialValue.unscaledValue(), -6111);
            } else {
                if (diff + initialValue.precision() > 34) {
                    throw new NumberFormatException("Exponent is out of range for Decimal128 encoding of " + initialValue);
                }
                BigInteger multiplier = BIG_INT_TEN.pow(diff);
                value = new BigDecimal(initialValue.unscaledValue().multiply(multiplier), initialValue.scale() + diff);
            }
        } else if (-initialValue.scale() < -6176) {
            int diff = initialValue.scale() + -6176;
            int undiscardedPrecision = this.ensureExactRounding(initialValue, diff);
            BigInteger divisor = undiscardedPrecision == 0 ? BIG_INT_ONE : BIG_INT_TEN.pow(diff);
            value = new BigDecimal(initialValue.unscaledValue().divide(divisor), initialValue.scale() - diff);
        } else {
            value = initialValue.round(MathContext.DECIMAL128);
            int diff = initialValue.precision() - value.precision();
            if (diff > 0) {
                this.ensureExactRounding(initialValue, diff);
            }
        }
        return value;
    }

    private int ensureExactRounding(BigDecimal value, int extraPrecision) {
        int undiscardedPrecision;
        String significand = value.unscaledValue().abs().toString();
        for (int i = undiscardedPrecision = Math.max(0, significand.length() - extraPrecision); i < significand.length(); ++i) {
            if (significand.charAt(i) == '0') continue;
            throw new NumberFormatException("Conversion to Decimal128 would require inexact rounding of " + value);
        }
        return undiscardedPrecision;
    }
}

