/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.storage.index.nkbtree.normalizers;

import com.orientechnologies.orient.core.index.OCompositeKey;
import com.orientechnologies.orient.core.metadata.schema.OType;
import com.orientechnologies.orient.core.storage.index.nkbtree.normalizers.BinaryKeyNormalizer;
import com.orientechnologies.orient.core.storage.index.nkbtree.normalizers.BooleanKeyNormalizer;
import com.orientechnologies.orient.core.storage.index.nkbtree.normalizers.ByteKeyNormalizer;
import com.orientechnologies.orient.core.storage.index.nkbtree.normalizers.DateKeyNormalizer;
import com.orientechnologies.orient.core.storage.index.nkbtree.normalizers.DateTimeKeyNormalizer;
import com.orientechnologies.orient.core.storage.index.nkbtree.normalizers.DecimalKeyNormalizer;
import com.orientechnologies.orient.core.storage.index.nkbtree.normalizers.DoubleKeyNormalizer;
import com.orientechnologies.orient.core.storage.index.nkbtree.normalizers.FloatKeyNormalizer;
import com.orientechnologies.orient.core.storage.index.nkbtree.normalizers.IntegerKeyNormalizer;
import com.orientechnologies.orient.core.storage.index.nkbtree.normalizers.KeyNormalizers;
import com.orientechnologies.orient.core.storage.index.nkbtree.normalizers.LongKeyNormalizer;
import com.orientechnologies.orient.core.storage.index.nkbtree.normalizers.NullKeyNormalizer;
import com.orientechnologies.orient.core.storage.index.nkbtree.normalizers.ShortKeyNormalizer;
import com.orientechnologies.orient.core.storage.index.nkbtree.normalizers.StringKeyNormalizer;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;

public class KeyNormalizer {
    private final Map<OType, KeyNormalizers> normalizers = new HashMap<OType, KeyNormalizers>();

    public KeyNormalizer() {
        this.normalizers.put(null, new NullKeyNormalizer());
        this.normalizers.put(OType.INTEGER, new IntegerKeyNormalizer());
        this.normalizers.put(OType.FLOAT, new FloatKeyNormalizer());
        this.normalizers.put(OType.DOUBLE, new DoubleKeyNormalizer());
        this.normalizers.put(OType.SHORT, new ShortKeyNormalizer());
        this.normalizers.put(OType.BOOLEAN, new BooleanKeyNormalizer());
        this.normalizers.put(OType.BYTE, new ByteKeyNormalizer());
        this.normalizers.put(OType.LONG, new LongKeyNormalizer());
        this.normalizers.put(OType.STRING, new StringKeyNormalizer());
        this.normalizers.put(OType.DECIMAL, new DecimalKeyNormalizer());
        this.normalizers.put(OType.DATE, new DateKeyNormalizer());
        this.normalizers.put(OType.DATETIME, new DateTimeKeyNormalizer());
        this.normalizers.put(OType.BINARY, new BinaryKeyNormalizer());
    }

    public byte[] normalize(OCompositeKey keys2, OType[] keyTypes, int decompositon) {
        if (keys2 == null) {
            throw new IllegalArgumentException("Keys must not be null.");
        }
        if (keys2.getKeys().size() != keyTypes.length) {
            throw new IllegalArgumentException("Number of keys must fit to number of types: " + keys2.getKeys().size() + " != " + keyTypes.length + ".");
        }
        AtomicInteger counter = new AtomicInteger(0);
        return keys2.getKeys().stream().collect(ByteArrayOutputStream::new, (baos, key) -> this.normalizeCompositeKeys((ByteArrayOutputStream)baos, key, keyTypes[counter.getAndIncrement()], decompositon), (baos1, baos2) -> baos1.write(baos2.toByteArray(), 0, baos2.size())).toByteArray();
    }

    private void normalizeCompositeKeys(ByteArrayOutputStream normalizedKeyStream, Object key, OType keyType, int decompositon) {
        try {
            KeyNormalizers keyNormalizer = this.normalizers.get((Object)keyType);
            if (keyNormalizer == null) {
                throw new UnsupportedOperationException("Type " + key.getClass().getTypeName() + " is currently not supported");
            }
            normalizedKeyStream.write(keyNormalizer.execute(key, decompositon));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

