/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.storage.index.sbtree.local.v1;

import com.orientechnologies.common.comparator.ODefaultComparator;
import com.orientechnologies.common.serialization.types.OBinarySerializer;
import com.orientechnologies.orient.core.encryption.OEncryption;
import com.orientechnologies.orient.core.storage.cache.OCacheEntry;
import com.orientechnologies.orient.core.storage.cluster.OClusterPage;
import com.orientechnologies.orient.core.storage.impl.local.paginated.base.ODurablePage;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.po.sbtree.v1.bucket.SBTreeBucketV1AddAllPO;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.po.sbtree.v1.bucket.SBTreeBucketV1AddLeafEntryPO;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.po.sbtree.v1.bucket.SBTreeBucketV1AddNonLeafEntryPO;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.po.sbtree.v1.bucket.SBTreeBucketV1InitPO;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.po.sbtree.v1.bucket.SBTreeBucketV1RemoveLeafEntryPO;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.po.sbtree.v1.bucket.SBTreeBucketV1RemoveNonLeafEntryPO;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.po.sbtree.v1.bucket.SBTreeBucketV1SetLeftSiblingPO;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.po.sbtree.v1.bucket.SBTreeBucketV1SetRightSiblingPO;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.po.sbtree.v1.bucket.SBTreeBucketV1SetTreeSizePO;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.po.sbtree.v1.bucket.SBTreeBucketV1ShrinkPO;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.po.sbtree.v1.bucket.SBTreeBucketV1SwitchBucketTypePO;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.po.sbtree.v1.bucket.SBTreeBucketV1UpdateValuePO;
import com.orientechnologies.orient.core.storage.index.sbtree.local.v1.OSBTreeValue;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public final class OSBTreeBucketV1<K, V>
extends ODurablePage {
    private static final int FREE_POINTER_OFFSET = 28;
    private static final int SIZE_OFFSET = 32;
    private static final int IS_LEAF_OFFSET = 36;
    private static final int LEFT_SIBLING_OFFSET = 37;
    private static final int RIGHT_SIBLING_OFFSET = 45;
    private static final int TREE_SIZE_OFFSET = 53;
    private static final int KEY_SERIALIZER_OFFSET = 61;
    private static final int VALUE_SERIALIZER_OFFSET = 62;
    private static final int FREE_VALUES_LIST_OFFSET = 63;
    private static final int POSITIONS_ARRAY_OFFSET = 71;
    private final Comparator<? super K> comparator = ODefaultComparator.INSTANCE;

    public OSBTreeBucketV1(OCacheEntry cacheEntry) {
        super(cacheEntry);
    }

    public void init(boolean isLeaf) {
        this.setIntValue(28, MAX_PAGE_SIZE_BYTES);
        this.setIntValue(32, 0);
        this.setByteValue(36, (byte)(isLeaf ? 1 : 0));
        this.setLongValue(37, -1L);
        this.setLongValue(45, -1L);
        this.setLongValue(53, 0L);
        this.setLongValue(63, -1L);
        this.addPageOperation(new SBTreeBucketV1InitPO(isLeaf));
    }

    public void switchBucketType() {
        if (!this.isEmpty()) {
            throw new IllegalStateException("Type of bucket can be changed only bucket if bucket is empty");
        }
        boolean isLeaf = this.isLeaf();
        if (isLeaf) {
            this.setByteValue(36, (byte)0);
        } else {
            this.setByteValue(36, (byte)1);
        }
        this.addPageOperation(new SBTreeBucketV1SwitchBucketTypePO());
    }

    public void setTreeSize(long size) {
        long prevTreeSize = this.getLongValue(53);
        this.setLongValue(53, size);
        this.addPageOperation(new SBTreeBucketV1SetTreeSizePO(prevTreeSize, size));
    }

    public long getTreeSize() {
        return this.getLongValue(53);
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public int find(K key, OEncryption encryption, OBinarySerializer<K> keySerializer) {
        int low = 0;
        int high = this.size() - 1;
        while (low <= high) {
            int mid = low + high >>> 1;
            K midVal = this.getKey(mid, encryption, keySerializer);
            int cmp = this.comparator.compare(midVal, key);
            if (cmp < 0) {
                low = mid + 1;
                continue;
            }
            if (cmp > 0) {
                high = mid - 1;
                continue;
            }
            return mid;
        }
        return -(low + 1);
    }

    public void removeLeafEntry(int entryIndex, byte[] oldRawKey, byte[] oldRawValue) {
        if (!this.isLeaf()) {
            throw new IllegalStateException("This remove method is applied to leaf buckets only.");
        }
        int entryPosition = this.getIntValue(71 + entryIndex * 4);
        int entrySize = oldRawKey.length + oldRawValue.length + 1;
        int size = this.getIntValue(32);
        if (entryIndex < size - 1) {
            this.moveData(71 + (entryIndex + 1) * 4, 71 + entryIndex * 4, (size - entryIndex - 1) * 4);
        }
        this.setIntValue(32, --size);
        int freePointer = this.getIntValue(28);
        if (size > 0 && entryPosition > freePointer) {
            this.moveData(freePointer, freePointer + entrySize, entryPosition - freePointer);
        }
        this.setIntValue(28, freePointer + entrySize);
        int currentPositionOffset = 71;
        for (int i = 0; i < size; ++i) {
            int currentEntryPosition = this.getIntValue(currentPositionOffset);
            if (currentEntryPosition < entryPosition) {
                this.setIntValue(currentPositionOffset, currentEntryPosition + entrySize);
            }
            currentPositionOffset += 4;
        }
        this.addPageOperation(new SBTreeBucketV1RemoveLeafEntryPO(entryIndex, oldRawKey, oldRawValue));
    }

    public void removeNonLeafEntry(int entryIndex, byte[] key, int prevChild) {
        if (this.isLeaf()) {
            throw new IllegalStateException("This remove method is applied to non-leaf buckets only.");
        }
        int entryPosition = this.getIntValue(71 + entryIndex * 4);
        int entrySize = key.length + 16;
        int leftChild = (int)this.getLongValue(entryPosition);
        int rightChild = (int)this.getLongValue(entryPosition + 8);
        int size = this.getIntValue(32);
        if (entryIndex < size - 1) {
            this.moveData(71 + (entryIndex + 1) * 4, 71 + entryIndex * 4, (size - entryIndex - 1) * 4);
        }
        this.setIntValue(32, --size);
        int freePointer = this.getIntValue(28);
        if (size > 0 && entryPosition > freePointer) {
            this.moveData(freePointer, freePointer + entrySize, entryPosition - freePointer);
        }
        this.setIntValue(28, freePointer + entrySize);
        int currentPositionOffset = 71;
        for (int i = 0; i < size; ++i) {
            int currentEntryPosition = this.getIntValue(currentPositionOffset);
            if (currentEntryPosition < entryPosition) {
                this.setIntValue(currentPositionOffset, currentEntryPosition + entrySize);
            }
            currentPositionOffset += 4;
        }
        if (prevChild >= 0) {
            if (entryIndex > 0) {
                int prevEntryPosition = this.getIntValue(71 + (entryIndex - 1) * 4);
                this.setLongValue(prevEntryPosition + 8, prevChild);
            }
            if (entryIndex < size) {
                int nextEntryPosition = this.getIntValue(71 + entryIndex * 4);
                this.setLongValue(nextEntryPosition, prevChild);
            }
        }
        this.addPageOperation(new SBTreeBucketV1RemoveNonLeafEntryPO(entryIndex, prevChild, key, leftChild, rightChild));
    }

    public int size() {
        return this.getIntValue(32);
    }

    public SBTreeEntry<K, V> getEntry(int entryIndex, OEncryption encryption, OBinarySerializer<K> keySerializer, OBinarySerializer<V> valueSerializer) {
        K key;
        int entryPosition = this.getIntValue(entryIndex * 4 + 71);
        if (this.isLeaf()) {
            K key2;
            if (encryption == null) {
                key2 = this.deserializeFromDirectMemory(keySerializer, entryPosition);
                entryPosition += this.getObjectSizeInDirectMemory(keySerializer, entryPosition);
            } else {
                int encryptionSize = this.getIntValue(entryPosition);
                byte[] encryptedKey = this.getBinaryValue(entryPosition += 4, encryptionSize);
                entryPosition += encryptedKey.length;
                byte[] serializedKey = encryption.decrypt(encryptedKey);
                key2 = keySerializer.deserializeNativeObject(serializedKey, 0);
            }
            assert (this.getByteValue(entryPosition) == 0);
            V value = this.deserializeFromDirectMemory(valueSerializer, entryPosition + 1);
            return new SBTreeEntry<K, V>(-1L, -1L, key2, new OSBTreeValue<V>(false, -1L, value));
        }
        long leftChild = this.getLongValue(entryPosition);
        long rightChild = this.getLongValue(entryPosition += 8);
        entryPosition += 8;
        if (encryption == null) {
            key = this.deserializeFromDirectMemory(keySerializer, entryPosition);
        } else {
            int encryptionSize = this.getIntValue(entryPosition);
            byte[] encryptedKey = this.getBinaryValue(entryPosition += 4, encryptionSize);
            byte[] serializedKey = encryption.decrypt(encryptedKey);
            key = keySerializer.deserializeNativeObject(serializedKey, 0);
        }
        return new SBTreeEntry(leftChild, rightChild, key, null);
    }

    public byte[] getRawEntry(int entryIndex, boolean isEncrypted, OBinarySerializer<K> keySerializer, OBinarySerializer<V> valueSerializer) {
        int keySize;
        int entryPosition;
        int startEntryPosition = entryPosition = this.getIntValue(entryIndex * 4 + 71);
        if (this.isLeaf()) {
            int keySize2;
            if (!isEncrypted) {
                keySize2 = this.getObjectSizeInDirectMemory(keySerializer, entryPosition);
            } else {
                int encryptedSize = this.getIntValue(entryPosition);
                keySize2 = 4 + encryptedSize;
            }
            assert (this.getByteValue(entryPosition += keySize2) == 0);
            int valueSize = this.getObjectSizeInDirectMemory(valueSerializer, entryPosition + 1);
            return this.getBinaryValue(startEntryPosition, keySize2 + valueSize + 1);
        }
        entryPosition += 16;
        if (!isEncrypted) {
            keySize = this.getObjectSizeInDirectMemory(keySerializer, entryPosition);
        } else {
            int encryptedSize = this.getIntValue(entryPosition);
            keySize = 4 + encryptedSize;
        }
        return this.getBinaryValue(startEntryPosition, keySize + 16);
    }

    public OSBTreeValue<V> getValue(int entryIndex, boolean isEncrypted, OBinarySerializer<K> keySerializer, OBinarySerializer<V> valueSerializer) {
        assert (this.isLeaf());
        int entryPosition = this.getIntValue(entryIndex * 4 + 71);
        if (!isEncrypted) {
            entryPosition += this.getObjectSizeInDirectMemory(keySerializer, entryPosition);
        } else {
            int encryptedSize = this.getIntValue(entryPosition);
            entryPosition += 4 + encryptedSize;
        }
        assert (this.getByteValue(entryPosition) == 0);
        V value = this.deserializeFromDirectMemory(valueSerializer, entryPosition + 1);
        return new OSBTreeValue<V>(false, -1L, value);
    }

    byte[] getRawValue(int entryIndex, boolean isEncrypted, OBinarySerializer<K> keySerializer, OBinarySerializer<V> valueSerializer) {
        assert (this.isLeaf());
        int entryPosition = this.getIntValue(entryIndex * 4 + 71);
        if (!isEncrypted) {
            entryPosition += this.getObjectSizeInDirectMemory(keySerializer, entryPosition);
        } else {
            int encryptedSize = this.getIntValue(entryPosition);
            entryPosition += 4 + encryptedSize;
        }
        assert (this.getByteValue(entryPosition) == 0);
        int valueSize = this.getObjectSizeInDirectMemory(valueSerializer, entryPosition + 1);
        return this.getBinaryValue(entryPosition + 1, valueSize);
    }

    byte[] getRawKey(int entryIndex, boolean isEncrypted, OBinarySerializer<K> keySerializer) {
        byte[] rawKey;
        assert (this.isLeaf());
        int entryPosition = this.getIntValue(entryIndex * 4 + 71);
        if (!isEncrypted) {
            int keySize = this.getObjectSizeInDirectMemory(keySerializer, entryPosition);
            rawKey = this.getBinaryValue(entryPosition, keySize);
        } else {
            int encryptedSize = this.getIntValue(entryPosition);
            rawKey = this.getBinaryValue(entryPosition, 4 + encryptedSize);
        }
        return rawKey;
    }

    public K getKey(int index, OEncryption encryption, OBinarySerializer<K> keySerializer) {
        int entryPosition = this.getIntValue(index * 4 + 71);
        if (!this.isLeaf()) {
            entryPosition += 16;
        }
        if (encryption == null) {
            return this.deserializeFromDirectMemory(keySerializer, entryPosition);
        }
        int encryptedSize = this.getIntValue(entryPosition);
        byte[] encryptedKey = this.getBinaryValue(entryPosition += 4, encryptedSize);
        byte[] serializedKey = encryption.decrypt(encryptedKey);
        return keySerializer.deserializeNativeObject(serializedKey, 0);
    }

    public boolean isLeaf() {
        return this.getByteValue(36) > 0;
    }

    public void addAll(List<byte[]> rawEntries, boolean isEncrypted, OBinarySerializer<K> keySerializer, OBinarySerializer<V> valueSerializer) {
        int currentSize = this.size();
        for (int i = 0; i < rawEntries.size(); ++i) {
            this.appendRawEntry(i + currentSize, rawEntries.get(i));
        }
        this.setIntValue(32, rawEntries.size() + currentSize);
        this.addPageOperation(new SBTreeBucketV1AddAllPO(currentSize, rawEntries, isEncrypted, keySerializer, valueSerializer));
    }

    public void shrink(int newSize, boolean isEncrypted, OBinarySerializer<K> keySerializer, OBinarySerializer<V> valueSerializer) {
        List<byte[]> removedEntries;
        ArrayList<byte[]> rawEntries = new ArrayList<byte[]>(newSize);
        for (int i = 0; i < newSize; ++i) {
            rawEntries.add(this.getRawEntry(i, isEncrypted, keySerializer, valueSerializer));
        }
        int oldSize = this.getIntValue(32);
        if (newSize == oldSize) {
            removedEntries = Collections.emptyList();
        } else {
            removedEntries = new ArrayList(oldSize - newSize);
            for (int i = newSize; i < oldSize; ++i) {
                removedEntries.add(this.getRawEntry(i, isEncrypted, keySerializer, valueSerializer));
            }
        }
        this.setIntValue(28, OClusterPage.PAGE_SIZE);
        int index = 0;
        for (byte[] entry : rawEntries) {
            this.appendRawEntry(index, entry);
            ++index;
        }
        this.setIntValue(32, newSize);
        this.addPageOperation(new SBTreeBucketV1ShrinkPO(newSize, removedEntries, isEncrypted, keySerializer, valueSerializer));
    }

    public boolean addLeafEntry(int index, byte[] serializedKey, byte[] serializedValue) {
        assert (this.isLeaf());
        int entrySize = serializedKey.length + serializedValue.length + 1;
        int size = this.getIntValue(32);
        int freePointer = this.getIntValue(28);
        if (freePointer - entrySize < (size + 1) * 4 + 71) {
            return false;
        }
        if (index <= size - 1) {
            this.moveData(71 + index * 4, 71 + (index + 1) * 4, (size - index) * 4);
        }
        this.setIntValue(28, freePointer -= entrySize);
        this.setIntValue(71 + index * 4, freePointer);
        this.setIntValue(32, size + 1);
        this.setBinaryValue(freePointer, serializedKey);
        this.setByteValue(freePointer + serializedKey.length, (byte)0);
        this.setBinaryValue(freePointer + serializedKey.length + 1, serializedValue);
        this.addPageOperation(new SBTreeBucketV1AddLeafEntryPO(index, serializedKey, serializedValue));
        return true;
    }

    public boolean addNonLeafEntry(int index, byte[] key, long leftChild, long rightChild, boolean updateNeighbours) {
        assert (!this.isLeaf());
        int entrySize = key.length + 16;
        int size = this.size();
        int freePointer = this.getIntValue(28);
        if (freePointer - entrySize < (size + 1) * 4 + 71) {
            return false;
        }
        if (index <= size - 1) {
            this.moveData(71 + index * 4, 71 + (index + 1) * 4, (size - index) * 4);
        }
        this.setIntValue(28, freePointer -= entrySize);
        this.setIntValue(71 + index * 4, freePointer);
        this.setIntValue(32, size + 1);
        freePointer += this.setLongValue(freePointer, leftChild);
        freePointer += this.setLongValue(freePointer, rightChild);
        this.setBinaryValue(freePointer, key);
        int prevChild = -1;
        if (updateNeighbours && ++size > 1) {
            if (index < size - 1) {
                int nextEntryPosition = this.getIntValue(71 + (index + 1) * 4);
                prevChild = (int)this.getLongValue(nextEntryPosition);
                this.setLongValue(nextEntryPosition, rightChild);
            }
            if (index > 0) {
                int prevEntryPosition = this.getIntValue(71 + (index - 1) * 4);
                prevChild = (int)this.getLongValue(prevEntryPosition + 8);
                this.setLongValue(prevEntryPosition + 8, leftChild);
            }
        }
        this.addPageOperation(new SBTreeBucketV1AddNonLeafEntryPO(index, key, updateNeighbours, (int)leftChild, (int)rightChild, prevChild));
        return true;
    }

    private void appendRawEntry(int index, byte[] rawEntry) {
        int freePointer = this.getIntValue(28);
        this.setIntValue(28, freePointer -= rawEntry.length);
        this.setIntValue(71 + index * 4, freePointer);
        this.setBinaryValue(freePointer, rawEntry);
    }

    public void updateValue(int index, byte[] value, int keySize) {
        int entryPosition = this.getIntValue(index * 4 + 71) + keySize;
        assert (this.getByteValue(entryPosition) == 0);
        byte[] prevValue = this.getBinaryValue(++entryPosition, value.length);
        this.setBinaryValue(entryPosition, value);
        this.addPageOperation(new SBTreeBucketV1UpdateValuePO(index, keySize, prevValue, value));
    }

    public void setLeftSibling(long pageIndex) {
        int prevLeftSibling = (int)this.getLongValue(37);
        this.setLongValue(37, pageIndex);
        this.addPageOperation(new SBTreeBucketV1SetLeftSiblingPO(prevLeftSibling, (int)pageIndex));
    }

    public long getLeftSibling() {
        return this.getLongValue(37);
    }

    public void setRightSibling(long pageIndex) {
        int prevRightSibling = (int)this.getLongValue(45);
        this.setLongValue(45, pageIndex);
        this.addPageOperation(new SBTreeBucketV1SetRightSiblingPO(prevRightSibling, (int)pageIndex));
    }

    public long getRightSibling() {
        return this.getLongValue(45);
    }

    public static final class SBTreeEntry<K, V>
    implements Comparable<SBTreeEntry<K, V>> {
        private final Comparator<? super K> comparator = ODefaultComparator.INSTANCE;
        public final long leftChild;
        public final long rightChild;
        public final K key;
        public final OSBTreeValue<V> value;

        public SBTreeEntry(long leftChild, long rightChild, K key, OSBTreeValue<V> value) {
            this.leftChild = leftChild;
            this.rightChild = rightChild;
            this.key = key;
            this.value = value;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            SBTreeEntry that = (SBTreeEntry)o;
            if (this.leftChild != that.leftChild) {
                return false;
            }
            if (this.rightChild != that.rightChild) {
                return false;
            }
            if (!this.key.equals(that.key)) {
                return false;
            }
            return !(this.value != null ? !this.value.equals(that.value) : that.value != null);
        }

        public int hashCode() {
            int result = (int)(this.leftChild ^ this.leftChild >>> 32);
            result = 31 * result + (int)(this.rightChild ^ this.rightChild >>> 32);
            result = 31 * result + this.key.hashCode();
            result = 31 * result + (this.value != null ? this.value.hashCode() : 0);
            return result;
        }

        public String toString() {
            return "CellBTreeEntry{leftChild=" + this.leftChild + ", rightChild=" + this.rightChild + ", key=" + this.key + ", value=" + this.value + '}';
        }

        @Override
        public int compareTo(SBTreeEntry<K, V> other) {
            return this.comparator.compare(this.key, other.key);
        }
    }
}

