/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.storage.index.sbtree.local.v1;

import com.orientechnologies.common.comparator.ODefaultComparator;
import com.orientechnologies.common.exception.OException;
import com.orientechnologies.common.serialization.types.OBinarySerializer;
import com.orientechnologies.common.serialization.types.OIntegerSerializer;
import com.orientechnologies.common.util.ORawPair;
import com.orientechnologies.orient.core.config.OGlobalConfiguration;
import com.orientechnologies.orient.core.encryption.OEncryption;
import com.orientechnologies.orient.core.exception.NotEmptyComponentCanNotBeRemovedException;
import com.orientechnologies.orient.core.exception.OTooBigIndexKeyException;
import com.orientechnologies.orient.core.index.OAlwaysGreaterKey;
import com.orientechnologies.orient.core.index.OAlwaysLessKey;
import com.orientechnologies.orient.core.index.OCompositeKey;
import com.orientechnologies.orient.core.index.OIndexKeyUpdater;
import com.orientechnologies.orient.core.index.OIndexUpdateAction;
import com.orientechnologies.orient.core.index.engine.OBaseIndexEngine;
import com.orientechnologies.orient.core.iterator.OEmptyIterator;
import com.orientechnologies.orient.core.metadata.schema.OType;
import com.orientechnologies.orient.core.storage.cache.OCacheEntry;
import com.orientechnologies.orient.core.storage.impl.local.OAbstractPaginatedStorage;
import com.orientechnologies.orient.core.storage.impl.local.paginated.atomicoperations.OAtomicOperation;
import com.orientechnologies.orient.core.storage.impl.local.paginated.atomicoperations.OAtomicOperationsManager;
import com.orientechnologies.orient.core.storage.impl.local.paginated.base.ODurableComponent;
import com.orientechnologies.orient.core.storage.index.sbtree.local.OSBTree;
import com.orientechnologies.orient.core.storage.index.sbtree.local.v1.OSBTreeBucketV1;
import com.orientechnologies.orient.core.storage.index.sbtree.local.v1.OSBTreeException;
import com.orientechnologies.orient.core.storage.index.sbtree.local.v1.OSBTreeNullBucketV1;
import com.orientechnologies.orient.core.storage.index.sbtree.local.v1.OSBTreeValue;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Consumer;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

public final class OSBTreeV1<K, V>
extends ODurableComponent
implements OSBTree<K, V> {
    private static final int MAX_KEY_SIZE = OGlobalConfiguration.SBTREE_MAX_KEY_SIZE.getValueAsInteger();
    private static final int MAX_EMBEDDED_VALUE_SIZE = OGlobalConfiguration.SBTREE_MAX_EMBEDDED_VALUE_SIZE.getValueAsInteger();
    private static final OAlwaysLessKey ALWAYS_LESS_KEY = new OAlwaysLessKey();
    private static final OAlwaysGreaterKey ALWAYS_GREATER_KEY = new OAlwaysGreaterKey();
    private static final int MAX_PATH_LENGTH = OGlobalConfiguration.SBTREE_MAX_DEPTH.getValueAsInteger();
    private static final long ROOT_INDEX = 0L;
    private final Comparator<? super K> comparator = ODefaultComparator.INSTANCE;
    private final String nullFileExtension;
    private long fileId;
    private long nullBucketFileId = -1L;
    private int keySize;
    private OBinarySerializer<K> keySerializer;
    private OType[] keyTypes;
    private OBinarySerializer<V> valueSerializer;
    private boolean nullPointerSupport;
    private final AtomicLong bonsayFileId = new AtomicLong(0L);
    private OEncryption encryption;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OSBTreeV1(String name, String dataFileExtension, String nullFileExtension, OAbstractPaginatedStorage storage) {
        super(storage, name, dataFileExtension, name + dataFileExtension);
        this.acquireExclusiveLock();
        try {
            this.nullFileExtension = nullFileExtension;
        }
        finally {
            this.releaseExclusiveLock();
        }
    }

    @Override
    public void create(OAtomicOperation atomicOperation, OBinarySerializer<K> keySerializer, OBinarySerializer<V> valueSerializer, OType[] keyTypes, int keySize, boolean nullPointerSupport, OEncryption encryption) {
        assert (keySerializer != null);
        this.executeInsideComponentOperation(atomicOperation, operation -> {
            this.acquireExclusiveLock();
            try {
                this.keySize = keySize;
                this.keyTypes = keyTypes != null ? Arrays.copyOf(keyTypes, keyTypes.length) : null;
                this.encryption = encryption;
                this.keySerializer = keySerializer;
                this.valueSerializer = valueSerializer;
                this.nullPointerSupport = nullPointerSupport;
                this.fileId = this.addFile(atomicOperation, this.getFullName());
                if (nullPointerSupport) {
                    this.nullBucketFileId = this.addFile(atomicOperation, this.getName() + this.nullFileExtension);
                }
                OCacheEntry rootCacheEntry = this.addPage(atomicOperation, this.fileId);
                try {
                    OSBTreeBucketV1 rootBucket = new OSBTreeBucketV1(rootCacheEntry);
                    rootBucket.init(true);
                }
                finally {
                    this.releasePageFromWrite(atomicOperation, rootCacheEntry);
                }
            }
            finally {
                this.releaseExclusiveLock();
            }
        });
    }

    @Override
    public boolean isNullPointerSupport() {
        this.acquireSharedLock();
        try {
            boolean bl = this.nullPointerSupport;
            return bl;
        }
        finally {
            this.releaseSharedLock();
        }
    }

    /*
     * Exception decompiling
     */
    @Override
    public V get(K key) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [1[TRYBLOCK]], but top level block is 25[SIMPLE_IF_TAKEN]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public void put(OAtomicOperation atomicOperation, K key, V value) {
        this.put(atomicOperation, key, value, null);
    }

    @Override
    public boolean validatedPut(OAtomicOperation atomicOperation, K key, V value, OBaseIndexEngine.Validator<K, V> validator) {
        return this.put(atomicOperation, key, value, validator);
    }

    private boolean put(OAtomicOperation atomicOperation, K key, V value, OBaseIndexEngine.Validator<K, V> validator) {
        return this.update(atomicOperation, key, (x, bonsayFileId) -> OIndexUpdateAction.changed(value), validator);
    }

    @Override
    public boolean update(OAtomicOperation atomicOperation, K k, OIndexKeyUpdater<V> updater, OBaseIndexEngine.Validator<K, V> validator) {
        return this.calculateInsideComponentOperation(atomicOperation, operation -> {
            this.acquireExclusiveLock();
            try {
                Object key = k;
                this.checkNullSupport(key);
                if (key != null) {
                    key = this.keySerializer.preprocess(key, (Object[])this.keyTypes);
                    if (this.keySize > MAX_KEY_SIZE) {
                        throw new OTooBigIndexKeyException("Key size is more than allowed, operation was canceled. Current key size " + this.keySize + ", allowed  " + MAX_KEY_SIZE, this.getName());
                    }
                    BucketSearchResult bucketSearchResult = this.findBucket(key, atomicOperation);
                    OCacheEntry keyBucketCacheEntry = OSBTreeV1.loadPageForWrite(atomicOperation, this.fileId, bucketSearchResult.getLastPathItem(), false, true);
                    OSBTreeBucketV1<K, V> keyBucket = new OSBTreeBucketV1<K, V>(keyBucketCacheEntry);
                    byte[] oldRawValue = bucketSearchResult.itemIndex > -1 ? keyBucket.getRawValue(bucketSearchResult.itemIndex, this.encryption != null, this.keySerializer, this.valueSerializer) : null;
                    Object oldValue = oldRawValue == null ? null : (Object)this.valueSerializer.deserializeNativeObject(oldRawValue, 0);
                    OIndexUpdateAction<Object> updatedValue = updater.update(oldValue, this.bonsayFileId);
                    if (updatedValue.isChange()) {
                        int sizeDiff;
                        int insertionIndex;
                        boolean createLinkToTheValue;
                        Object value = updatedValue.getValue();
                        if (validator != null) {
                            boolean failure = true;
                            boolean ignored = false;
                            try {
                                Object result = validator.validate(key, oldValue, value);
                                if (result == OBaseIndexEngine.Validator.IGNORE) {
                                    ignored = true;
                                    failure = false;
                                    Boolean bl = false;
                                    return bl;
                                }
                                value = result;
                                failure = false;
                            }
                            finally {
                                if (failure || ignored) {
                                    this.releasePageFromWrite(atomicOperation, keyBucketCacheEntry);
                                }
                            }
                        }
                        int valueSize = this.valueSerializer.getObjectSize(value, new Object[0]);
                        byte[] serializeValue = new byte[valueSize];
                        this.valueSerializer.serializeNativeObject(value, serializeValue, 0, new Object[0]);
                        byte[] rawKey = this.serializeKey(key);
                        boolean bl = createLinkToTheValue = valueSize > MAX_EMBEDDED_VALUE_SIZE;
                        assert (!createLinkToTheValue);
                        if (bucketSearchResult.itemIndex >= 0) {
                            assert (oldRawValue != null);
                            if (oldRawValue.length == serializeValue.length) {
                                keyBucket.updateValue(bucketSearchResult.itemIndex, serializeValue, rawKey.length);
                                this.releasePageFromWrite(atomicOperation, keyBucketCacheEntry);
                                Boolean bl2 = true;
                                return bl2;
                            }
                            keyBucket.removeLeafEntry(bucketSearchResult.itemIndex, rawKey, oldRawValue);
                            insertionIndex = bucketSearchResult.itemIndex;
                            sizeDiff = 0;
                        } else {
                            insertionIndex = -bucketSearchResult.itemIndex - 1;
                            sizeDiff = 1;
                        }
                        while (!keyBucket.addLeafEntry(insertionIndex, rawKey, serializeValue)) {
                            this.releasePageFromWrite(atomicOperation, keyBucketCacheEntry);
                            bucketSearchResult = this.splitBucket(bucketSearchResult.path, insertionIndex, key, atomicOperation);
                            insertionIndex = bucketSearchResult.itemIndex;
                            keyBucketCacheEntry = OSBTreeV1.loadPageForWrite(atomicOperation, this.fileId, bucketSearchResult.getLastPathItem(), false, true);
                            keyBucket = new OSBTreeBucketV1(keyBucketCacheEntry);
                        }
                        this.releasePageFromWrite(atomicOperation, keyBucketCacheEntry);
                        if (sizeDiff != 0) {
                            this.updateSize(sizeDiff, atomicOperation);
                        }
                    } else if (updatedValue.isRemove()) {
                        byte[] rawKey = this.serializeKey(key);
                        this.removeKey(atomicOperation, bucketSearchResult, rawKey);
                        this.releasePageFromWrite(atomicOperation, keyBucketCacheEntry);
                    } else if (updatedValue.isNothing()) {
                        this.releasePageFromWrite(atomicOperation, keyBucketCacheEntry);
                    }
                } else {
                    OCacheEntry cacheEntry;
                    boolean isNew = false;
                    if (this.getFilledUpTo(atomicOperation, this.nullBucketFileId) == 0L) {
                        cacheEntry = this.addPage(atomicOperation, this.nullBucketFileId);
                        isNew = true;
                    } else {
                        cacheEntry = OSBTreeV1.loadPageForWrite(atomicOperation, this.nullBucketFileId, 0L, false, true);
                    }
                    int sizeDiff = 0;
                    try {
                        byte[] oldRawValue;
                        Object oldValue;
                        OIndexUpdateAction<Object> updatedValue;
                        OSBTreeNullBucketV1<V> nullBucket = new OSBTreeNullBucketV1<V>(cacheEntry);
                        if (isNew) {
                            nullBucket.init();
                        }
                        if ((updatedValue = updater.update(oldValue = Optional.ofNullable(oldRawValue = nullBucket.getRawValue(this.valueSerializer)).map(rawValue -> this.valueSerializer.deserializeNativeObject((byte[])rawValue, 0)).orElse(null), this.bonsayFileId)).isChange()) {
                            Object result;
                            Object value = updatedValue.getValue();
                            int valueSize = this.valueSerializer.getObjectSize(value, new Object[0]);
                            if (validator != null && (result = validator.validate(null, oldValue, value)) == OBaseIndexEngine.Validator.IGNORE) {
                                Boolean bl = false;
                                return bl;
                            }
                            if (oldValue != null) {
                                sizeDiff = -1;
                            }
                            byte[] serializeValue = new byte[valueSize];
                            this.valueSerializer.serializeNativeObject(value, serializeValue, 0, new Object[0]);
                            nullBucket.setValue(serializeValue, this.valueSerializer);
                        } else if (updatedValue.isRemove()) {
                            this.removeNullBucket(atomicOperation);
                        } else if (updatedValue.isNothing()) {
                            // empty if block
                        }
                    }
                    finally {
                        this.releasePageFromWrite(atomicOperation, cacheEntry);
                    }
                    this.updateSize(++sizeDiff, atomicOperation);
                }
                Boolean bl = true;
                return bl;
            }
            finally {
                this.releaseExclusiveLock();
            }
        });
    }

    private byte[] serializeKey(K key) {
        byte[] rawKey;
        byte[] serializedKey = this.keySerializer.serializeNativeAsWhole(key, (Object[])this.keyTypes);
        if (this.encryption == null) {
            rawKey = serializedKey;
        } else {
            byte[] encryptedKey = this.encryption.encrypt(serializedKey);
            rawKey = new byte[4 + encryptedKey.length];
            OIntegerSerializer.INSTANCE.serializeNative(encryptedKey.length, rawKey, 0, new Object[0]);
            System.arraycopy(encryptedKey, 0, rawKey, 4, encryptedKey.length);
        }
        return rawKey;
    }

    @Override
    public void close(boolean flush) {
        this.acquireExclusiveLock();
        try {
            this.readCache.closeFile(this.fileId, flush, this.writeCache);
            if (this.nullPointerSupport) {
                this.readCache.closeFile(this.nullBucketFileId, flush, this.writeCache);
            }
        }
        finally {
            this.releaseExclusiveLock();
        }
    }

    @Override
    public void close() {
        this.close(true);
    }

    @Override
    public void delete(OAtomicOperation atomicOperation) {
        this.executeInsideComponentOperation(atomicOperation, operation -> {
            this.acquireExclusiveLock();
            try {
                long size = this.size();
                if (size > 0L) {
                    throw new NotEmptyComponentCanNotBeRemovedException(this.getName() + " : Not empty index can not be deleted. Index has " + size + " records");
                }
                this.deleteFile(atomicOperation, this.fileId);
                if (this.nullPointerSupport) {
                    this.deleteFile(atomicOperation, this.nullBucketFileId);
                }
            }
            finally {
                this.releaseExclusiveLock();
            }
        });
    }

    @Override
    public void load(String name, OBinarySerializer<K> keySerializer, OBinarySerializer<V> valueSerializer, OType[] keyTypes, int keySize, boolean nullPointerSupport, OEncryption encryption) {
        this.acquireExclusiveLock();
        try {
            this.keySize = keySize;
            this.keyTypes = keyTypes != null ? Arrays.copyOf(keyTypes, keyTypes.length) : null;
            this.encryption = encryption;
            this.nullPointerSupport = nullPointerSupport;
            OAtomicOperation atomicOperation = OAtomicOperationsManager.getCurrentOperation();
            this.fileId = this.openFile(atomicOperation, this.getFullName());
            if (nullPointerSupport) {
                this.nullBucketFileId = this.openFile(atomicOperation, name + this.nullFileExtension);
            }
            this.keySerializer = keySerializer;
            this.valueSerializer = valueSerializer;
        }
        catch (IOException e) {
            throw OException.wrapException(new OSBTreeException("Exception during loading of sbtree " + name, this), e);
        }
        finally {
            this.releaseExclusiveLock();
        }
    }

    /*
     * Exception decompiling
     */
    @Override
    public long size() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public V remove(OAtomicOperation atomicOperation, K k) {
        return (V)this.calculateInsideComponentOperation(atomicOperation, operation -> {
            Object key = k;
            this.acquireExclusiveLock();
            try {
                V removedValue;
                if (key != null) {
                    BucketSearchResult bucketSearchResult = this.findBucket(key = this.keySerializer.preprocess(key, (Object[])this.keyTypes), atomicOperation);
                    if (bucketSearchResult.itemIndex < 0) {
                        Object var7_7 = null;
                        return var7_7;
                    }
                    byte[] rawKey = this.serializeKey(key);
                    byte[] rawRemovedValue = this.removeKey(atomicOperation, bucketSearchResult, rawKey);
                    removedValue = this.valueSerializer.deserializeNativeObject(rawRemovedValue, 0);
                } else {
                    if (this.getFilledUpTo(atomicOperation, this.nullBucketFileId) == 0L) {
                        Object var6_6 = null;
                        return var6_6;
                    }
                    removedValue = this.removeNullBucket(atomicOperation);
                }
                V v = removedValue;
                return v;
            }
            finally {
                this.releaseExclusiveLock();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private V removeNullBucket(OAtomicOperation atomicOperation) throws IOException {
        V removedValue;
        OCacheEntry nullCacheEntry = OSBTreeV1.loadPageForWrite(atomicOperation, this.nullBucketFileId, 0L, false, true);
        try {
            OSBTreeNullBucketV1<V> nullBucket = new OSBTreeNullBucketV1<V>(nullCacheEntry);
            OSBTreeValue treeValue = nullBucket.getValue(this.valueSerializer);
            if (treeValue != null) {
                removedValue = treeValue.getValue();
                nullBucket.removeValue(this.valueSerializer);
            } else {
                removedValue = null;
            }
        }
        finally {
            this.releasePageFromWrite(atomicOperation, nullCacheEntry);
        }
        if (removedValue != null) {
            this.updateSize(-1L, atomicOperation);
        }
        return removedValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] removeKey(OAtomicOperation atomicOperation, BucketSearchResult bucketSearchResult, byte[] key) throws IOException {
        byte[] removedValue;
        OCacheEntry keyBucketCacheEntry = OSBTreeV1.loadPageForWrite(atomicOperation, this.fileId, bucketSearchResult.getLastPathItem(), false, true);
        try {
            OSBTreeBucketV1<K, V> keyBucket = new OSBTreeBucketV1<K, V>(keyBucketCacheEntry);
            removedValue = keyBucket.getRawValue(bucketSearchResult.itemIndex, this.encryption != null, this.keySerializer, this.valueSerializer);
            keyBucket.removeLeafEntry(bucketSearchResult.itemIndex, key, removedValue);
        }
        finally {
            this.releasePageFromWrite(atomicOperation, keyBucketCacheEntry);
        }
        this.updateSize(-1L, atomicOperation);
        return removedValue;
    }

    @Override
    public Stream<ORawPair<K, V>> iterateEntriesMinor(K key, boolean inclusive, boolean ascSortOrder) {
        if (!ascSortOrder) {
            return StreamSupport.stream(this.iterateEntriesMinorDesc(key, inclusive), false);
        }
        return StreamSupport.stream(this.iterateEntriesMinorAsc(key, inclusive), false);
    }

    @Override
    public Stream<ORawPair<K, V>> iterateEntriesMajor(K key, boolean inclusive, boolean ascSortOrder) {
        if (ascSortOrder) {
            return StreamSupport.stream(this.iterateEntriesMajorAsc(key, inclusive), false);
        }
        return StreamSupport.stream(this.iterateEntriesMajorDesc(key, inclusive), false);
    }

    /*
     * Exception decompiling
     */
    @Override
    public K firstKey() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [1[TRYBLOCK]], but top level block is 14[SIMPLE_IF_TAKEN]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    @Override
    public K lastKey() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [1[TRYBLOCK]], but top level block is 14[SIMPLE_IF_TAKEN]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Stream<K> keyStream() {
        this.atomicOperationsManager.acquireReadLock(this);
        try {
            BucketSearchResult searchResult;
            block10: {
                Stream stream;
                this.acquireSharedLock();
                try {
                    OAtomicOperation atomicOperation = OAtomicOperationsManager.getCurrentOperation();
                    searchResult = this.firstItem(atomicOperation);
                    if (searchResult != null) break block10;
                    stream = StreamSupport.stream(Spliterators.emptySpliterator(), false);
                }
                catch (Throwable throwable) {
                    try {
                        this.releaseSharedLock();
                        throw throwable;
                    }
                    catch (IOException e) {
                        throw OException.wrapException(new OSBTreeException("Error during finding first key in sbtree [" + this.getName() + "]", this), e);
                    }
                }
                this.releaseSharedLock();
                return stream;
            }
            Stream stream = StreamSupport.stream(new OSBTreeFullKeyCursor(searchResult.getLastPathItem()), false);
            this.releaseSharedLock();
            return stream;
        }
        finally {
            this.atomicOperationsManager.releaseReadLock(this);
        }
    }

    @Override
    public Stream<ORawPair<K, V>> iterateEntriesBetween(K keyFrom, boolean fromInclusive, K keyTo, boolean toInclusive, boolean ascSortOrder) {
        if (ascSortOrder) {
            return StreamSupport.stream(this.iterateEntriesBetweenAscOrder(keyFrom, fromInclusive, keyTo, toInclusive), false);
        }
        return StreamSupport.stream(this.iterateEntriesBetweenDescOrder(keyFrom, fromInclusive, keyTo, toInclusive), false);
    }

    @Override
    public void flush() {
        this.atomicOperationsManager.acquireReadLock(this);
        try {
            this.acquireSharedLock();
            try {
                this.writeCache.flush();
            }
            finally {
                this.releaseSharedLock();
            }
        }
        finally {
            this.atomicOperationsManager.releaseReadLock(this);
        }
    }

    @Override
    public void acquireAtomicExclusiveLock() {
        this.atomicOperationsManager.acquireExclusiveLockTillOperationComplete(this);
    }

    private void checkNullSupport(K key) {
        if (key == null && !this.nullPointerSupport) {
            throw new OSBTreeException("Null keys are not supported.", this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateSize(long diffSize, OAtomicOperation atomicOperation) throws IOException {
        OCacheEntry rootCacheEntry = OSBTreeV1.loadPageForWrite(atomicOperation, this.fileId, 0L, false, true);
        try {
            OSBTreeBucketV1 rootBucket = new OSBTreeBucketV1(rootCacheEntry);
            rootBucket.setTreeSize(rootBucket.getTreeSize() + diffSize);
        }
        finally {
            this.releasePageFromWrite(atomicOperation, rootCacheEntry);
        }
    }

    private Spliterator<ORawPair<K, V>> iterateEntriesMinorDesc(K key, boolean inclusive) {
        key = this.keySerializer.preprocess(key, (Object[])this.keyTypes);
        key = this.enhanceCompositeKeyMinorDesc(key, inclusive);
        return new OSBTreeCursorBackward(null, key, false, inclusive);
    }

    private Spliterator<ORawPair<K, V>> iterateEntriesMinorAsc(K key, boolean inclusive) {
        key = this.keySerializer.preprocess(key, (Object[])this.keyTypes);
        key = this.enhanceCompositeKeyMinorAsc(key, inclusive);
        return new OSBTreeCursorForward(null, key, false, inclusive);
    }

    private K enhanceCompositeKeyMinorDesc(K key, boolean inclusive) {
        PartialSearchMode partialSearchMode = inclusive ? PartialSearchMode.HIGHEST_BOUNDARY : PartialSearchMode.LOWEST_BOUNDARY;
        key = this.enhanceCompositeKey(key, partialSearchMode);
        return key;
    }

    private K enhanceCompositeKeyMinorAsc(K key, boolean inclusive) {
        PartialSearchMode partialSearchMode = inclusive ? PartialSearchMode.HIGHEST_BOUNDARY : PartialSearchMode.LOWEST_BOUNDARY;
        key = this.enhanceCompositeKey(key, partialSearchMode);
        return key;
    }

    private Spliterator<ORawPair<K, V>> iterateEntriesMajorAsc(K key, boolean inclusive) {
        key = this.keySerializer.preprocess(key, (Object[])this.keyTypes);
        key = this.enhanceCompositeKeyMajorAsc(key, inclusive);
        return new OSBTreeCursorForward(key, null, inclusive, false);
    }

    private Spliterator<ORawPair<K, V>> iterateEntriesMajorDesc(K key, boolean inclusive) {
        key = this.keySerializer.preprocess(key, (Object[])this.keyTypes);
        key = this.enhanceCompositeKeyMajorDesc(key, inclusive);
        return new OSBTreeCursorBackward(key, null, inclusive, false);
    }

    private K enhanceCompositeKeyMajorAsc(K key, boolean inclusive) {
        PartialSearchMode partialSearchMode = inclusive ? PartialSearchMode.LOWEST_BOUNDARY : PartialSearchMode.HIGHEST_BOUNDARY;
        key = this.enhanceCompositeKey(key, partialSearchMode);
        return key;
    }

    private K enhanceCompositeKeyMajorDesc(K key, boolean inclusive) {
        PartialSearchMode partialSearchMode = inclusive ? PartialSearchMode.LOWEST_BOUNDARY : PartialSearchMode.HIGHEST_BOUNDARY;
        key = this.enhanceCompositeKey(key, partialSearchMode);
        return key;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private BucketSearchResult firstItem(OAtomicOperation atomicOperation) throws IOException {
        LinkedList<PagePathItemUnit> path = new LinkedList<PagePathItemUnit>();
        long bucketIndex = 0L;
        OCacheEntry cacheEntry = this.loadPageForRead(atomicOperation, this.fileId, bucketIndex, false);
        int itemIndex = 0;
        try {
            OSBTreeBucketV1<K, V> bucket = new OSBTreeBucketV1<K, V>(cacheEntry);
            while (true) {
                PagePathItemUnit pagePathItemUnit;
                if (!bucket.isLeaf()) {
                    if (bucket.isEmpty() || itemIndex > bucket.size()) {
                        if (path.isEmpty()) {
                            pagePathItemUnit = null;
                            return pagePathItemUnit;
                        }
                        pagePathItemUnit = (PagePathItemUnit)path.removeLast();
                        bucketIndex = pagePathItemUnit.pageIndex;
                        itemIndex = pagePathItemUnit.itemIndex + 1;
                    } else {
                        OSBTreeBucketV1.SBTreeEntry entry;
                        path.add(new PagePathItemUnit(bucketIndex, itemIndex));
                        if (itemIndex < bucket.size()) {
                            entry = bucket.getEntry(itemIndex, this.encryption, this.keySerializer, this.valueSerializer);
                            bucketIndex = entry.leftChild;
                        } else {
                            entry = bucket.getEntry(itemIndex - 1, this.encryption, this.keySerializer, this.valueSerializer);
                            bucketIndex = entry.rightChild;
                        }
                        itemIndex = 0;
                    }
                } else if (bucket.isEmpty()) {
                    if (path.isEmpty()) {
                        pagePathItemUnit = null;
                        return pagePathItemUnit;
                    }
                    pagePathItemUnit = (PagePathItemUnit)path.removeLast();
                    bucketIndex = pagePathItemUnit.pageIndex;
                    itemIndex = pagePathItemUnit.itemIndex + 1;
                } else {
                    ArrayList<Long> resultPath = new ArrayList<Long>(path.size() + 1);
                    Object object = path.iterator();
                    while (true) {
                        if (!object.hasNext()) {
                            resultPath.add(bucketIndex);
                            object = new BucketSearchResult(0, resultPath);
                            return object;
                        }
                        PagePathItemUnit pathItemUnit = (PagePathItemUnit)object.next();
                        resultPath.add(pathItemUnit.pageIndex);
                    }
                }
                this.releasePageFromRead(atomicOperation, cacheEntry);
                cacheEntry = this.loadPageForRead(atomicOperation, this.fileId, bucketIndex, false);
                bucket = new OSBTreeBucketV1(cacheEntry);
            }
        }
        finally {
            this.releasePageFromRead(atomicOperation, cacheEntry);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private BucketSearchResult lastItem(OAtomicOperation atomicOperation) throws IOException {
        LinkedList<PagePathItemUnit> path = new LinkedList<PagePathItemUnit>();
        long bucketIndex = 0L;
        OCacheEntry cacheEntry = this.loadPageForRead(atomicOperation, this.fileId, bucketIndex, false);
        OSBTreeBucketV1<K, V> bucket = new OSBTreeBucketV1<K, V>(cacheEntry);
        int itemIndex = bucket.size() - 1;
        try {
            while (true) {
                PagePathItemUnit pagePathItemUnit;
                if (!bucket.isLeaf()) {
                    if (itemIndex < -1) {
                        if (path.isEmpty()) {
                            pagePathItemUnit = null;
                            return pagePathItemUnit;
                        }
                        pagePathItemUnit = (PagePathItemUnit)path.removeLast();
                        bucketIndex = pagePathItemUnit.pageIndex;
                        itemIndex = pagePathItemUnit.itemIndex - 1;
                    } else {
                        OSBTreeBucketV1.SBTreeEntry entry;
                        path.add(new PagePathItemUnit(bucketIndex, itemIndex));
                        if (itemIndex > -1) {
                            entry = bucket.getEntry(itemIndex, this.encryption, this.keySerializer, this.valueSerializer);
                            bucketIndex = entry.rightChild;
                        } else {
                            entry = bucket.getEntry(0, this.encryption, this.keySerializer, this.valueSerializer);
                            bucketIndex = entry.leftChild;
                        }
                        itemIndex = OSBTreeBucketV1.MAX_PAGE_SIZE_BYTES + 1;
                    }
                } else if (bucket.isEmpty()) {
                    if (path.isEmpty()) {
                        pagePathItemUnit = null;
                        return pagePathItemUnit;
                    }
                    pagePathItemUnit = (PagePathItemUnit)path.removeLast();
                    bucketIndex = pagePathItemUnit.pageIndex;
                    itemIndex = pagePathItemUnit.itemIndex - 1;
                } else {
                    ArrayList<Long> resultPath = new ArrayList<Long>(path.size() + 1);
                    Object object = path.iterator();
                    while (true) {
                        if (!object.hasNext()) {
                            resultPath.add(bucketIndex);
                            object = new BucketSearchResult(bucket.size() - 1, resultPath);
                            return object;
                        }
                        PagePathItemUnit pathItemUnit = (PagePathItemUnit)object.next();
                        resultPath.add(pathItemUnit.pageIndex);
                    }
                }
                this.releasePageFromRead(atomicOperation, cacheEntry);
                cacheEntry = this.loadPageForRead(atomicOperation, this.fileId, bucketIndex, false);
                bucket = new OSBTreeBucketV1(cacheEntry);
                if (itemIndex != OSBTreeBucketV1.MAX_PAGE_SIZE_BYTES + 1) continue;
                itemIndex = bucket.size() - 1;
            }
        }
        finally {
            this.releasePageFromRead(atomicOperation, cacheEntry);
        }
    }

    private Spliterator<ORawPair<K, V>> iterateEntriesBetweenAscOrder(K keyFrom, boolean fromInclusive, K keyTo, boolean toInclusive) {
        keyFrom = this.keySerializer.preprocess(keyFrom, (Object[])this.keyTypes);
        keyTo = this.keySerializer.preprocess(keyTo, (Object[])this.keyTypes);
        keyFrom = this.enhanceFromCompositeKeyBetweenAsc(keyFrom, fromInclusive);
        keyTo = this.enhanceToCompositeKeyBetweenAsc(keyTo, toInclusive);
        return new OSBTreeCursorForward(keyFrom, keyTo, fromInclusive, toInclusive);
    }

    private Spliterator<ORawPair<K, V>> iterateEntriesBetweenDescOrder(K keyFrom, boolean fromInclusive, K keyTo, boolean toInclusive) {
        keyFrom = this.keySerializer.preprocess(keyFrom, (Object[])this.keyTypes);
        keyTo = this.keySerializer.preprocess(keyTo, (Object[])this.keyTypes);
        keyFrom = this.enhanceFromCompositeKeyBetweenDesc(keyFrom, fromInclusive);
        keyTo = this.enhanceToCompositeKeyBetweenDesc(keyTo, toInclusive);
        return new OSBTreeCursorBackward(keyFrom, keyTo, fromInclusive, toInclusive);
    }

    private K enhanceToCompositeKeyBetweenAsc(K keyTo, boolean toInclusive) {
        PartialSearchMode partialSearchModeTo = toInclusive ? PartialSearchMode.HIGHEST_BOUNDARY : PartialSearchMode.LOWEST_BOUNDARY;
        keyTo = this.enhanceCompositeKey(keyTo, partialSearchModeTo);
        return keyTo;
    }

    private K enhanceFromCompositeKeyBetweenAsc(K keyFrom, boolean fromInclusive) {
        PartialSearchMode partialSearchModeFrom = fromInclusive ? PartialSearchMode.LOWEST_BOUNDARY : PartialSearchMode.HIGHEST_BOUNDARY;
        keyFrom = this.enhanceCompositeKey(keyFrom, partialSearchModeFrom);
        return keyFrom;
    }

    private K enhanceToCompositeKeyBetweenDesc(K keyTo, boolean toInclusive) {
        PartialSearchMode partialSearchModeTo = toInclusive ? PartialSearchMode.HIGHEST_BOUNDARY : PartialSearchMode.LOWEST_BOUNDARY;
        keyTo = this.enhanceCompositeKey(keyTo, partialSearchModeTo);
        return keyTo;
    }

    private K enhanceFromCompositeKeyBetweenDesc(K keyFrom, boolean fromInclusive) {
        PartialSearchMode partialSearchModeFrom = fromInclusive ? PartialSearchMode.LOWEST_BOUNDARY : PartialSearchMode.HIGHEST_BOUNDARY;
        keyFrom = this.enhanceCompositeKey(keyFrom, partialSearchModeFrom);
        return keyFrom;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BucketSearchResult splitBucket(List<Long> path, int keyIndex, K keyToInsert, OAtomicOperation atomicOperation) throws IOException {
        long pageIndex = path.get(path.size() - 1);
        OCacheEntry bucketEntry = OSBTreeV1.loadPageForWrite(atomicOperation, this.fileId, pageIndex, false, true);
        try {
            int startRightIndex;
            OSBTreeBucketV1<K, V> bucketToSplit = new OSBTreeBucketV1<K, V>(bucketEntry);
            boolean splitLeaf = bucketToSplit.isLeaf();
            int bucketSize = bucketToSplit.size();
            int indexToSplit = bucketSize >>> 1;
            Object separationKey = bucketToSplit.getKey(indexToSplit, this.encryption, this.keySerializer);
            ArrayList<byte[]> rightEntries = new ArrayList<byte[]>(indexToSplit);
            for (int i = startRightIndex = splitLeaf ? indexToSplit : indexToSplit + 1; i < bucketSize; ++i) {
                rightEntries.add(bucketToSplit.getRawEntry(i, this.encryption != null, this.keySerializer, this.valueSerializer));
            }
            if (pageIndex != 0L) {
                BucketSearchResult bucketSearchResult = this.splitNonRootBucket(path, keyIndex, keyToInsert, pageIndex, bucketToSplit, splitLeaf, indexToSplit, separationKey, rightEntries, atomicOperation);
                return bucketSearchResult;
            }
            BucketSearchResult bucketSearchResult = this.splitRootBucket(path, keyIndex, keyToInsert, bucketEntry, bucketToSplit, splitLeaf, indexToSplit, separationKey, rightEntries, atomicOperation);
            return bucketSearchResult;
        }
        finally {
            this.releasePageFromWrite(atomicOperation, bucketEntry);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BucketSearchResult splitNonRootBucket(List<Long> path, int keyIndex, K keyToInsert, long pageIndex, OSBTreeBucketV1<K, V> bucketToSplit, boolean splitLeaf, int indexToSplit, K separationKey, List<byte[]> rightEntries, OAtomicOperation atomicOperation) throws IOException {
        OCacheEntry rightBucketEntry = this.addPage(atomicOperation, this.fileId);
        try {
            OSBTreeBucketV1<K, V> newRightBucket = new OSBTreeBucketV1<K, V>(rightBucketEntry);
            newRightBucket.init(splitLeaf);
            newRightBucket.addAll(rightEntries, this.encryption != null, this.keySerializer, this.valueSerializer);
            bucketToSplit.shrink(indexToSplit, this.encryption != null, this.keySerializer, this.valueSerializer);
            if (splitLeaf) {
                long rightSiblingPageIndex = bucketToSplit.getRightSibling();
                newRightBucket.setRightSibling(rightSiblingPageIndex);
                newRightBucket.setLeftSibling(pageIndex);
                bucketToSplit.setRightSibling(rightBucketEntry.getPageIndex());
                if (rightSiblingPageIndex >= 0L) {
                    OCacheEntry rightSiblingBucketEntry = OSBTreeV1.loadPageForWrite(atomicOperation, this.fileId, rightSiblingPageIndex, false, true);
                    OSBTreeBucketV1 rightSiblingBucket = new OSBTreeBucketV1(rightSiblingBucketEntry);
                    try {
                        rightSiblingBucket.setLeftSibling(rightBucketEntry.getPageIndex());
                    }
                    finally {
                        this.releasePageFromWrite(atomicOperation, rightSiblingBucketEntry);
                    }
                }
            }
            long parentIndex = path.get(path.size() - 2);
            OCacheEntry parentCacheEntry = OSBTreeV1.loadPageForWrite(atomicOperation, this.fileId, parentIndex, false, true);
            try {
                OSBTreeBucketV1 parentBucket = new OSBTreeBucketV1(parentCacheEntry);
                int insertionIndex = parentBucket.find(separationKey, this.encryption, this.keySerializer);
                assert (insertionIndex < 0);
                insertionIndex = -insertionIndex - 1;
                byte[] rawSeparationKey = this.serializeKey(separationKey);
                while (!parentBucket.addNonLeafEntry(insertionIndex, rawSeparationKey, pageIndex, rightBucketEntry.getPageIndex(), true)) {
                    this.releasePageFromWrite(atomicOperation, parentCacheEntry);
                    BucketSearchResult bucketSearchResult = this.splitBucket(path.subList(0, path.size() - 1), insertionIndex, separationKey, atomicOperation);
                    parentIndex = bucketSearchResult.getLastPathItem();
                    parentCacheEntry = OSBTreeV1.loadPageForWrite(atomicOperation, this.fileId, parentIndex, false, true);
                    insertionIndex = bucketSearchResult.itemIndex;
                    parentBucket = new OSBTreeBucketV1(parentCacheEntry);
                }
            }
            finally {
                this.releasePageFromWrite(atomicOperation, parentCacheEntry);
            }
        }
        finally {
            this.releasePageFromWrite(atomicOperation, rightBucketEntry);
        }
        ArrayList<Long> resultPath = new ArrayList<Long>(path.subList(0, path.size() - 1));
        if (this.comparator.compare(keyToInsert, separationKey) < 0) {
            resultPath.add(pageIndex);
            return new BucketSearchResult(keyIndex, resultPath);
        }
        resultPath.add(Long.valueOf(rightBucketEntry.getPageIndex()));
        if (splitLeaf) {
            return new BucketSearchResult(keyIndex - indexToSplit, resultPath);
        }
        resultPath.add(Long.valueOf(rightBucketEntry.getPageIndex()));
        return new BucketSearchResult(keyIndex - indexToSplit - 1, resultPath);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BucketSearchResult splitRootBucket(List<Long> path, int keyIndex, K keyToInsert, OCacheEntry bucketEntry, OSBTreeBucketV1<K, V> bucketToSplit, boolean splitLeaf, int indexToSplit, K separationKey, List<byte[]> rightEntries, OAtomicOperation atomicOperation) throws IOException {
        long treeSize = bucketToSplit.getTreeSize();
        ArrayList<byte[]> leftEntries = new ArrayList<byte[]>(indexToSplit);
        for (int i = 0; i < indexToSplit; ++i) {
            leftEntries.add(bucketToSplit.getRawEntry(i, this.encryption != null, this.keySerializer, this.valueSerializer));
        }
        OCacheEntry leftBucketEntry = this.addPage(atomicOperation, this.fileId);
        OCacheEntry rightBucketEntry = this.addPage(atomicOperation, this.fileId);
        try {
            OSBTreeBucketV1<K, V> newLeftBucket = new OSBTreeBucketV1<K, V>(leftBucketEntry);
            newLeftBucket.init(splitLeaf);
            newLeftBucket.addAll(leftEntries, this.encryption != null, this.keySerializer, this.valueSerializer);
            if (splitLeaf) {
                newLeftBucket.setRightSibling(rightBucketEntry.getPageIndex());
            }
        }
        finally {
            this.releasePageFromWrite(atomicOperation, leftBucketEntry);
        }
        try {
            OSBTreeBucketV1<K, V> newRightBucket = new OSBTreeBucketV1<K, V>(rightBucketEntry);
            newRightBucket.init(splitLeaf);
            newRightBucket.addAll(rightEntries, this.encryption != null, this.keySerializer, this.valueSerializer);
            if (splitLeaf) {
                newRightBucket.setLeftSibling(leftBucketEntry.getPageIndex());
            }
        }
        finally {
            this.releasePageFromWrite(atomicOperation, rightBucketEntry);
        }
        bucketToSplit = new OSBTreeBucketV1(bucketEntry);
        bucketToSplit.shrink(0, this.encryption != null, this.keySerializer, this.valueSerializer);
        if (splitLeaf) {
            bucketToSplit.switchBucketType();
        }
        bucketToSplit.setTreeSize(treeSize);
        bucketToSplit.addNonLeafEntry(0, this.serializeKey(separationKey), leftBucketEntry.getPageIndex(), rightBucketEntry.getPageIndex(), true);
        ArrayList<Long> resultPath = new ArrayList<Long>(path.subList(0, path.size() - 1));
        if (this.comparator.compare(keyToInsert, separationKey) < 0) {
            resultPath.add(Long.valueOf(leftBucketEntry.getPageIndex()));
            return new BucketSearchResult(keyIndex, resultPath);
        }
        resultPath.add(Long.valueOf(rightBucketEntry.getPageIndex()));
        if (splitLeaf) {
            return new BucketSearchResult(keyIndex - indexToSplit, resultPath);
        }
        return new BucketSearchResult(keyIndex - indexToSplit - 1, resultPath);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BucketSearchResult findBucket(K key, OAtomicOperation atomicOperation) throws IOException {
        long pageIndex = 0L;
        ArrayList<Long> path = new ArrayList<Long>(8);
        while (true) {
            OSBTreeBucketV1.SBTreeEntry entry;
            if (path.size() > MAX_PATH_LENGTH) {
                throw new OSBTreeException("We reached max level of depth of SBTree but still found nothing, seems like tree is in corrupted state. You should rebuild index related to given query.", this);
            }
            path.add(pageIndex);
            OCacheEntry bucketEntry = this.loadPageForRead(atomicOperation, this.fileId, pageIndex, false);
            try {
                int insertionIndex;
                OSBTreeBucketV1<K, V> keyBucket = new OSBTreeBucketV1<K, V>(bucketEntry);
                int index = keyBucket.find(key, this.encryption, this.keySerializer);
                if (keyBucket.isLeaf()) {
                    BucketSearchResult bucketSearchResult = new BucketSearchResult(index, path);
                    return bucketSearchResult;
                }
                entry = index >= 0 ? keyBucket.getEntry(index, this.encryption, this.keySerializer, this.valueSerializer) : ((insertionIndex = -index - 1) >= keyBucket.size() ? keyBucket.getEntry(insertionIndex - 1, this.encryption, this.keySerializer, this.valueSerializer) : keyBucket.getEntry(insertionIndex, this.encryption, this.keySerializer, this.valueSerializer));
            }
            finally {
                this.releasePageFromRead(atomicOperation, bucketEntry);
            }
            if (this.comparator.compare(key, entry.key) >= 0) {
                pageIndex = entry.rightChild;
                continue;
            }
            pageIndex = entry.leftChild;
        }
    }

    private K enhanceCompositeKey(K key, PartialSearchMode partialSearchMode) {
        if (!(key instanceof OCompositeKey)) {
            return key;
        }
        OCompositeKey compositeKey = (OCompositeKey)key;
        if (this.keySize != 1 && compositeKey.getKeys().size() != this.keySize && !partialSearchMode.equals((Object)PartialSearchMode.NONE)) {
            OCompositeKey fullKey = new OCompositeKey(compositeKey);
            int itemsToAdd = this.keySize - fullKey.getKeys().size();
            Comparable<Comparable<?>> keyItem = partialSearchMode.equals((Object)PartialSearchMode.HIGHEST_BOUNDARY) ? ALWAYS_GREATER_KEY : ALWAYS_LESS_KEY;
            for (int i = 0; i < itemsToAdd; ++i) {
                fullKey.addKey(keyItem);
            }
            return (K)fullKey;
        }
        return key;
    }

    private ORawPair<K, V> convertToMapEntry(OSBTreeBucketV1.SBTreeEntry<K, V> treeEntry) {
        Object key = treeEntry.key;
        Object value = treeEntry.value.getValue();
        return new ORawPair(key, value);
    }

    private final class OSBTreeCursorBackward
    implements Spliterator<ORawPair<K, V>> {
        private final K fromKey;
        private K toKey;
        private final boolean fromKeyInclusive;
        private boolean toKeyInclusive;
        private final List<ORawPair<K, V>> dataCache = new ArrayList();
        private Iterator<ORawPair<K, V>> dataCacheIterator = Collections.emptyIterator();

        private OSBTreeCursorBackward(K fromKey, K toKey, boolean fromKeyInclusive, boolean toKeyInclusive) {
            this.fromKey = fromKey;
            this.toKey = toKey;
            this.fromKeyInclusive = fromKeyInclusive;
            this.toKeyInclusive = toKeyInclusive;
            if (toKey == null) {
                this.toKeyInclusive = true;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean tryAdvance(Consumer<? super ORawPair<K, V>> action) {
            if (this.dataCacheIterator == null) {
                return false;
            }
            if (this.dataCacheIterator.hasNext()) {
                ORawPair entry = this.dataCacheIterator.next();
                this.toKey = entry.first;
                this.toKeyInclusive = false;
                action.accept(entry);
                return true;
            }
            this.dataCache.clear();
            int prefetchSize = OGlobalConfiguration.INDEX_CURSOR_PREFETCH_SIZE.getValueAsInteger();
            OSBTreeV1.this.atomicOperationsManager.acquireReadLock(OSBTreeV1.this);
            try {
                OSBTreeV1.this.acquireSharedLock();
                try {
                    OAtomicOperation atomicOperation = OAtomicOperationsManager.getCurrentOperation();
                    BucketSearchResult bucketSearchResult = this.toKey != null ? OSBTreeV1.this.findBucket(this.toKey, atomicOperation) : OSBTreeV1.this.lastItem(atomicOperation);
                    if (bucketSearchResult == null) {
                        this.dataCacheIterator = null;
                        boolean bl = false;
                        return bl;
                    }
                    long pageIndex = bucketSearchResult.getLastPathItem();
                    int itemIndex = bucketSearchResult.itemIndex >= 0 ? (this.toKeyInclusive ? bucketSearchResult.itemIndex : bucketSearchResult.itemIndex - 1) : -bucketSearchResult.itemIndex - 2;
                    while (this.dataCache.size() < prefetchSize) {
                        if (pageIndex == -1L) {
                            break;
                        }
                        OCacheEntry cacheEntry = OSBTreeV1.this.loadPageForRead(atomicOperation, OSBTreeV1.this.fileId, pageIndex, false);
                        try {
                            OSBTreeBucketV1 bucket = new OSBTreeBucketV1(cacheEntry);
                            if (itemIndex >= bucket.size()) {
                                itemIndex = bucket.size() - 1;
                            }
                            if (itemIndex < 0) {
                                pageIndex = bucket.getLeftSibling();
                                itemIndex = Integer.MAX_VALUE;
                                continue;
                            }
                            ORawPair entry = OSBTreeV1.this.convertToMapEntry(bucket.getEntry(itemIndex, OSBTreeV1.this.encryption, OSBTreeV1.this.keySerializer, OSBTreeV1.this.valueSerializer));
                            --itemIndex;
                            if (this.toKey != null && (!this.toKeyInclusive ? OSBTreeV1.this.comparator.compare(entry.first, this.toKey) >= 0 : OSBTreeV1.this.comparator.compare(entry.first, this.toKey) > 0)) continue;
                            if (this.fromKey == null || !(this.fromKeyInclusive ? OSBTreeV1.this.comparator.compare(entry.first, this.fromKey) < 0 : OSBTreeV1.this.comparator.compare(entry.first, this.fromKey) <= 0)) {
                                this.dataCache.add(entry);
                                continue;
                            }
                            break;
                        }
                        finally {
                            OSBTreeV1.this.releasePageFromRead(atomicOperation, cacheEntry);
                        }
                    }
                }
                finally {
                    OSBTreeV1.this.releaseSharedLock();
                }
            }
            catch (IOException e) {
                throw OException.wrapException(new OSBTreeException("Error during element iteration", OSBTreeV1.this), e);
            }
            finally {
                OSBTreeV1.this.atomicOperationsManager.releaseReadLock(OSBTreeV1.this);
            }
            if (this.dataCache.isEmpty()) {
                this.dataCacheIterator = null;
                return false;
            }
            this.dataCacheIterator = this.dataCache.iterator();
            ORawPair entry = this.dataCacheIterator.next();
            this.toKey = entry.first;
            this.toKeyInclusive = false;
            action.accept(entry);
            return true;
        }

        @Override
        public Spliterator<ORawPair<K, V>> trySplit() {
            return null;
        }

        @Override
        public long estimateSize() {
            return Long.MAX_VALUE;
        }

        @Override
        public int characteristics() {
            return 276;
        }

        @Override
        public Comparator<? super ORawPair<K, V>> getComparator() {
            return (pairOne, pairTwo) -> -OSBTreeV1.this.comparator.compare(pairOne.first, pairTwo.first);
        }
    }

    private final class OSBTreeCursorForward
    implements Spliterator<ORawPair<K, V>> {
        private K fromKey;
        private final K toKey;
        private boolean fromKeyInclusive;
        private final boolean toKeyInclusive;
        private final List<ORawPair<K, V>> dataCache = new ArrayList();
        private Iterator<ORawPair<K, V>> dataCacheIterator = Collections.emptyIterator();

        private OSBTreeCursorForward(K fromKey, K toKey, boolean fromKeyInclusive, boolean toKeyInclusive) {
            this.fromKey = fromKey;
            this.toKey = toKey;
            this.fromKeyInclusive = fromKeyInclusive;
            this.toKeyInclusive = toKeyInclusive;
            if (fromKey == null) {
                this.fromKeyInclusive = true;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean tryAdvance(Consumer<? super ORawPair<K, V>> action) {
            if (this.dataCacheIterator == null) {
                return false;
            }
            if (this.dataCacheIterator.hasNext()) {
                ORawPair entry = this.dataCacheIterator.next();
                this.fromKey = entry.first;
                this.fromKeyInclusive = false;
                action.accept(entry);
                return true;
            }
            this.dataCache.clear();
            int prefetchSize = OGlobalConfiguration.INDEX_CURSOR_PREFETCH_SIZE.getValueAsInteger();
            OSBTreeV1.this.atomicOperationsManager.acquireReadLock(OSBTreeV1.this);
            try {
                OSBTreeV1.this.acquireSharedLock();
                try {
                    OAtomicOperation atomicOperation = OAtomicOperationsManager.getCurrentOperation();
                    BucketSearchResult bucketSearchResult = this.fromKey != null ? OSBTreeV1.this.findBucket(this.fromKey, atomicOperation) : OSBTreeV1.this.firstItem(atomicOperation);
                    if (bucketSearchResult == null) {
                        this.dataCacheIterator = null;
                        boolean bl = false;
                        return bl;
                    }
                    long pageIndex = bucketSearchResult.getLastPathItem();
                    int itemIndex = bucketSearchResult.itemIndex >= 0 ? (this.fromKeyInclusive ? bucketSearchResult.itemIndex : bucketSearchResult.itemIndex + 1) : -bucketSearchResult.itemIndex - 1;
                    while (this.dataCache.size() < prefetchSize) {
                        if (pageIndex == -1L) {
                            break;
                        }
                        OCacheEntry cacheEntry = OSBTreeV1.this.loadPageForRead(atomicOperation, OSBTreeV1.this.fileId, pageIndex, false);
                        try {
                            OSBTreeBucketV1 bucket = new OSBTreeBucketV1(cacheEntry);
                            if (itemIndex >= bucket.size()) {
                                pageIndex = bucket.getRightSibling();
                                itemIndex = 0;
                                continue;
                            }
                            ORawPair entry = OSBTreeV1.this.convertToMapEntry(bucket.getEntry(itemIndex, OSBTreeV1.this.encryption, OSBTreeV1.this.keySerializer, OSBTreeV1.this.valueSerializer));
                            ++itemIndex;
                            if (this.fromKey != null && (!this.fromKeyInclusive ? OSBTreeV1.this.comparator.compare(entry.first, this.fromKey) <= 0 : OSBTreeV1.this.comparator.compare(entry.first, this.fromKey) < 0)) continue;
                            if (this.toKey == null || !(this.toKeyInclusive ? OSBTreeV1.this.comparator.compare(entry.first, this.toKey) > 0 : OSBTreeV1.this.comparator.compare(entry.first, this.toKey) >= 0)) {
                                this.dataCache.add(entry);
                                continue;
                            }
                            break;
                        }
                        finally {
                            OSBTreeV1.this.releasePageFromRead(atomicOperation, cacheEntry);
                        }
                    }
                }
                finally {
                    OSBTreeV1.this.releaseSharedLock();
                }
            }
            catch (IOException e) {
                throw OException.wrapException(new OSBTreeException("Error during element iteration", OSBTreeV1.this), e);
            }
            finally {
                OSBTreeV1.this.atomicOperationsManager.releaseReadLock(OSBTreeV1.this);
            }
            if (this.dataCache.isEmpty()) {
                this.dataCacheIterator = null;
                return false;
            }
            this.dataCacheIterator = this.dataCache.iterator();
            ORawPair entry = this.dataCacheIterator.next();
            this.fromKey = entry.first;
            this.fromKeyInclusive = false;
            action.accept(entry);
            return true;
        }

        @Override
        public Spliterator<ORawPair<K, V>> trySplit() {
            return null;
        }

        @Override
        public long estimateSize() {
            return Long.MAX_VALUE;
        }

        @Override
        public int characteristics() {
            return 276;
        }

        @Override
        public Comparator<? super ORawPair<K, V>> getComparator() {
            return (pairOne, pairTwo) -> OSBTreeV1.this.comparator.compare(pairOne.first, pairTwo.first);
        }
    }

    private class OSBTreeFullKeyCursor
    implements Spliterator<K> {
        private long pageIndex;
        private int itemIndex;
        private List<K> keysCache = new ArrayList();
        private Iterator<K> keysIterator = new OEmptyIterator();

        private OSBTreeFullKeyCursor(long startPageIndex) {
            this.pageIndex = startPageIndex;
            this.itemIndex = 0;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public boolean tryAdvance(Consumer<? super K> action) {
            if (this.keysIterator == null) {
                return false;
            }
            if (this.keysIterator.hasNext()) {
                action.accept(this.keysIterator.next());
                return true;
            }
            this.keysCache.clear();
            int prefetchSize = OGlobalConfiguration.INDEX_CURSOR_PREFETCH_SIZE.getValueAsInteger();
            OSBTreeV1.this.atomicOperationsManager.acquireReadLock(OSBTreeV1.this);
            try {
                OSBTreeV1.this.acquireSharedLock();
                try {
                    OAtomicOperation atomicOperation = OAtomicOperationsManager.getCurrentOperation();
                    while (this.pageIndex != -1L) {
                        if (this.pageIndex >= OSBTreeV1.this.getFilledUpTo(atomicOperation, OSBTreeV1.this.fileId)) {
                            this.pageIndex = -1L;
                            break;
                        }
                        OCacheEntry cacheEntry = OSBTreeV1.this.loadPageForRead(atomicOperation, OSBTreeV1.this.fileId, this.pageIndex, false);
                        try {
                            OSBTreeBucketV1 bucket = new OSBTreeBucketV1(cacheEntry);
                            if (this.itemIndex >= bucket.size()) {
                                this.pageIndex = bucket.getRightSibling();
                                this.itemIndex = 0;
                                if (this.keysCache.size() < prefetchSize) continue;
                                break;
                            }
                            Object key = bucket.getEntry((int)this.itemIndex, (OEncryption)((OSBTreeV1)OSBTreeV1.this).encryption, ((OSBTreeV1)OSBTreeV1.this).keySerializer, ((OSBTreeV1)OSBTreeV1.this).valueSerializer).key;
                            ++this.itemIndex;
                            this.keysCache.add(key);
                        }
                        finally {
                            OSBTreeV1.this.releasePageFromRead(atomicOperation, cacheEntry);
                        }
                    }
                }
                finally {
                    OSBTreeV1.this.releaseSharedLock();
                }
            }
            catch (IOException e) {
                throw OException.wrapException(new OSBTreeException("Error during element iteration", OSBTreeV1.this), e);
            }
            finally {
                OSBTreeV1.this.atomicOperationsManager.releaseReadLock(OSBTreeV1.this);
            }
            if (this.keysCache.isEmpty()) {
                this.keysCache = null;
                return false;
            }
            this.keysIterator = this.keysCache.iterator();
            action.accept(this.keysIterator.next());
            return true;
        }

        @Override
        public Spliterator<K> trySplit() {
            return null;
        }

        @Override
        public long estimateSize() {
            return Long.MAX_VALUE;
        }

        @Override
        public int characteristics() {
            return 276;
        }

        @Override
        public Comparator<? super K> getComparator() {
            return OSBTreeV1.this.comparator;
        }
    }

    private static final class PagePathItemUnit {
        private final long pageIndex;
        private final int itemIndex;

        private PagePathItemUnit(long pageIndex, int itemIndex) {
            this.pageIndex = pageIndex;
            this.itemIndex = itemIndex;
        }
    }

    private static class BucketSearchResult {
        private final int itemIndex;
        private final ArrayList<Long> path;

        private BucketSearchResult(int itemIndex, ArrayList<Long> path) {
            this.itemIndex = itemIndex;
            this.path = path;
        }

        long getLastPathItem() {
            return this.path.get(this.path.size() - 1);
        }
    }

    private static enum PartialSearchMode {
        NONE,
        HIGHEST_BOUNDARY,
        LOWEST_BOUNDARY;

    }
}

