/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.storage.index.sbtree.singlevalue.v1;

import com.orientechnologies.orient.core.id.ORID;
import com.orientechnologies.orient.core.id.ORecordId;
import com.orientechnologies.orient.core.storage.cache.OCacheEntry;
import com.orientechnologies.orient.core.storage.impl.local.paginated.base.ODurablePage;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.po.cellbtree.singlevalue.v1.nullbucket.CellBTreeNullBucketSingleValueV1InitPO;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.po.cellbtree.singlevalue.v1.nullbucket.CellBTreeNullBucketSingleValueV1RemoveValuePO;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.po.cellbtree.singlevalue.v1.nullbucket.CellBTreeNullBucketSingleValueV1SetValuePO;

public final class CellBTreeNullBucketSingleValueV1
extends ODurablePage {
    public CellBTreeNullBucketSingleValueV1(OCacheEntry cacheEntry) {
        super(cacheEntry);
    }

    public void init() {
        this.setByteValue(28, (byte)0);
        this.addPageOperation(new CellBTreeNullBucketSingleValueV1InitPO());
    }

    public void setValue(ORID value) {
        ORID prevValue = this.getValue();
        this.setByteValue(28, (byte)1);
        this.setShortValue(29, (short)value.getClusterId());
        this.setLongValue(31, value.getClusterPosition());
        this.addPageOperation(new CellBTreeNullBucketSingleValueV1SetValuePO(prevValue, value));
    }

    public ORID getValue() {
        if (this.getByteValue(28) == 0) {
            return null;
        }
        short clusterId = this.getShortValue(29);
        long clusterPosition = this.getLongValue(31);
        return new ORecordId(clusterId, clusterPosition);
    }

    public void removeValue() {
        ORID value = this.getValue();
        this.setByteValue(28, (byte)0);
        this.addPageOperation(new CellBTreeNullBucketSingleValueV1RemoveValuePO(value));
    }
}

