/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.storage.index.sbtree.singlevalue.v3;

import com.orientechnologies.orient.core.id.ORID;
import com.orientechnologies.orient.core.id.ORecordId;
import com.orientechnologies.orient.core.storage.cache.OCacheEntry;
import com.orientechnologies.orient.core.storage.impl.local.paginated.base.ODurablePage;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.po.cellbtree.singlevalue.v3.nullbucket.CellBTreeNullBucketSingleValueV3InitPO;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.po.cellbtree.singlevalue.v3.nullbucket.CellBTreeNullBucketSingleValueV3RemoveValuePO;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.po.cellbtree.singlevalue.v3.nullbucket.CellBTreeNullBucketSingleValueV3SetValuePO;

public final class CellBTreeSingleValueV3NullBucket
extends ODurablePage {
    public CellBTreeSingleValueV3NullBucket(OCacheEntry cacheEntry) {
        super(cacheEntry);
    }

    public void init() {
        this.setByteValue(28, (byte)0);
        this.addPageOperation(new CellBTreeNullBucketSingleValueV3InitPO());
    }

    public void setValue(ORID value) {
        ORID prevValue = this.getValue();
        this.setByteValue(28, (byte)1);
        this.setShortValue(29, (short)value.getClusterId());
        this.setLongValue(31, value.getClusterPosition());
        this.addPageOperation(new CellBTreeNullBucketSingleValueV3SetValuePO(prevValue, value));
    }

    public ORID getValue() {
        if (this.getByteValue(28) == 0) {
            return null;
        }
        short clusterId = this.getShortValue(29);
        long clusterPosition = this.getLongValue(31);
        return new ORecordId(clusterId, clusterPosition);
    }

    public void removeValue() {
        ORID prevValue = this.getValue();
        this.setByteValue(28, (byte)0);
        this.addPageOperation(new CellBTreeNullBucketSingleValueV3RemoveValuePO(prevValue));
    }
}

