/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.storage.memory;

import com.orientechnologies.orient.core.command.OCommandOutputListener;
import com.orientechnologies.orient.core.config.OContextConfiguration;
import com.orientechnologies.orient.core.config.OGlobalConfiguration;
import com.orientechnologies.orient.core.storage.impl.local.OAbstractPaginatedStorage;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.OLogSequenceNumber;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.OMemoryWriteAheadLog;
import com.orientechnologies.orient.core.storage.impl.local.paginated.wal.OWriteAheadLog;
import com.orientechnologies.orient.core.storage.memory.ODirectMemoryOnlyDiskCache;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.zip.ZipOutputStream;

public class ODirectMemoryStorage
extends OAbstractPaginatedStorage {
    private static final int ONE_KB = 1024;

    public ODirectMemoryStorage(String name, String filePath, String mode, int id) {
        super(name, filePath, mode, id);
    }

    @Override
    protected void initWalAndDiskCache(OContextConfiguration contextConfiguration) {
        if (this.writeAheadLog == null) {
            this.writeAheadLog = new OMemoryWriteAheadLog();
        }
        ODirectMemoryOnlyDiskCache diskCache = new ODirectMemoryOnlyDiskCache(contextConfiguration.getValueAsInteger(OGlobalConfiguration.DISK_CACHE_PAGE_SIZE) * 1024, 1);
        if (this.readCache == null) {
            this.readCache = diskCache;
        }
        if (this.writeCache == null) {
            this.writeCache = diskCache;
        }
    }

    @Override
    protected void postCloseSteps(boolean onDelete, boolean jvmError, long lastTxId) {
    }

    @Override
    public boolean exists() {
        try {
            return this.readCache != null && this.writeCache.exists("default.pcl");
        }
        catch (RuntimeException e) {
            throw this.logAndPrepareForRethrow(e);
        }
        catch (Error e) {
            throw this.logAndPrepareForRethrow(e);
        }
        catch (Throwable t) {
            throw this.logAndPrepareForRethrow(t);
        }
    }

    @Override
    public String getType() {
        return "memory";
    }

    @Override
    public String getURL() {
        return "memory:" + this.url;
    }

    @Override
    public void makeFullCheckpoint() {
    }

    @Override
    protected void readIv() {
    }

    @Override
    protected byte[] getIv() {
        return new byte[0];
    }

    @Override
    protected void initIv() {
    }

    @Override
    public List<String> backup(OutputStream out, Map<String, Object> options, Callable<Object> callable, OCommandOutputListener iListener, int compressionLevel, int bufferSize) {
        try {
            throw new UnsupportedOperationException();
        }
        catch (RuntimeException e) {
            throw this.logAndPrepareForRethrow(e);
        }
        catch (Error e) {
            throw this.logAndPrepareForRethrow(e);
        }
        catch (Throwable t) {
            throw this.logAndPrepareForRethrow(t);
        }
    }

    @Override
    public void restore(InputStream in, Map<String, Object> options, Callable<Object> callable, OCommandOutputListener iListener) {
        try {
            throw new UnsupportedOperationException();
        }
        catch (RuntimeException e) {
            throw this.logAndPrepareForRethrow(e);
        }
        catch (Error e) {
            throw this.logAndPrepareForRethrow(e);
        }
        catch (Throwable t) {
            throw this.logAndPrepareForRethrow(t);
        }
    }

    @Override
    protected OLogSequenceNumber copyWALToIncrementalBackup(ZipOutputStream zipOutputStream, long startSegment) {
        return null;
    }

    @Override
    protected boolean isWriteAllowedDuringIncrementalBackup() {
        return false;
    }

    @Override
    protected File createWalTempDirectory() {
        return null;
    }

    @Override
    protected void addFileToDirectory(String name, InputStream stream, File directory) {
    }

    @Override
    protected OWriteAheadLog createWalFromIBUFiles(File directory, OContextConfiguration contextConfiguration, Locale locale, byte[] iv) {
        return null;
    }

    @Override
    public void shutdown() {
        try {
            this.delete();
        }
        catch (RuntimeException e) {
            throw this.logAndPrepareForRethrow(e);
        }
        catch (Error e) {
            throw this.logAndPrepareForRethrow(e);
        }
        catch (Throwable t) {
            throw this.logAndPrepareForRethrow(t);
        }
    }
}

