/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.tx;

import com.orientechnologies.common.concur.lock.OLockException;
import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.orient.core.cache.OLocalRecordCache;
import com.orientechnologies.orient.core.db.ODatabaseDocumentInternal;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.db.record.ORecordOperation;
import com.orientechnologies.orient.core.id.ORID;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.record.impl.ODocumentInternal;
import com.orientechnologies.orient.core.storage.OStorage;
import com.orientechnologies.orient.core.storage.OStorageProxy;
import com.orientechnologies.orient.core.storage.impl.local.OAbstractPaginatedStorage;
import com.orientechnologies.orient.core.tx.OTransaction;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public abstract class OTransactionAbstract
implements OTransaction {
    protected ODatabaseDocumentInternal database;
    protected OTransaction.TXSTATUS status = OTransaction.TXSTATUS.INVALID;
    protected OTransaction.ISOLATION_LEVEL isolationLevel = OTransaction.ISOLATION_LEVEL.READ_COMMITTED;
    protected Map<ORID, LockedRecordMetadata> locks = new HashMap<ORID, LockedRecordMetadata>();

    protected OTransactionAbstract(ODatabaseDocumentInternal iDatabase) {
        this.database = iDatabase;
    }

    public static void updateCacheFromEntries(ODatabaseDocumentInternal database, Iterable<? extends ORecordOperation> entries, boolean updateStrategy) {
        OLocalRecordCache dbCache = database.getLocalCache();
        for (ORecordOperation oRecordOperation : entries) {
            if (!updateStrategy) {
                dbCache.deleteRecord(oRecordOperation.getRecord().getIdentity());
            } else if (oRecordOperation.type == 2) {
                dbCache.deleteRecord(oRecordOperation.getRecord().getIdentity());
            } else if (oRecordOperation.type == 1 || oRecordOperation.type == 3) {
                dbCache.updateRecord(oRecordOperation.getRecord());
            }
            if (!(oRecordOperation.getRecord() instanceof ODocument)) continue;
            ODocumentInternal.clearTransactionTrackData((ODocument)oRecordOperation.getRecord());
        }
    }

    @Override
    public OTransaction.ISOLATION_LEVEL getIsolationLevel() {
        return this.isolationLevel;
    }

    @Override
    public OTransaction setIsolationLevel(OTransaction.ISOLATION_LEVEL isolationLevel) {
        if (isolationLevel == OTransaction.ISOLATION_LEVEL.REPEATABLE_READ && this.getDatabase().getStorage() instanceof OStorageProxy) {
            throw new IllegalArgumentException("Remote storage does not support isolation level '" + (Object)((Object)isolationLevel) + "'");
        }
        this.isolationLevel = isolationLevel;
        return this;
    }

    @Override
    public boolean isActive() {
        return this.status != OTransaction.TXSTATUS.INVALID && this.status != OTransaction.TXSTATUS.COMPLETED && this.status != OTransaction.TXSTATUS.ROLLED_BACK;
    }

    @Override
    public OTransaction.TXSTATUS getStatus() {
        return this.status;
    }

    @Override
    public ODatabaseDocumentInternal getDatabase() {
        return this.database;
    }

    @Override
    public void close() {
        for (Map.Entry<ORID, LockedRecordMetadata> lock : this.locks.entrySet()) {
            try {
                LockedRecordMetadata lockedRecordMetadata = lock.getValue();
                if (lockedRecordMetadata.strategy.equals((Object)OStorage.LOCKING_STRATEGY.EXCLUSIVE_LOCK)) {
                    ((OAbstractPaginatedStorage)this.getDatabase().getStorage().getUnderlying()).releaseWriteLock(lock.getKey());
                    continue;
                }
                if (!lockedRecordMetadata.strategy.equals((Object)OStorage.LOCKING_STRATEGY.SHARED_LOCK)) continue;
                ((OAbstractPaginatedStorage)this.getDatabase().getStorage().getUnderlying()).releaseReadLock(lock.getKey());
            }
            catch (Exception e) {
                OLogManager.instance().debug((Object)this, "Error on releasing lock against record " + lock.getKey(), e, new Object[0]);
            }
        }
        this.locks.clear();
    }

    @Override
    public OTransaction lockRecord(OIdentifiable iRecord, OStorage.LOCKING_STRATEGY lockingStrategy) {
        this.database.internalLockRecord(iRecord, lockingStrategy);
        return this;
    }

    @Override
    public boolean isLockedRecord(OIdentifiable iRecord) {
        ORID rid = iRecord.getIdentity();
        LockedRecordMetadata lockedRecordMetadata = this.locks.get(rid);
        return lockedRecordMetadata != null && lockedRecordMetadata.locksCount != 0;
    }

    @Override
    public OStorage.LOCKING_STRATEGY lockingStrategy(OIdentifiable record) {
        ORID rid = record.getIdentity();
        LockedRecordMetadata lockedRecordMetadata = this.locks.get(rid);
        if (lockedRecordMetadata == null || lockedRecordMetadata.locksCount == 0) {
            return null;
        }
        return lockedRecordMetadata.strategy;
    }

    @Override
    public OTransaction unlockRecord(OIdentifiable iRecord) {
        this.database.internalUnlockRecord(iRecord);
        return this;
    }

    public abstract void internalRollback();

    public void trackLockedRecord(ORID rid, OStorage.LOCKING_STRATEGY lockingStrategy) {
        LockedRecordMetadata lockedRecordMetadata = this.locks.get(rid);
        boolean addItem = false;
        if (lockedRecordMetadata == null) {
            lockedRecordMetadata = new LockedRecordMetadata(lockingStrategy);
            addItem = true;
        } else if (lockedRecordMetadata.strategy != lockingStrategy) {
            assert (lockedRecordMetadata.locksCount == 0);
            lockedRecordMetadata = new LockedRecordMetadata(lockingStrategy);
            addItem = true;
        }
        lockedRecordMetadata.locksCount++;
        if (addItem) {
            this.locks.put(rid, lockedRecordMetadata);
        }
    }

    public OStorage.LOCKING_STRATEGY trackUnlockRecord(ORID rid) {
        LockedRecordMetadata lockedRecordMetadata = this.locks.get(rid);
        if (lockedRecordMetadata != null && lockedRecordMetadata.locksCount > 0) {
            lockedRecordMetadata.locksCount--;
            if (lockedRecordMetadata.locksCount == 0) {
                this.locks.remove(rid);
                return lockedRecordMetadata.strategy;
            }
        } else {
            throw new OLockException("Cannot unlock a never acquired lock");
        }
        return null;
    }

    public Map<ORID, LockedRecordMetadata> getInternalLocks() {
        return this.locks;
    }

    protected void setLocks(Map<ORID, LockedRecordMetadata> locks) {
        this.locks = locks;
    }

    public Set<ORID> getLockedRecords() {
        return this.locks.keySet();
    }

    public void setDatabase(ODatabaseDocumentInternal database) {
        this.database = database;
    }

    public static final class LockedRecordMetadata {
        private final OStorage.LOCKING_STRATEGY strategy;
        private int locksCount;

        public LockedRecordMetadata(OStorage.LOCKING_STRATEGY strategy) {
            this.strategy = strategy;
        }
    }
}

