/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.core.tx;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Objects;
import java.util.Optional;

public class OTransactionId {
    private Optional<String> nodeOwner;
    private int position;
    private long sequence;

    public OTransactionId(Optional<String> nodeOwner, int position, long sequence) {
        assert (nodeOwner != null);
        this.nodeOwner = nodeOwner;
        this.position = position;
        this.sequence = sequence;
    }

    public int getPosition() {
        return this.position;
    }

    public long getSequence() {
        return this.sequence;
    }

    public Optional<String> getNodeOwner() {
        return this.nodeOwner;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OTransactionId that = (OTransactionId)o;
        return this.position == that.position && this.sequence == that.sequence && Objects.equals(this.nodeOwner, that.nodeOwner);
    }

    public int hashCode() {
        return Objects.hash(this.nodeOwner, this.position, this.sequence);
    }

    public static OTransactionId read(DataInput input) throws IOException {
        Optional<String> nodeOwner = input.readBoolean() ? Optional.of(input.readUTF()) : Optional.empty();
        int position = input.readInt();
        long sequence = input.readLong();
        return new OTransactionId(nodeOwner, position, sequence);
    }

    public void write(DataOutput out) throws IOException {
        if (this.nodeOwner.isPresent()) {
            out.writeBoolean(true);
            out.writeUTF(this.nodeOwner.get());
        } else {
            out.writeBoolean(false);
        }
        out.writeInt(this.position);
        out.writeLong(this.sequence);
    }

    public String toString() {
        return "" + this.position + ":" + this.sequence + " owner:" + this.nodeOwner;
    }
}

