/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.graph.batch;

import com.orientechnologies.orient.core.config.OGlobalConfiguration;
import com.orientechnologies.orient.core.config.OStorageEntryConfiguration;
import com.orientechnologies.orient.core.db.ODatabase;
import com.orientechnologies.orient.core.db.ODatabaseDocumentInternal;
import com.orientechnologies.orient.core.db.document.ODatabaseDocument;
import com.orientechnologies.orient.core.db.document.ODatabaseDocumentTx;
import com.orientechnologies.orient.core.db.record.ridbag.ORidBag;
import com.orientechnologies.orient.core.id.ORecordId;
import com.orientechnologies.orient.core.intent.OIntentMassiveInsert;
import com.orientechnologies.orient.core.metadata.schema.OClass;
import com.orientechnologies.orient.core.metadata.schema.OSchema;
import com.orientechnologies.orient.core.record.ORecord;
import com.orientechnologies.orient.core.record.impl.ODocument;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;

public class OGraphBatchInsert {
    private final String userName;
    private final String dbUrl;
    private final String password;
    private Map<Long, List<Object>> out = new HashMap<Long, List<Object>>();
    private Map<Long, List<Object>> in = new HashMap<Long, List<Object>>();
    private String idPropertyName = "uid";
    private String edgeClass = "E";
    private String vertexClass = "V";
    private OClass oVertexClass;
    private ODatabaseDocument db;
    private int averageEdgeNumberPerNode = -1;
    private int estimatedEntries = -1;
    private int bonsaiThreshold = 1000;
    private int[] clusterIds;
    private long[] lastClusterPositions;
    private long[] nextVerticesToCreate;
    private long last = 0L;
    private int parallel = 4;
    private final AtomicInteger runningThreads = new AtomicInteger(0);
    private boolean settingProperties = false;
    private Boolean useLightWeigthEdges = null;

    public OGraphBatchInsert(String iDbURL) {
        this.dbUrl = iDbURL;
        this.userName = "admin";
        this.password = "admin";
    }

    public OGraphBatchInsert(String iDbURL, String iUserName, String iPassword) {
        this.dbUrl = iDbURL;
        this.userName = iUserName;
        this.password = iPassword;
    }

    public void begin() {
        if (this.averageEdgeNumberPerNode > 0) {
            OGlobalConfiguration.RID_BAG_EMBEDDED_DEFAULT_SIZE.setValue(this.averageEdgeNumberPerNode);
            OGlobalConfiguration.RID_BAG_EMBEDDED_TO_SBTREEBONSAI_THRESHOLD.setValue(this.bonsaiThreshold);
        }
        this.db = new ODatabaseDocumentTx(this.dbUrl);
        if (this.db.exists()) {
            this.db.open(this.userName, this.password);
        } else {
            this.db.create();
        }
        if (this.useLightWeigthEdges == null) {
            List custom = (List)this.db.get(ODatabase.ATTRIBUTES.CUSTOM);
            for (OStorageEntryConfiguration c : custom) {
                if (!c.name.equalsIgnoreCase("useLightweightEdges")) continue;
                this.useLightWeigthEdges = Boolean.parseBoolean(c.value);
                break;
            }
            if (this.useLightWeigthEdges == null) {
                this.useLightWeigthEdges = true;
            }
        }
        this.createBaseSchema();
        this.out = this.estimatedEntries > 0 ? new HashMap(this.estimatedEntries) : new HashMap();
        this.in = this.estimatedEntries > 0 ? new HashMap(this.estimatedEntries) : new HashMap();
        OClass vClass = this.db.getMetadata().getSchema().getClass(this.vertexClass);
        int[] existingClusters = vClass.getClusterIds();
        for (int c = existingClusters.length; c <= this.parallel; ++c) {
            vClass.addCluster(vClass.getName() + "_" + c);
        }
        this.clusterIds = vClass.getClusterIds();
        this.lastClusterPositions = new long[this.clusterIds.length];
        this.nextVerticesToCreate = new long[this.clusterIds.length];
        for (int i = 0; i < this.clusterIds.length; ++i) {
            int clusterId = this.clusterIds[i];
            try {
                this.nextVerticesToCreate[i] = i;
                this.lastClusterPositions[i] = ((ODatabaseDocumentInternal)this.db).getStorage().getLastClusterPosition(clusterId);
                continue;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void end() {
        block10: {
            OClass vClass = this.db.getMetadata().getSchema().getClass(this.vertexClass);
            try {
                this.runningThreads.set(this.parallel);
                for (int i = 0; i < this.parallel - 1; ++i) {
                    BatchImporterJob t = new BatchImporterJob(i, vClass, this.last);
                    t.start();
                }
                BatchImporterJob t = new BatchImporterJob(this.parallel - 1, vClass, this.last);
                ((Thread)t).run();
                if (this.runningThreads.get() <= 0) break block10;
                AtomicInteger atomicInteger = this.runningThreads;
                synchronized (atomicInteger) {
                    while (this.runningThreads.get() > 0) {
                        try {
                            this.runningThreads.wait();
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                }
            }
            finally {
                this.db.activateOnCurrentThread();
                this.db.declareIntent(null);
                this.db.close();
            }
        }
    }

    public void createVertex(Long v) {
        if (this.settingProperties) {
            throw new IllegalStateException("Cannot create new edges when already set properties on vertices");
        }
        this.last = this.last < v ? v : this.last;
        List<Object> outList = this.out.get(v);
        if (outList == null) {
            this.out.put(v, new ArrayList(this.averageEdgeNumberPerNode <= 0 ? 4 : this.averageEdgeNumberPerNode));
        }
    }

    public void createEdge(Long from, Long to, Map<String, Object> properties) {
        if (this.settingProperties) {
            throw new IllegalStateException("Cannot create new edges when already set properties on vertices");
        }
        if (from < 0L) {
            throw new IllegalArgumentException(" Invalid vertex id: " + from);
        }
        if (to < 0L) {
            throw new IllegalArgumentException(" Invalid vertex id: " + to);
        }
        if (this.useLightWeigthEdges.booleanValue() && (properties == null || properties.size() == 0)) {
            this.last = this.last < from ? from : this.last;
            this.last = this.last < to ? to : this.last;
            this.putInList(from, this.out, to);
            this.putInList(to, this.in, from);
        } else {
            ODocument edgeDoc = new ODocument(this.edgeClass);
            edgeDoc.fromMap(properties);
            edgeDoc.field("out", new ORecordId(this.getClusterId(from), this.getClusterPosition(from)));
            edgeDoc.field("in", new ORecordId(this.getClusterId(to), this.getClusterPosition(to)));
            this.db.save(edgeDoc);
            ORecordId rid = (ORecordId)edgeDoc.getIdentity();
            this.putInList(from, this.out, rid);
            this.putInList(to, this.in, rid);
        }
    }

    public void setVertexProperties(Long id, Map<String, Object> properties) {
        if (properties == null || properties.size() == 0) {
            return;
        }
        this.settingProperties = true;
        int cluster = (int)(id % (long)this.parallel);
        if (this.nextVerticesToCreate[cluster] <= id) {
            if (this.oVertexClass == null) {
                this.oVertexClass = this.db.getMetadata().getSchema().getClass(this.vertexClass);
            }
            if (this.nextVerticesToCreate[cluster] < id) {
                new BatchImporterJob(cluster, this.oVertexClass, id - 1L).run(this.db);
            }
            new BatchImporterJob(cluster, this.oVertexClass, (long)id).createVertex(this.db, id, properties);
        } else {
            ODocument doc = (ODocument)this.db.load(new ORecordId(this.getClusterId(id), this.getClusterPosition(id)));
            if (doc == null) {
                throw new RuntimeException("trying to insert properties on non existing document");
            }
            doc.fromMap(properties);
            this.db.save(doc);
        }
    }

    public int getAverageEdgeNumberPerNode() {
        return this.averageEdgeNumberPerNode;
    }

    public void setAverageEdgeNumberPerNode(int averageEdgeNumberPerNode) {
        this.averageEdgeNumberPerNode = averageEdgeNumberPerNode;
    }

    public String getIdPropertyName() {
        return this.idPropertyName;
    }

    public void setIdPropertyName(String idPropertyName) {
        this.idPropertyName = idPropertyName;
    }

    public String getEdgeClass() {
        return this.edgeClass;
    }

    public void setEdgeClass(String edgeClass) {
        this.edgeClass = edgeClass;
    }

    public String getVertexClass() {
        return this.vertexClass;
    }

    public void setVertexClass(String vertexClass) {
        this.vertexClass = vertexClass;
    }

    public int getBonsaiThreshold() {
        return this.bonsaiThreshold;
    }

    public void setBonsaiThreshold(int bonsaiThreshold) {
        this.bonsaiThreshold = bonsaiThreshold;
    }

    public int getEstimatedEntries() {
        return this.estimatedEntries;
    }

    public void setEstimatedEntries(int estimatedEntries) {
        this.estimatedEntries = estimatedEntries;
    }

    public int getParallel() {
        return this.parallel;
    }

    public void setParallel(int parallel) {
        this.parallel = parallel;
    }

    private void putInList(Long key, Map<Long, List<Object>> out, Object value) {
        List<Object> list = out.get(key);
        if (list == null) {
            list = new ArrayList<Object>(this.averageEdgeNumberPerNode <= 0 ? 4 : this.averageEdgeNumberPerNode);
            out.put(key, list);
        }
        list.add(value);
    }

    private void createBaseSchema() {
        OSchema schema = this.db.getMetadata().getSchema();
        OClass v = !schema.existsClass("V") ? schema.createClass("V") : schema.getClass("V");
        OClass e = !schema.existsClass("E") ? schema.createClass("E") : schema.getClass("E");
        if (!"V".equals(this.vertexClass) && !schema.existsClass(this.vertexClass)) {
            schema.createClass(this.vertexClass, v);
        }
        if (!schema.existsClass(this.edgeClass) && !schema.existsClass(this.edgeClass)) {
            schema.createClass(this.edgeClass, e);
        }
    }

    private long getClusterPosition(long uid) {
        return this.lastClusterPositions[(int)(uid % (long)this.parallel)] + uid / (long)this.parallel + 1L;
    }

    private int getClusterId(long left) {
        return this.clusterIds[(int)(left % (long)this.parallel)];
    }

    class BatchImporterJob
    extends Thread {
        private final int mod;
        private OClass vClass;
        private long last;

        BatchImporterJob(int mod, OClass vertexClass, long last) {
            this.mod = mod;
            this.vClass = vertexClass;
            this.last = last;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            ODatabaseDocumentTx db = new ODatabaseDocumentTx(OGraphBatchInsert.this.dbUrl);
            try {
                db.open(OGraphBatchInsert.this.userName, OGraphBatchInsert.this.password);
                this.run(db);
            }
            finally {
                OGraphBatchInsert.this.runningThreads.decrementAndGet();
                AtomicInteger atomicInteger = OGraphBatchInsert.this.runningThreads;
                synchronized (atomicInteger) {
                    OGraphBatchInsert.this.runningThreads.notifyAll();
                }
                db.activateOnCurrentThread();
                db.close();
            }
        }

        private void run(ODatabaseDocument db) {
            db.declareIntent(new OIntentMassiveInsert());
            int clusterId = OGraphBatchInsert.this.clusterIds[this.mod];
            String outField = "E".equals(OGraphBatchInsert.this.edgeClass) ? "out_" : "out_" + OGraphBatchInsert.this.edgeClass;
            String inField = "E".equals(OGraphBatchInsert.this.edgeClass) ? "in_" : "in_" + OGraphBatchInsert.this.edgeClass;
            String clusterName = db.getClusterNameById(clusterId);
            for (long i = OGraphBatchInsert.this.nextVerticesToCreate[this.mod]; i <= this.last; i += (long)OGraphBatchInsert.this.parallel) {
                this.createVertex(db, i, inField, outField, clusterName, null);
            }
            db.declareIntent(null);
        }

        public void createVertex(ODatabaseDocument db, long i, Map<String, Object> properties) {
            int clusterId = OGraphBatchInsert.this.clusterIds[this.mod];
            String outField = "E".equals(OGraphBatchInsert.this.edgeClass) ? "out_" : "out_" + OGraphBatchInsert.this.edgeClass;
            String inField = "E".equals(OGraphBatchInsert.this.edgeClass) ? "in_" : "in_" + OGraphBatchInsert.this.edgeClass;
            String clusterName = db.getClusterNameById(clusterId);
            this.createVertex(db, i, inField, outField, clusterName, properties);
        }

        private void createVertex(ODatabaseDocument db, long i, String inField, String outField, String clusterName, Map<String, Object> properties) {
            List outIds = (List)OGraphBatchInsert.this.out.get(i);
            List inIds = (List)OGraphBatchInsert.this.in.get(i);
            ODocument doc = new ODocument(this.vClass);
            if (outIds == null && inIds == null) {
                ((ORecord)db.save(doc, clusterName)).delete();
            } else {
                ORecordId rid;
                doc.field(OGraphBatchInsert.this.idPropertyName, i);
                if (outIds != null) {
                    ORidBag outBag = new ORidBag();
                    for (Object l : outIds) {
                        rid = l instanceof ORecordId ? (ORecordId)l : new ORecordId(OGraphBatchInsert.this.getClusterId((Long)l), OGraphBatchInsert.this.getClusterPosition((Long)l));
                        outBag.add(rid);
                    }
                    doc.field(outField, outBag);
                }
                if (inIds != null) {
                    ORidBag inBag = new ORidBag();
                    for (Object l : inIds) {
                        rid = l instanceof ORecordId ? (ORecordId)l : new ORecordId(OGraphBatchInsert.this.getClusterId((Long)l), OGraphBatchInsert.this.getClusterPosition((Long)l));
                        inBag.add(rid);
                    }
                    doc.field(inField, inBag);
                }
                doc.fromMap(properties);
                db.save(doc, clusterName);
            }
            long[] lArray = OGraphBatchInsert.this.nextVerticesToCreate;
            int n = this.mod;
            lArray[n] = lArray[n] + (long)OGraphBatchInsert.this.parallel;
        }
    }
}

