/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.graph.console;

import com.orientechnologies.common.console.TTYConsoleReader;
import com.orientechnologies.common.console.annotation.ConsoleCommand;
import com.orientechnologies.common.console.annotation.ConsoleParameter;
import com.orientechnologies.orient.console.OConsoleDatabaseApp;
import com.orientechnologies.orient.core.command.OCommandExecutorNotFoundException;
import com.orientechnologies.orient.core.command.OCommandOutputListener;
import com.orientechnologies.orient.core.config.OGlobalConfiguration;
import com.orientechnologies.orient.core.db.tool.ODatabaseImportException;
import com.orientechnologies.orient.core.exception.OStorageException;
import com.orientechnologies.orient.core.serialization.serializer.OStringSerializerHelper;
import com.orientechnologies.orient.graph.graphml.OGraphMLReader;
import com.orientechnologies.orient.graph.graphml.OGraphSONReader;
import com.orientechnologies.orient.graph.gremlin.OCommandGremlin;
import com.orientechnologies.orient.graph.gremlin.OGremlinHelper;
import com.tinkerpop.blueprints.impls.orient.OBonsaiTreeRepair;
import com.tinkerpop.blueprints.impls.orient.OGraphRepair;
import com.tinkerpop.blueprints.impls.orient.OrientGraph;
import com.tinkerpop.blueprints.impls.orient.OrientGraphFactory;
import com.tinkerpop.blueprints.util.io.graphml.GraphMLWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import java.util.zip.GZIPInputStream;
import java.util.zip.ZipInputStream;

public class OGremlinConsole
extends OConsoleDatabaseApp {
    public OGremlinConsole(String[] args) {
        super(args);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        int result;
        boolean interactiveMode = OGremlinConsole.isInteractiveMode(args);
        try {
            boolean tty = false;
            try {
                if (OGremlinConsole.setTerminalToCBreak(interactiveMode)) {
                    tty = true;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            OGremlinConsole console = new OGremlinConsole(args);
            if (tty) {
                console.setReader(new TTYConsoleReader(console.historyEnabled()));
            }
            result = console.run();
        }
        finally {
            try {
                OGremlinConsole.stty("echo", interactiveMode);
            }
            catch (Exception exception) {}
        }
        System.exit(result);
    }

    @ConsoleCommand(splitInWords=false, description="Execute a GREMLIN script")
    public void gremlin(@ConsoleParameter(name="script-text", description="The script text to execute") String iScriptText) {
        block3: {
            this.checkForDatabase();
            if (iScriptText == null || iScriptText.length() == 0) {
                return;
            }
            this.resetResultSet();
            long start = System.currentTimeMillis();
            try {
                Object result = this.currentDatabase.command(new OCommandGremlin(iScriptText)).execute(new Object[0]);
                float elapsed = System.currentTimeMillis() - start;
                this.out.println("\n" + result);
                this.out.printf("\nScript executed in %f ms.", Float.valueOf(elapsed));
            }
            catch (OStorageException e) {
                Throwable cause = e.getCause();
                if (!(cause instanceof OCommandExecutorNotFoundException)) break block3;
                this.out.printf("\nError: the GREMLIN command executor is not installed, check your configuration", new Object[0]);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @ConsoleCommand(description="Import a database into the current one", splitInWords=false)
    public void importDatabase(@ConsoleParameter(name="options", description="Import options") String text) throws IOException {
        String format;
        this.checkForDatabase();
        List<String> items = OStringSerializerHelper.smartSplit(text, ' ', new char[0]);
        String fileName = items.size() <= 0 || items.get(1).charAt(0) == '-' ? null : items.get(1);
        String optionsAsString = fileName != null ? text.substring(items.get(0).length() + items.get(1).length() + 1).trim() : text;
        Map<String, List<String>> options = this.parseOptions(optionsAsString);
        String string = format = options.containsKey("-format") ? options.get("-format").get(0) : null;
        if (format != null && format.equalsIgnoreCase("graphml") || fileName != null && (fileName.endsWith(".graphml") || fileName.endsWith(".xml"))) {
            this.message("\nImporting GRAPHML database from " + fileName + " with options (" + optionsAsString + ")...", new Object[0]);
            OrientGraph g = (OrientGraph)OrientGraphFactory.getTxGraphImplFactory().getGraph(this.currentDatabase);
            try {
                g.setUseLog(false);
                g.setWarnOnForceClosingTx(false);
                long totalEdges = g.countEdges();
                long totalVertices = g.countVertices();
                File file = new File(fileName);
                if (!file.exists()) {
                    throw new ODatabaseImportException("Input file '" + fileName + "' not exists");
                }
                InputStream is = new FileInputStream(file);
                if (fileName.endsWith(".zip")) {
                    is = new ZipInputStream(is);
                } else if (fileName.endsWith(".gz")) {
                    is = new GZIPInputStream(is);
                }
                try {
                    new OGraphMLReader(g).setOptions(options).setOutput(new OCommandOutputListener(){

                        @Override
                        public void onMessage(String iText) {
                            System.out.print("\r" + iText);
                        }
                    }).inputGraph(is);
                    g.commit();
                    this.currentDatabase.commit();
                    this.message("\nDone: imported %d vertices and %d edges", g.countVertices() - totalVertices, g.countEdges() - totalEdges);
                }
                finally {
                    is.close();
                }
            }
            catch (ODatabaseImportException e) {
                this.printError(e);
            }
            finally {
                g.shutdown(false, true);
            }
        } else if (format != null && format.equalsIgnoreCase("graphson") || fileName != null && fileName.endsWith(".graphson")) {
            this.message("\nImporting GRAPHSON database from " + fileName + " with options (" + optionsAsString + ")...", new Object[0]);
            try {
                OrientGraph g = (OrientGraph)OrientGraphFactory.getTxGraphImplFactory().getGraph(this.currentDatabase);
                g.setUseLog(false);
                g.setWarnOnForceClosingTx(false);
                long totalEdges = g.countEdges();
                long totalVertices = g.countVertices();
                File file = new File(fileName);
                if (!file.exists()) {
                    throw new ODatabaseImportException("Input file '" + fileName + "' not exists");
                }
                InputStream is = new FileInputStream(file);
                if (fileName.endsWith(".zip")) {
                    is = new ZipInputStream(is);
                } else if (fileName.endsWith(".gz")) {
                    is = new GZIPInputStream(is);
                }
                try {
                    new OGraphSONReader(g).setOutput(new OCommandOutputListener(){

                        @Override
                        public void onMessage(String iText) {
                            System.out.print("\r" + iText);
                        }
                    }).inputGraph(is, 10000);
                    g.commit();
                    this.currentDatabase.commit();
                    this.message("\nDone: imported %d vertices and %d edges", g.countVertices() - totalVertices, g.countEdges() - totalEdges);
                }
                finally {
                    is.close();
                }
            }
            catch (ODatabaseImportException e) {
                this.printError(e);
            }
        } else if (format == null) {
            super.importDatabase(text);
        } else {
            throw new IllegalArgumentException("Format '" + format + "' is not supported");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @ConsoleCommand(description="Export a database", splitInWords=false, onlineHelp="Console-Command-Export")
    public void exportDatabase(@ConsoleParameter(name="options", description="Export options") String iText) throws IOException {
        String fileName;
        this.checkForDatabase();
        List<String> items = OStringSerializerHelper.smartSplit(iText, ' ', new char[0]);
        String string = fileName = items.size() <= 1 || items.get(1).charAt(0) == '-' ? null : items.get(1);
        if (fileName != null && (fileName.endsWith(".graphml") || fileName.endsWith(".xml"))) {
            this.message("\nExporting database in GRAPHML format to " + iText + "...", new Object[0]);
            OrientGraph g = (OrientGraph)OrientGraphFactory.getTxGraphImplFactory().getGraph(this.currentDatabase);
            try {
                g.setUseLog(false);
                g.setWarnOnForceClosingTx(false);
                File f = new File(fileName);
                if (f.getParentFile() != null) {
                    f.getParentFile().mkdirs();
                }
                f.createNewFile();
                new GraphMLWriter(g).outputGraph(fileName);
            }
            catch (ODatabaseImportException e) {
                this.printError(e);
            }
            finally {
                g.shutdown(false, true);
            }
        } else {
            super.exportDatabase(iText);
        }
    }

    @Override
    @ConsoleCommand(description="Check database integrity", splitInWords=false)
    public void checkDatabase(@ConsoleParameter(name="options", description="Options: -v --skip-graph", optional=true) String iOptions) throws IOException {
        boolean fix_graph;
        boolean bl = fix_graph = iOptions == null || !iOptions.contains("--skip-graph");
        if (fix_graph) {
            Map<String, List<String>> options = this.parseOptions(iOptions);
            new OGraphRepair().check(OrientGraphFactory.getNoTxGraphImplFactory().getGraph(this.currentDatabase), this, options);
        }
        super.checkDatabase(iOptions);
    }

    @Override
    @ConsoleCommand(description="Repair database structure", splitInWords=false)
    public void repairDatabase(@ConsoleParameter(name="options", description="Options: [--fix-graph] [--force-embedded-ridbags] [--fix-links] [-v]] [--fix-ridbags] [--fix-bonsai]", optional=true) String iOptions) throws IOException {
        boolean fix_bonsai;
        boolean fix_links;
        boolean fix_graph;
        this.checkForDatabase();
        boolean force_embedded = iOptions == null || iOptions.contains("--force-embedded-ridbags");
        boolean bl = fix_graph = iOptions == null || iOptions.contains("--fix-graph");
        if (force_embedded) {
            OGlobalConfiguration.RID_BAG_SBTREEBONSAI_TO_EMBEDDED_THRESHOLD.setValue(Integer.MAX_VALUE);
            OGlobalConfiguration.RID_BAG_EMBEDDED_TO_SBTREEBONSAI_THRESHOLD.setValue(Integer.MAX_VALUE);
        }
        if (fix_graph || force_embedded) {
            Map<String, List<String>> options = this.parseOptions(iOptions);
            new OGraphRepair().repair(OrientGraphFactory.getNoTxGraphImplFactory().getGraph(this.currentDatabase), this, options);
        }
        boolean bl2 = fix_links = iOptions == null || iOptions.contains("--fix-links");
        if (fix_links) {
            super.repairDatabase(iOptions);
        }
        if (!this.currentDatabase.getURL().startsWith("plocal")) {
            this.message("\n fix-bonsai can be run only on plocal connection \n", new Object[0]);
            return;
        }
        boolean fix_ridbags = iOptions == null || iOptions.contains("--fix-ridbags");
        boolean bl3 = fix_bonsai = iOptions == null || iOptions.contains("--fix-bonsai");
        if (fix_ridbags || fix_bonsai || force_embedded) {
            OBonsaiTreeRepair repairer = new OBonsaiTreeRepair();
            repairer.repairDatabaseRidbags(this.currentDatabase, this);
        }
    }

    @Override
    protected void onBefore() {
        super.onBefore();
        this.out.println("\nInstalling extensions for GREMLIN language v." + OGremlinHelper.getEngineVersion());
        OGremlinHelper.global().create();
    }

    @Override
    protected boolean isCollectingCommands(String iLine) {
        return super.isCollectingCommands(iLine) || iLine.trim().equalsIgnoreCase("gremlin");
    }
}

