/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.graph.sql;

import com.orientechnologies.common.exception.OException;
import com.orientechnologies.common.types.OModifiableBoolean;
import com.orientechnologies.orient.core.db.ODatabaseDocumentInternal;
import com.orientechnologies.orient.core.db.ODatabaseRecordThreadLocal;
import com.orientechnologies.orient.core.db.document.ODatabaseDocument;
import com.orientechnologies.orient.core.db.document.ODatabaseDocumentTx;
import com.orientechnologies.orient.core.exception.OCommandExecutionException;
import com.orientechnologies.orient.core.metadata.security.OSecurityUser;
import com.orientechnologies.orient.core.sql.OCommandExecutorSQLAbstract;
import com.orientechnologies.orient.core.sql.OCommandExecutorSQLFactory;
import com.tinkerpop.blueprints.impls.orient.OrientBaseGraph;
import com.tinkerpop.blueprints.impls.orient.OrientGraph;
import com.tinkerpop.blueprints.impls.orient.OrientGraphFactory;
import com.tinkerpop.blueprints.impls.orient.OrientGraphNoTx;
import java.util.Collections;
import java.util.Map;
import java.util.Set;

public class OGraphCommandExecutorSQLFactory
implements OCommandExecutorSQLFactory {
    private static final Map<String, Class<? extends OCommandExecutorSQLAbstract>> COMMANDS = Collections.EMPTY_MAP;

    public static OrientGraph getGraph(boolean autoStartTx, OModifiableBoolean shouldBeShutDown) {
        ODatabaseDocumentTx graphDb;
        ODatabaseDocumentInternal database = ODatabaseRecordThreadLocal.instance().get();
        OrientBaseGraph result = OrientBaseGraph.getActiveGraph();
        if (result != null && result instanceof OrientGraph && OGraphCommandExecutorSQLFactory.canReuseActiveGraph(graphDb = result.getRawGraph(), database) && !graphDb.isClosed()) {
            ODatabaseRecordThreadLocal.instance().set(graphDb);
            if (autoStartTx && OGraphCommandExecutorSQLFactory.autoTxStartRequired(graphDb)) {
                ((OrientGraph)result).begin();
            }
            shouldBeShutDown.setValue(false);
            return (OrientGraph)result;
        }
        ODatabaseRecordThreadLocal.instance().set(database);
        shouldBeShutDown.setValue(true);
        OrientGraph g = (OrientGraph)OrientGraphFactory.getTxGraphImplFactory().getGraph(database, false);
        if (autoStartTx && OGraphCommandExecutorSQLFactory.autoTxStartRequired(database)) {
            g.begin();
        }
        return g;
    }

    public static OrientGraphNoTx getGraphNoTx(OModifiableBoolean shouldBeShutDown) {
        ODatabaseDocumentTx graphDb;
        ODatabaseDocumentInternal database = ODatabaseRecordThreadLocal.instance().get();
        OrientBaseGraph result = OrientBaseGraph.getActiveGraph();
        if (result != null && result instanceof OrientGraphNoTx && OGraphCommandExecutorSQLFactory.canReuseActiveGraph(graphDb = result.getRawGraph(), database) && !graphDb.isClosed()) {
            ODatabaseRecordThreadLocal.instance().set(graphDb);
            shouldBeShutDown.setValue(false);
            return (OrientGraphNoTx)result;
        }
        shouldBeShutDown.setValue(true);
        ODatabaseRecordThreadLocal.instance().set(database);
        return (OrientGraphNoTx)OrientGraphFactory.getNoTxGraphImplFactory().getGraph((ODatabaseDocumentTx)database);
    }

    public static OrientBaseGraph getAnyGraph(OModifiableBoolean shouldBeShutDown) {
        ODatabaseDocumentTx graphDb;
        ODatabaseDocumentInternal database = ODatabaseRecordThreadLocal.instance().get();
        OrientBaseGraph result = OrientBaseGraph.getActiveGraph();
        if (result != null && OGraphCommandExecutorSQLFactory.canReuseActiveGraph(graphDb = result.getRawGraph(), database) && !graphDb.isClosed()) {
            graphDb.activateOnCurrentThread();
            shouldBeShutDown.setValue(false);
            return result;
        }
        shouldBeShutDown.setValue(true);
        ODatabaseRecordThreadLocal.instance().set(database);
        return OrientGraphFactory.getNoTxGraphImplFactory().getGraph(database);
    }

    public static <T> T runInTx(OrientGraph graph, GraphCallBack<T> callBack) {
        ODatabaseDocument databaseRecord = OGraphCommandExecutorSQLFactory.getDatabase();
        boolean txWasActive = databaseRecord.getTransaction().isActive();
        if (!txWasActive) {
            graph.getRawGraph().begin();
        }
        try {
            T result = callBack.call(graph);
            if (!txWasActive) {
                graph.commit();
            }
            return result;
        }
        catch (RuntimeException e) {
            if (!txWasActive) {
                graph.rollback();
            }
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> T runInTx(GraphCallBack<T> callBack) {
        OModifiableBoolean shutdownFlag = new OModifiableBoolean();
        ODatabaseDocumentInternal curDb = ODatabaseRecordThreadLocal.instance().get();
        boolean txAlreadyBegun = curDb.getTransaction().isActive();
        OrientGraph graph = OGraphCommandExecutorSQLFactory.getGraph(true, shutdownFlag);
        try {
            T t = OGraphCommandExecutorSQLFactory.runInTx(graph, callBack);
            return t;
        }
        finally {
            if (!txAlreadyBegun) {
                graph.commit();
                if (shutdownFlag.getValue()) {
                    graph.shutdown(false, false);
                }
            }
            ODatabaseRecordThreadLocal.instance().set(curDb);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> T runWithAnyGraph(GraphCallBack<T> callBack) {
        OModifiableBoolean shutdownFlag = new OModifiableBoolean();
        ODatabaseDocumentInternal curDb = ODatabaseRecordThreadLocal.instance().get();
        OrientBaseGraph graph = OGraphCommandExecutorSQLFactory.getAnyGraph(shutdownFlag);
        try {
            T t = callBack.call(graph);
            return t;
        }
        finally {
            if (shutdownFlag.getValue()) {
                graph.shutdown(false, false);
            }
            ODatabaseRecordThreadLocal.instance().set(curDb);
        }
    }

    public static ODatabaseDocument getDatabase() {
        return ODatabaseRecordThreadLocal.instance().get();
    }

    @Override
    public Set<String> getCommandNames() {
        return COMMANDS.keySet();
    }

    @Override
    public OCommandExecutorSQLAbstract createCommand(String name) throws OCommandExecutionException {
        Class<? extends OCommandExecutorSQLAbstract> clazz = COMMANDS.get(name);
        if (clazz == null) {
            throw new OCommandExecutionException("Unknown command name :" + name);
        }
        try {
            return clazz.newInstance();
        }
        catch (Exception e) {
            throw OException.wrapException(new OCommandExecutionException("Error in creation of command " + name + "(). Probably there is not an empty constructor or the constructor generates errors"), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> T runInConfiguredTxMode(GraphCallBack<T> callBack) {
        OModifiableBoolean shutdownFlag = new OModifiableBoolean();
        ODatabaseDocumentInternal curDb = ODatabaseRecordThreadLocal.instance().get();
        boolean txAlreadyBegun = curDb.getTransaction().isActive();
        OrientBaseGraph graph = null;
        try {
            if (OGraphCommandExecutorSQLFactory.isTxRequiredForSQLGraphOperations()) {
                graph = OGraphCommandExecutorSQLFactory.getGraph(true, shutdownFlag);
                T t = OGraphCommandExecutorSQLFactory.runInTx((OrientGraph)graph, callBack);
                return t;
            }
            graph = OGraphCommandExecutorSQLFactory.getAnyGraph(shutdownFlag);
            T t = callBack.call(graph);
            return t;
        }
        finally {
            if (graph != null && !txAlreadyBegun) {
                graph.commit();
                if (shutdownFlag.getValue()) {
                    graph.shutdown(false, false);
                }
            }
            ODatabaseRecordThreadLocal.instance().set(curDb);
        }
    }

    public static boolean isTxRequiredForSQLGraphOperations() {
        return true;
    }

    public static GRAPH_CONSISTENCY_MODE getConsistencyMode(OrientBaseGraph graph) {
        String consistencyMode = graph.getRawGraph().getStorage().getConfiguration().getProperty("graphConsistencyMode");
        if (consistencyMode == null) {
            return GRAPH_CONSISTENCY_MODE.TX;
        }
        return GRAPH_CONSISTENCY_MODE.valueOf(consistencyMode);
    }

    protected static boolean canReuseActiveGraph(ODatabaseDocument iGraphDatabase, ODatabaseDocument iThreadLocalDatabase) {
        if (iGraphDatabase.getURL().equals(iThreadLocalDatabase.getURL())) {
            OSecurityUser gdbUser = iGraphDatabase.getUser();
            OSecurityUser tlUser = iThreadLocalDatabase.getUser();
            return gdbUser == null && tlUser == null || gdbUser != null && tlUser != null && gdbUser.equals(tlUser);
        }
        return false;
    }

    private static boolean autoTxStartRequired(ODatabaseDocument database) {
        return !database.getTransaction().isActive();
    }

    public static interface GraphCallBack<T> {
        public T call(OrientBaseGraph var1);
    }

    public static enum GRAPH_CONSISTENCY_MODE {
        TX,
        NOTX_SYNC_REPAIR,
        NOTX_ASYNC_REPAIR;

    }
}

