/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.server;

import com.orientechnologies.common.exception.OException;
import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.common.serialization.types.OBinarySerializer;
import com.orientechnologies.common.serialization.types.OByteSerializer;
import com.orientechnologies.common.serialization.types.ONullSerializer;
import com.orientechnologies.common.util.OCommonConst;
import com.orientechnologies.orient.client.binary.OBinaryRequestExecutor;
import com.orientechnologies.orient.client.remote.OBinaryResponse;
import com.orientechnologies.orient.client.remote.message.OAddClusterRequest;
import com.orientechnologies.orient.client.remote.message.OAddClusterResponse;
import com.orientechnologies.orient.client.remote.message.OBatchOperationsRequest;
import com.orientechnologies.orient.client.remote.message.OBatchOperationsResponse;
import com.orientechnologies.orient.client.remote.message.OBeginTransaction38Request;
import com.orientechnologies.orient.client.remote.message.OBeginTransactionRequest;
import com.orientechnologies.orient.client.remote.message.OBeginTransactionResponse;
import com.orientechnologies.orient.client.remote.message.OBinaryProtocolHelper;
import com.orientechnologies.orient.client.remote.message.OCeilingPhysicalPositionsRequest;
import com.orientechnologies.orient.client.remote.message.OCeilingPhysicalPositionsResponse;
import com.orientechnologies.orient.client.remote.message.OCleanOutRecordRequest;
import com.orientechnologies.orient.client.remote.message.OCleanOutRecordResponse;
import com.orientechnologies.orient.client.remote.message.OCloseQueryRequest;
import com.orientechnologies.orient.client.remote.message.OCloseQueryResponse;
import com.orientechnologies.orient.client.remote.message.OCloseRequest;
import com.orientechnologies.orient.client.remote.message.OCommandRequest;
import com.orientechnologies.orient.client.remote.message.OCommandResponse;
import com.orientechnologies.orient.client.remote.message.OCommit37Request;
import com.orientechnologies.orient.client.remote.message.OCommit37Response;
import com.orientechnologies.orient.client.remote.message.OCommit38Request;
import com.orientechnologies.orient.client.remote.message.OCommitRequest;
import com.orientechnologies.orient.client.remote.message.OCommitResponse;
import com.orientechnologies.orient.client.remote.message.OConnect37Request;
import com.orientechnologies.orient.client.remote.message.OConnectRequest;
import com.orientechnologies.orient.client.remote.message.OConnectResponse;
import com.orientechnologies.orient.client.remote.message.OCountRecordsRequest;
import com.orientechnologies.orient.client.remote.message.OCountRecordsResponse;
import com.orientechnologies.orient.client.remote.message.OCountRequest;
import com.orientechnologies.orient.client.remote.message.OCountResponse;
import com.orientechnologies.orient.client.remote.message.OCreateDatabaseRequest;
import com.orientechnologies.orient.client.remote.message.OCreateDatabaseResponse;
import com.orientechnologies.orient.client.remote.message.OCreateRecordRequest;
import com.orientechnologies.orient.client.remote.message.OCreateRecordResponse;
import com.orientechnologies.orient.client.remote.message.ODeleteRecordRequest;
import com.orientechnologies.orient.client.remote.message.ODeleteRecordResponse;
import com.orientechnologies.orient.client.remote.message.ODistributedConnectRequest;
import com.orientechnologies.orient.client.remote.message.ODistributedConnectResponse;
import com.orientechnologies.orient.client.remote.message.ODistributedStatusRequest;
import com.orientechnologies.orient.client.remote.message.ODistributedStatusResponse;
import com.orientechnologies.orient.client.remote.message.ODropClusterRequest;
import com.orientechnologies.orient.client.remote.message.ODropClusterResponse;
import com.orientechnologies.orient.client.remote.message.ODropDatabaseRequest;
import com.orientechnologies.orient.client.remote.message.ODropDatabaseResponse;
import com.orientechnologies.orient.client.remote.message.OExistsDatabaseRequest;
import com.orientechnologies.orient.client.remote.message.OExistsDatabaseResponse;
import com.orientechnologies.orient.client.remote.message.OExperimentalRequest;
import com.orientechnologies.orient.client.remote.message.OExperimentalResponse;
import com.orientechnologies.orient.client.remote.message.OFetchTransaction38Request;
import com.orientechnologies.orient.client.remote.message.OFetchTransaction38Response;
import com.orientechnologies.orient.client.remote.message.OFetchTransactionRequest;
import com.orientechnologies.orient.client.remote.message.OFetchTransactionResponse;
import com.orientechnologies.orient.client.remote.message.OFloorPhysicalPositionsRequest;
import com.orientechnologies.orient.client.remote.message.OFloorPhysicalPositionsResponse;
import com.orientechnologies.orient.client.remote.message.OFreezeDatabaseRequest;
import com.orientechnologies.orient.client.remote.message.OFreezeDatabaseResponse;
import com.orientechnologies.orient.client.remote.message.OGetClusterDataRangeRequest;
import com.orientechnologies.orient.client.remote.message.OGetClusterDataRangeResponse;
import com.orientechnologies.orient.client.remote.message.OGetGlobalConfigurationRequest;
import com.orientechnologies.orient.client.remote.message.OGetGlobalConfigurationResponse;
import com.orientechnologies.orient.client.remote.message.OGetRecordMetadataRequest;
import com.orientechnologies.orient.client.remote.message.OGetRecordMetadataResponse;
import com.orientechnologies.orient.client.remote.message.OGetSizeRequest;
import com.orientechnologies.orient.client.remote.message.OGetSizeResponse;
import com.orientechnologies.orient.client.remote.message.OHigherPhysicalPositionsRequest;
import com.orientechnologies.orient.client.remote.message.OHigherPhysicalPositionsResponse;
import com.orientechnologies.orient.client.remote.message.OImportRequest;
import com.orientechnologies.orient.client.remote.message.OImportResponse;
import com.orientechnologies.orient.client.remote.message.OIncrementalBackupRequest;
import com.orientechnologies.orient.client.remote.message.OIncrementalBackupResponse;
import com.orientechnologies.orient.client.remote.message.OListDatabasesRequest;
import com.orientechnologies.orient.client.remote.message.OListDatabasesResponse;
import com.orientechnologies.orient.client.remote.message.OListGlobalConfigurationsRequest;
import com.orientechnologies.orient.client.remote.message.OListGlobalConfigurationsResponse;
import com.orientechnologies.orient.client.remote.message.OLockRecordRequest;
import com.orientechnologies.orient.client.remote.message.OLockRecordResponse;
import com.orientechnologies.orient.client.remote.message.OLowerPhysicalPositionsRequest;
import com.orientechnologies.orient.client.remote.message.OLowerPhysicalPositionsResponse;
import com.orientechnologies.orient.client.remote.message.OOpen37Request;
import com.orientechnologies.orient.client.remote.message.OOpen37Response;
import com.orientechnologies.orient.client.remote.message.OOpenRequest;
import com.orientechnologies.orient.client.remote.message.OOpenResponse;
import com.orientechnologies.orient.client.remote.message.OQueryNextPageRequest;
import com.orientechnologies.orient.client.remote.message.OQueryRequest;
import com.orientechnologies.orient.client.remote.message.OQueryResponse;
import com.orientechnologies.orient.client.remote.message.OReadRecordIfVersionIsNotLatestRequest;
import com.orientechnologies.orient.client.remote.message.OReadRecordIfVersionIsNotLatestResponse;
import com.orientechnologies.orient.client.remote.message.OReadRecordRequest;
import com.orientechnologies.orient.client.remote.message.OReadRecordResponse;
import com.orientechnologies.orient.client.remote.message.OReleaseDatabaseRequest;
import com.orientechnologies.orient.client.remote.message.OReleaseDatabaseResponse;
import com.orientechnologies.orient.client.remote.message.OReloadRequest;
import com.orientechnologies.orient.client.remote.message.OReloadRequest37;
import com.orientechnologies.orient.client.remote.message.OReloadResponse;
import com.orientechnologies.orient.client.remote.message.OReloadResponse37;
import com.orientechnologies.orient.client.remote.message.OReopenRequest;
import com.orientechnologies.orient.client.remote.message.OReopenResponse;
import com.orientechnologies.orient.client.remote.message.ORollbackTransactionRequest;
import com.orientechnologies.orient.client.remote.message.ORollbackTransactionResponse;
import com.orientechnologies.orient.client.remote.message.OSBTCreateTreeRequest;
import com.orientechnologies.orient.client.remote.message.OSBTCreateTreeResponse;
import com.orientechnologies.orient.client.remote.message.OSBTFetchEntriesMajorRequest;
import com.orientechnologies.orient.client.remote.message.OSBTFetchEntriesMajorResponse;
import com.orientechnologies.orient.client.remote.message.OSBTFirstKeyRequest;
import com.orientechnologies.orient.client.remote.message.OSBTFirstKeyResponse;
import com.orientechnologies.orient.client.remote.message.OSBTGetRealBagSizeRequest;
import com.orientechnologies.orient.client.remote.message.OSBTGetRealBagSizeResponse;
import com.orientechnologies.orient.client.remote.message.OSBTGetRequest;
import com.orientechnologies.orient.client.remote.message.OSBTGetResponse;
import com.orientechnologies.orient.client.remote.message.OServerInfoRequest;
import com.orientechnologies.orient.client.remote.message.OServerInfoResponse;
import com.orientechnologies.orient.client.remote.message.OSetGlobalConfigurationRequest;
import com.orientechnologies.orient.client.remote.message.OSetGlobalConfigurationResponse;
import com.orientechnologies.orient.client.remote.message.OShutdownRequest;
import com.orientechnologies.orient.client.remote.message.OShutdownResponse;
import com.orientechnologies.orient.client.remote.message.OSubscribeDistributedConfigurationRequest;
import com.orientechnologies.orient.client.remote.message.OSubscribeDistributedConfigurationResponse;
import com.orientechnologies.orient.client.remote.message.OSubscribeFunctionsRequest;
import com.orientechnologies.orient.client.remote.message.OSubscribeFunctionsResponse;
import com.orientechnologies.orient.client.remote.message.OSubscribeIndexManagerRequest;
import com.orientechnologies.orient.client.remote.message.OSubscribeIndexManagerResponse;
import com.orientechnologies.orient.client.remote.message.OSubscribeLiveQueryRequest;
import com.orientechnologies.orient.client.remote.message.OSubscribeLiveQueryResponse;
import com.orientechnologies.orient.client.remote.message.OSubscribeRequest;
import com.orientechnologies.orient.client.remote.message.OSubscribeResponse;
import com.orientechnologies.orient.client.remote.message.OSubscribeSchemaRequest;
import com.orientechnologies.orient.client.remote.message.OSubscribeSchemaResponse;
import com.orientechnologies.orient.client.remote.message.OSubscribeSequencesRequest;
import com.orientechnologies.orient.client.remote.message.OSubscribeSequencesResponse;
import com.orientechnologies.orient.client.remote.message.OSubscribeStorageConfigurationRequest;
import com.orientechnologies.orient.client.remote.message.OSubscribeStorageConfigurationResponse;
import com.orientechnologies.orient.client.remote.message.OUnlockRecordRequest;
import com.orientechnologies.orient.client.remote.message.OUnlockRecordResponse;
import com.orientechnologies.orient.client.remote.message.OUnsubscribLiveQueryResponse;
import com.orientechnologies.orient.client.remote.message.OUnsubscribeLiveQueryRequest;
import com.orientechnologies.orient.client.remote.message.OUnsubscribeRequest;
import com.orientechnologies.orient.client.remote.message.OUnsubscribeResponse;
import com.orientechnologies.orient.client.remote.message.OUpdateRecordRequest;
import com.orientechnologies.orient.client.remote.message.OUpdateRecordResponse;
import com.orientechnologies.orient.client.remote.message.tx.ORecordOperationRequest;
import com.orientechnologies.orient.core.OConstants;
import com.orientechnologies.orient.core.Orient;
import com.orientechnologies.orient.core.cache.OCommandCache;
import com.orientechnologies.orient.core.command.OCommandRequestText;
import com.orientechnologies.orient.core.command.OCommandResultListener;
import com.orientechnologies.orient.core.config.OContextConfiguration;
import com.orientechnologies.orient.core.config.OGlobalConfiguration;
import com.orientechnologies.orient.core.db.ODatabaseDocumentInternal;
import com.orientechnologies.orient.core.db.ODatabaseRecordThreadLocal;
import com.orientechnologies.orient.core.db.ODatabaseType;
import com.orientechnologies.orient.core.db.OLiveQueryMonitor;
import com.orientechnologies.orient.core.db.OLiveQueryResultListener;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.db.tool.ODatabaseImport;
import com.orientechnologies.orient.core.exception.OConfigurationException;
import com.orientechnologies.orient.core.exception.ODatabaseException;
import com.orientechnologies.orient.core.exception.ORecordNotFoundException;
import com.orientechnologies.orient.core.exception.OSecurityAccessException;
import com.orientechnologies.orient.core.fetch.OFetchHelper;
import com.orientechnologies.orient.core.fetch.OFetchPlan;
import com.orientechnologies.orient.core.fetch.remote.ORemoteFetchContext;
import com.orientechnologies.orient.core.fetch.remote.ORemoteFetchListener;
import com.orientechnologies.orient.core.id.ORID;
import com.orientechnologies.orient.core.id.ORecordId;
import com.orientechnologies.orient.core.metadata.schema.OType;
import com.orientechnologies.orient.core.query.live.OLiveQueryHookV2;
import com.orientechnologies.orient.core.record.ORecord;
import com.orientechnologies.orient.core.record.ORecordInternal;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.record.impl.ODocumentInternal;
import com.orientechnologies.orient.core.serialization.serializer.record.ORecordSerializer;
import com.orientechnologies.orient.core.serialization.serializer.record.ORecordSerializerFactory;
import com.orientechnologies.orient.core.serialization.serializer.record.binary.ORecordSerializerNetworkV37;
import com.orientechnologies.orient.core.sql.executor.OResult;
import com.orientechnologies.orient.core.sql.executor.OResultInternal;
import com.orientechnologies.orient.core.sql.executor.OResultSet;
import com.orientechnologies.orient.core.sql.parser.OLocalResultSetLifecycleDecorator;
import com.orientechnologies.orient.core.sql.query.OSQLAsynchQuery;
import com.orientechnologies.orient.core.sql.query.OSQLSynchQuery;
import com.orientechnologies.orient.core.storage.OPhysicalPosition;
import com.orientechnologies.orient.core.storage.ORecordMetadata;
import com.orientechnologies.orient.core.storage.OStorage;
import com.orientechnologies.orient.core.storage.OStorageProxy;
import com.orientechnologies.orient.core.storage.cluster.OOfflineClusterException;
import com.orientechnologies.orient.core.storage.config.OClusterBasedStorageConfiguration;
import com.orientechnologies.orient.core.storage.impl.local.OAbstractPaginatedStorage;
import com.orientechnologies.orient.core.storage.impl.local.paginated.atomicoperations.OAtomicOperationsManager;
import com.orientechnologies.orient.core.storage.index.sbtree.OTreeInternal;
import com.orientechnologies.orient.core.storage.index.sbtreebonsai.local.OSBTreeBonsai;
import com.orientechnologies.orient.core.storage.ridbag.sbtree.OBonsaiCollectionPointer;
import com.orientechnologies.orient.core.storage.ridbag.sbtree.OSBTreeCollectionManager;
import com.orientechnologies.orient.core.tx.OTransaction;
import com.orientechnologies.orient.core.tx.OTransactionNoTx;
import com.orientechnologies.orient.core.tx.OTransactionOptimistic;
import com.orientechnologies.orient.server.OClientConnection;
import com.orientechnologies.orient.server.OPushManager;
import com.orientechnologies.orient.server.OQueryMetadataUpdateListener;
import com.orientechnologies.orient.server.OServer;
import com.orientechnologies.orient.server.OServerInfo;
import com.orientechnologies.orient.server.OServerLiveQueryResultListener;
import com.orientechnologies.orient.server.config.OServerUserConfiguration;
import com.orientechnologies.orient.server.distributed.ODistributedConfiguration;
import com.orientechnologies.orient.server.distributed.ODistributedServerManager;
import com.orientechnologies.orient.server.network.OServerNetworkListener;
import com.orientechnologies.orient.server.network.protocol.binary.HandshakeInfo;
import com.orientechnologies.orient.server.network.protocol.binary.OAbstractCommandResultListener;
import com.orientechnologies.orient.server.network.protocol.binary.OAsyncCommandResultListener;
import com.orientechnologies.orient.server.network.protocol.binary.OCommandCacheRemoteResultListener;
import com.orientechnologies.orient.server.network.protocol.binary.OLiveCommandResultListener;
import com.orientechnologies.orient.server.network.protocol.binary.ONetworkProtocolBinary;
import com.orientechnologies.orient.server.network.protocol.binary.OSyncCommandResultListener;
import com.orientechnologies.orient.server.tx.OTransactionOptimisticProxy;
import com.orientechnologies.orient.server.tx.OTransactionOptimisticServer;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public final class OConnectionBinaryExecutor
implements OBinaryRequestExecutor {
    private final OClientConnection connection;
    private final OServer server;
    private final HandshakeInfo handshakeInfo;

    public OConnectionBinaryExecutor(OClientConnection connection, OServer server) {
        this(connection, server, null);
    }

    public OConnectionBinaryExecutor(OClientConnection connection, OServer server, HandshakeInfo handshakeInfo) {
        this.connection = connection;
        this.server = server;
        this.handshakeInfo = handshakeInfo;
    }

    @Override
    public OListDatabasesResponse executeListDatabases(OListDatabasesRequest request) {
        Set<String> dbs = this.server.listDatabases();
        String listener = ((OServerNetworkListener)this.server.getListenerByProtocol(ONetworkProtocolBinary.class)).getInboundAddr().toString();
        HashMap<String, String> toSend = new HashMap<String, String>();
        for (String dbName : dbs) {
            toSend.put(dbName, "remote:" + listener + "/" + dbName);
        }
        return new OListDatabasesResponse(toSend);
    }

    @Override
    public OBinaryResponse executeServerInfo(OServerInfoRequest request) {
        try {
            return new OServerInfoResponse(OServerInfo.getServerInfo(this.server));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public OBinaryResponse executeDBReload(OReloadRequest request) {
        OStorage storage = this.connection.getDatabase().getStorage();
        Set<String> clusters = storage.getClusterNames();
        String[] clusterNames = new String[clusters.size()];
        int[] clusterIds = new int[clusterNames.length];
        int counter = 0;
        for (String name : clusters) {
            int clusterId = storage.getClusterIdByName(name);
            if (clusterId < 0) continue;
            clusterNames[counter] = name;
            clusterIds[counter] = clusterId;
            ++counter;
        }
        if (counter < clusters.size()) {
            clusterNames = Arrays.copyOf(clusterNames, counter);
            clusterIds = Arrays.copyOf(clusterIds, counter);
        }
        return new OReloadResponse(clusterNames, clusterIds);
    }

    @Override
    public OBinaryResponse executeDBReload(OReloadRequest37 request) {
        return new OReloadResponse37(this.connection.getDatabase().getStorage().getConfiguration());
    }

    @Override
    public OBinaryResponse executeCreateDatabase(OCreateDatabaseRequest request) {
        if (this.server.existsDatabase(request.getDatabaseName())) {
            throw new ODatabaseException("Database named '" + request.getDatabaseName() + "' already exists");
        }
        if (request.getBackupPath() != null && !"".equals(request.getBackupPath().trim())) {
            this.server.restore(request.getDatabaseName(), request.getBackupPath());
        } else {
            this.server.createDatabase(request.getDatabaseName(), ODatabaseType.valueOf(request.getStorageMode().toUpperCase(Locale.ENGLISH)), null);
        }
        OLogManager.instance().info((Object)this, "Created database '%s' of type '%s'", request.getDatabaseName(), request.getStorageMode());
        this.connection.setDatabase(this.server.openDatabase(request.getDatabaseName(), this.connection.getData().serverUsername, null, this.connection.getData(), true));
        return new OCreateDatabaseResponse();
    }

    @Override
    public OBinaryResponse executeClose(OCloseRequest request) {
        this.server.getClientConnectionManager().disconnect(this.connection);
        return null;
    }

    @Override
    public OBinaryResponse executeExistDatabase(OExistsDatabaseRequest request) {
        boolean result = this.server.existsDatabase(request.getDatabaseName());
        return new OExistsDatabaseResponse(result);
    }

    @Override
    public OBinaryResponse executeDropDatabase(ODropDatabaseRequest request) {
        this.server.dropDatabase(request.getDatabaseName());
        OLogManager.instance().info((Object)this, "Dropped database '%s'", request.getDatabaseName());
        this.connection.close();
        return new ODropDatabaseResponse();
    }

    @Override
    public OBinaryResponse executeGetSize(OGetSizeRequest request) {
        return new OGetSizeResponse(this.connection.getDatabase().getStorage().getSize());
    }

    @Override
    public OBinaryResponse executeCountRecords(OCountRecordsRequest request) {
        return new OCountRecordsResponse(this.connection.getDatabase().getStorage().countRecords());
    }

    @Override
    public OBinaryResponse executeDistributedStatus(ODistributedStatusRequest request) {
        ODocument req = request.getStatus();
        ODocument clusterConfig = new ODocument();
        String operation = (String)req.field("operation");
        if (operation == null) {
            throw new IllegalArgumentException("Cluster operation is null");
        }
        if (operation.equals("status")) {
            Object plugin = this.server.getPlugin("cluster");
            if (plugin != null && plugin instanceof ODistributedServerManager) {
                clusterConfig = ((ODistributedServerManager)plugin).getClusterConfiguration();
            }
        } else {
            throw new IllegalArgumentException("Cluster operation '" + operation + "' is not supported");
        }
        return new ODistributedStatusResponse(clusterConfig);
    }

    @Override
    public OBinaryResponse executeCountCluster(OCountRequest request) {
        long count = this.connection.getDatabase().countClusterElements(request.getClusterIds(), request.isCountTombstones());
        return new OCountResponse(count);
    }

    @Override
    public OBinaryResponse executeClusterDataRange(OGetClusterDataRangeRequest request) {
        long[] pos = this.connection.getDatabase().getStorage().getClusterDataRange(request.getClusterId());
        return new OGetClusterDataRangeResponse(pos);
    }

    @Override
    public OBinaryResponse executeAddCluster(OAddClusterRequest request) {
        int num = request.getRequestedId() < 0 ? this.connection.getDatabase().addCluster(request.getClusterName(), new Object[0]) : this.connection.getDatabase().addCluster(request.getClusterName(), request.getRequestedId());
        return new OAddClusterResponse(num);
    }

    @Override
    public OBinaryResponse executeDropCluster(ODropClusterRequest request) {
        String clusterName = this.connection.getDatabase().getClusterNameById(request.getClusterId());
        if (clusterName == null) {
            throw new IllegalArgumentException("Cluster " + request.getClusterId() + " does not exist anymore. Refresh the db structure or just reconnect to the database");
        }
        boolean result = this.connection.getDatabase().dropCluster(clusterName);
        return new ODropClusterResponse(result);
    }

    @Override
    public OBinaryResponse executeGetRecordMetadata(OGetRecordMetadataRequest request) {
        ORecordMetadata metadata = this.connection.getDatabase().getRecordMetadata(request.getRid());
        if (metadata != null) {
            return new OGetRecordMetadataResponse(metadata);
        }
        throw new ODatabaseException(String.format("Record metadata for RID: %s, Not found", request.getRid()));
    }

    @Override
    public OBinaryResponse executeReadRecord(OReadRecordRequest request) {
        OReadRecordResponse response;
        ORecordId rid = request.getRid();
        String fetchPlanString = request.getFetchPlan();
        boolean ignoreCache = false;
        ignoreCache = request.isIgnoreCache();
        boolean loadTombstones = false;
        loadTombstones = request.isLoadTumbstone();
        if (rid.getClusterId() == 0 && rid.getClusterPosition() == 0L) {
            OFetchHelper.checkFetchPlanValid(fetchPlanString);
            byte[] record = ((OClusterBasedStorageConfiguration)this.connection.getDatabase().getStorage().getConfiguration()).toStream(this.connection.getData().protocolVersion, StandardCharsets.UTF_8);
            response = new OReadRecordResponse(98, 0, record, new HashSet<ORecord>());
        } else {
            ORecord record = (ORecord)this.connection.getDatabase().load(rid, fetchPlanString, ignoreCache);
            if (record != null) {
                byte[] bytes = OConnectionBinaryExecutor.getRecordBytes(this.connection, record);
                final HashSet<ORecord> recordsToSend = new HashSet<ORecord>();
                if (record != null && fetchPlanString.length() > 0 && record instanceof ODocument) {
                    OFetchPlan fetchPlan = OFetchHelper.buildFetchPlan(fetchPlanString);
                    ODocument doc = (ODocument)record;
                    ORemoteFetchListener listener = new ORemoteFetchListener(){

                        @Override
                        protected void sendRecord(ORecord iLinked) {
                            recordsToSend.add(iLinked);
                        }
                    };
                    ORemoteFetchContext context = new ORemoteFetchContext();
                    OFetchHelper.fetch(doc, doc, fetchPlan, listener, context, "");
                }
                response = new OReadRecordResponse(ORecordInternal.getRecordType(record), record.getVersion(), bytes, recordsToSend);
            } else {
                response = new OReadRecordResponse(0, 0, null, null);
            }
        }
        return response;
    }

    @Override
    public OBinaryResponse executeReadRecordIfNotLastest(OReadRecordIfVersionIsNotLatestRequest request) {
        OReadRecordIfVersionIsNotLatestResponse response;
        ORecordId rid = request.getRid();
        int recordVersion = request.getRecordVersion();
        String fetchPlanString = request.getFetchPlan();
        boolean ignoreCache = request.isIgnoreCache();
        if (rid.getClusterId() == 0 && rid.getClusterPosition() == 0L) {
            OFetchHelper.checkFetchPlanValid(fetchPlanString);
            byte[] record = ((OClusterBasedStorageConfiguration)this.connection.getDatabase().getStorage().getConfiguration()).toStream(this.connection.getData().protocolVersion, StandardCharsets.UTF_8);
            response = new OReadRecordIfVersionIsNotLatestResponse(98, 0, record, new HashSet<ORecord>());
        } else {
            Object record = this.connection.getDatabase().loadIfVersionIsNotLatest(rid, recordVersion, fetchPlanString, ignoreCache);
            if (record != null) {
                byte[] bytes = OConnectionBinaryExecutor.getRecordBytes(this.connection, record);
                final HashSet<ORecord> recordsToSend = new HashSet<ORecord>();
                if (fetchPlanString.length() > 0 && record instanceof ODocument) {
                    OFetchPlan fetchPlan = OFetchHelper.buildFetchPlan(fetchPlanString);
                    ODocument doc = (ODocument)record;
                    ORemoteFetchListener listener = new ORemoteFetchListener(){

                        @Override
                        protected void sendRecord(ORecord iLinked) {
                            recordsToSend.add(iLinked);
                        }
                    };
                    ORemoteFetchContext context = new ORemoteFetchContext();
                    OFetchHelper.fetch(doc, doc, fetchPlan, listener, context, "");
                }
                response = new OReadRecordIfVersionIsNotLatestResponse(ORecordInternal.getRecordType(record), record.getVersion(), bytes, recordsToSend);
            } else {
                response = new OReadRecordIfVersionIsNotLatestResponse(0, 0, null, null);
            }
        }
        return response;
    }

    @Override
    public OBinaryResponse executeCreateRecord(OCreateRecordRequest request) {
        ORecord record = request.getContent();
        ORecordInternal.setIdentity(record, request.getRid());
        ORecordInternal.setVersion(record, 0);
        if (record instanceof ODocument) {
            ODocumentInternal.autoConvertValueToClass(this.connection.getDatabase(), (ODocument)record);
        }
        this.connection.getDatabase().save(record);
        if (request.getMode() < 2) {
            HashMap<UUID, OBonsaiCollectionPointer> changedIds;
            OSBTreeCollectionManager collectionManager = this.connection.getDatabase().getSbTreeCollectionManager();
            if (collectionManager != null) {
                changedIds = new HashMap<UUID, OBonsaiCollectionPointer>(collectionManager.changedIds());
                collectionManager.clearChangedIds();
            } else {
                changedIds = new HashMap();
            }
            return new OCreateRecordResponse((ORecordId)record.getIdentity(), record.getVersion(), changedIds);
        }
        return null;
    }

    @Override
    public OBinaryResponse executeUpdateRecord(OUpdateRecordRequest request) {
        ODatabaseDocumentInternal database = this.connection.getDatabase();
        ORecord newRecord = request.getContent();
        ORecordInternal.setIdentity(newRecord, request.getRid());
        ORecordInternal.setVersion(newRecord, request.getVersion());
        ORecordInternal.setContentChanged(newRecord, request.isUpdateContent());
        ORecordInternal.getDirtyManager(newRecord).clearForSave();
        ORecord currentRecord = null;
        if (newRecord instanceof ODocument) {
            block10: {
                try {
                    currentRecord = (ORecord)database.load(request.getRid());
                }
                catch (ORecordNotFoundException e) {
                    if (!(e.getCause() instanceof OOfflineClusterException)) break block10;
                    throw (OOfflineClusterException)e.getCause();
                }
            }
            if (currentRecord == null) {
                throw new ORecordNotFoundException(request.getRid());
            }
            ((ODocument)currentRecord).merge((ODocument)newRecord, false, false);
            if (request.isUpdateContent()) {
                ((ODocument)currentRecord).setDirty();
            }
        } else {
            currentRecord = newRecord;
        }
        ORecordInternal.setVersion(currentRecord, request.getVersion());
        database.save(currentRecord);
        if (currentRecord.getIdentity().toString().equals(database.getStorage().getConfiguration().getIndexMgrRecordId())) {
            database.getMetadata().getIndexManagerInternal().reload();
        }
        int newVersion = currentRecord.getVersion();
        if (request.getMode() < 2) {
            HashMap<UUID, OBonsaiCollectionPointer> changedIds;
            OSBTreeCollectionManager collectionManager = this.connection.getDatabase().getSbTreeCollectionManager();
            if (collectionManager != null) {
                changedIds = new HashMap<UUID, OBonsaiCollectionPointer>(collectionManager.changedIds());
                collectionManager.clearChangedIds();
            } else {
                changedIds = new HashMap();
            }
            return new OUpdateRecordResponse(newVersion, changedIds);
        }
        return null;
    }

    @Override
    public OBinaryResponse executeDeleteRecord(ODeleteRecordRequest request) {
        boolean result;
        ODatabaseDocumentInternal database = this.connection.getDatabase();
        try {
            ORecord record = (ORecord)database.load(request.getRid());
            if (record != null) {
                database.delete(request.getRid(), request.getVersion());
                result = true;
            } else {
                result = false;
            }
        }
        catch (ORecordNotFoundException e) {
            if (e.getCause() instanceof OOfflineClusterException) {
                throw (OOfflineClusterException)e.getCause();
            }
            result = false;
        }
        if (request.getMode() < 2) {
            return new ODeleteRecordResponse(result);
        }
        return null;
    }

    @Override
    public OBinaryResponse executeHigherPosition(OHigherPhysicalPositionsRequest request) {
        OPhysicalPosition[] nextPositions = this.connection.getDatabase().getStorage().higherPhysicalPositions(request.getClusterId(), request.getClusterPosition());
        return new OHigherPhysicalPositionsResponse(nextPositions);
    }

    @Override
    public OBinaryResponse executeCeilingPosition(OCeilingPhysicalPositionsRequest request) {
        OPhysicalPosition[] previousPositions = this.connection.getDatabase().getStorage().ceilingPhysicalPositions(request.getClusterId(), request.getPhysicalPosition());
        return new OCeilingPhysicalPositionsResponse(previousPositions);
    }

    @Override
    public OBinaryResponse executeLowerPosition(OLowerPhysicalPositionsRequest request) {
        OPhysicalPosition[] previousPositions = this.connection.getDatabase().getStorage().lowerPhysicalPositions(request.getiClusterId(), request.getPhysicalPosition());
        return new OLowerPhysicalPositionsResponse(previousPositions);
    }

    @Override
    public OBinaryResponse executeFloorPosition(OFloorPhysicalPositionsRequest request) {
        OPhysicalPosition[] previousPositions = this.connection.getDatabase().getStorage().floorPhysicalPositions(request.getClusterId(), request.getPhysicalPosition());
        return new OFloorPhysicalPositionsResponse(previousPositions);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OBinaryResponse executeCommand(OCommandRequest request) {
        OTransaction oldTx = this.connection.getDatabase().getTransaction();
        try {
            OCommandResponse response;
            this.connection.getDatabase().swapTx(new OTransactionNoTx(this.connection.getDatabase(), null));
            boolean live = request.isLive();
            boolean asynch = request.isAsynch();
            OSQLAsynchQuery command = request.getQuery();
            Map<Object, Object> params = command.getParameters();
            if (asynch && command instanceof OSQLSynchQuery) {
                OSQLAsynchQuery asynchQuery = new OSQLAsynchQuery(command.getText());
                asynchQuery.setFetchPlan(command.getFetchPlan());
                asynchQuery.setLimit(command.getLimit());
                asynchQuery.setTimeout(command.getTimeoutTime(), command.getTimeoutStrategy());
                asynchQuery.setUseCache(((OSQLSynchQuery)command).isUseCache());
                command = asynchQuery;
            }
            this.connection.getData().commandDetail = command.getText();
            this.connection.getData().command = command;
            OAbstractCommandResultListener listener = null;
            OLiveCommandResultListener liveListener = null;
            OCommandResultListener cmdResultListener = command.getResultListener();
            if (live) {
                liveListener = new OLiveCommandResultListener(this.server, this.connection, cmdResultListener);
                listener = new OSyncCommandResultListener(null);
                command.setResultListener(liveListener);
            } else if (asynch) {
                OCommandCache cmdCache = this.connection.getDatabase().getMetadata().getCommandCache();
                if (cmdCache.isEnabled()) {
                    cmdResultListener = new OCommandCacheRemoteResultListener(cmdResultListener, cmdCache);
                }
                listener = new OAsyncCommandResultListener(this.connection, cmdResultListener);
                command.setResultListener(listener);
            } else {
                listener = new OSyncCommandResultListener(null);
            }
            long serverTimeout = this.connection.getDatabase().getConfiguration().getValueAsLong(OGlobalConfiguration.COMMAND_TIMEOUT);
            if (serverTimeout > 0L && command.getTimeoutTime() > serverTimeout) {
                command.setTimeout(serverTimeout, command.getTimeoutStrategy());
            }
            command.setCacheableResult(true);
            OCommandRequestText commandRequest = (OCommandRequestText)this.connection.getDatabase().command(command);
            listener.setFetchPlan(commandRequest.getFetchPlan());
            if (asynch) {
                response = new OCommandResponse(null, listener, false, asynch, this.connection.getDatabase(), command, params);
            } else {
                Object result = params == null ? commandRequest.execute(new Object[0]) : commandRequest.execute(params);
                listener.setFetchPlan(commandRequest.getFetchPlan());
                boolean isRecordResultSet = true;
                isRecordResultSet = command.isRecordResultSet();
                response = new OCommandResponse(result, listener, isRecordResultSet, asynch, this.connection.getDatabase(), command, params);
            }
            OCommandResponse oCommandResponse = response;
            return oCommandResponse;
        }
        finally {
            this.connection.getDatabase().swapTx(oldTx);
        }
    }

    @Override
    public OBinaryResponse executeBatchOperations(OBatchOperationsRequest request) {
        ODatabaseDocumentInternal database = this.connection.getDatabase();
        OTransaction transaction = database.getTransaction();
        List<ORecordOperationRequest> operations = request.getOperations();
        ArrayList<OCommit37Response.OCreatedRecordResponse> createdRecords = new ArrayList<OCommit37Response.OCreatedRecordResponse>();
        ArrayList<OCommit37Response.OUpdatedRecordResponse> updatedRecords = new ArrayList<OCommit37Response.OUpdatedRecordResponse>();
        ArrayList<OCommit37Response.ODeletedRecordResponse> deletedRecords = new ArrayList<OCommit37Response.ODeletedRecordResponse>();
        for (ORecordOperationRequest operation : operations) {
            switch (operation.getType()) {
                case 3: {
                    ORecord record = Orient.instance().getRecordFactoryManager().newInstance(operation.getRecordType(), operation.getId().getClusterId(), database);
                    this.connection.getData().getSerializer().fromStream(operation.getRecord(), record, null);
                    ORecordId current = (ORecordId)record.getIdentity();
                    OCreateRecordResponse createRecordResponse = (OCreateRecordResponse)this.executeCreateRecord(new OCreateRecordRequest(record, (ORecordId)operation.getId(), operation.getRecordType()));
                    if (transaction.isActive()) {
                        ((OTransactionOptimisticServer)transaction).getCreatedRecords().put((ORecordId)record.getIdentity(), record);
                    }
                    createdRecords.add(new OCommit37Response.OCreatedRecordResponse(current, createRecordResponse.getIdentity(), createRecordResponse.getVersion()));
                    break;
                }
                case 1: {
                    ORecord record = Orient.instance().getRecordFactoryManager().newInstance(operation.getRecordType(), operation.getId().getClusterId(), database);
                    this.connection.getData().getSerializer().fromStream(operation.getRecord(), record, null);
                    ORecordId current = (ORecordId)record.getIdentity();
                    OUpdateRecordResponse updateRecordResponse = (OUpdateRecordResponse)this.executeUpdateRecord(new OUpdateRecordRequest((ORecordId)operation.getId(), record, operation.getVersion(), true, operation.getRecordType()));
                    if (transaction.isActive()) {
                        ((OTransactionOptimisticServer)transaction).getUpdatedRecords().put((ORecordId)record.getIdentity(), record);
                    }
                    updatedRecords.add(new OCommit37Response.OUpdatedRecordResponse(current, updateRecordResponse.getVersion()));
                    break;
                }
                case 2: {
                    this.executeDeleteRecord(new ODeleteRecordRequest((ORecordId)operation.getId(), operation.getVersion()));
                    deletedRecords.add(new OCommit37Response.ODeletedRecordResponse(operation.getId()));
                }
            }
        }
        return new OBatchOperationsResponse(database.getTransaction().getId(), createdRecords, updatedRecords, deletedRecords);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public OBinaryResponse executeCommit(OCommitRequest request) {
        OTransactionOptimisticProxy tx = new OTransactionOptimisticProxy(this.connection.getDatabase(), request.getTxId(), request.isUsingLong(), request.getOperations(), request.getIndexChanges(), this.connection.getData().protocolVersion, this.connection.getData().getSerializer());
        try {
            try {
                this.connection.getDatabase().rawBegin(tx);
            }
            catch (ORecordNotFoundException e) {
                throw e.getCause() instanceof OOfflineClusterException ? (OOfflineClusterException)e.getCause() : e;
            }
            try {
                void var6_16;
                try {
                    this.connection.getDatabase().commit();
                }
                catch (ORecordNotFoundException e) {
                    throw e.getCause() instanceof OOfflineClusterException ? (OOfflineClusterException)e.getCause() : e;
                }
                ArrayList<OCommitResponse.OCreatedRecordResponse> createdRecords = new ArrayList<OCommitResponse.OCreatedRecordResponse>(tx.getCreatedRecords().size());
                for (Map.Entry<ORecordId, ORecord> entry : tx.getCreatedRecords().entrySet()) {
                    createdRecords.add(new OCommitResponse.OCreatedRecordResponse(entry.getKey(), (ORecordId)entry.getValue().getIdentity()));
                    if (entry.getValue().getVersion() <= 0) continue;
                    tx.getUpdatedRecords().put((ORecordId)entry.getValue().getIdentity(), entry.getValue());
                }
                ArrayList<OCommitResponse.OUpdatedRecordResponse> updatedRecords = new ArrayList<OCommitResponse.OUpdatedRecordResponse>(tx.getUpdatedRecords().size());
                for (Map.Entry<ORecordId, ORecord> entry : tx.getUpdatedRecords().entrySet()) {
                    updatedRecords.add(new OCommitResponse.OUpdatedRecordResponse(entry.getKey(), entry.getValue().getVersion()));
                }
                OSBTreeCollectionManager oSBTreeCollectionManager = this.connection.getDatabase().getSbTreeCollectionManager();
                Object var6_14 = null;
                if (oSBTreeCollectionManager != null) {
                    Map<UUID, OBonsaiCollectionPointer> map = oSBTreeCollectionManager.changedIds();
                }
                return new OCommitResponse(createdRecords, updatedRecords, (Map<UUID, OBonsaiCollectionPointer>)var6_16);
            }
            catch (RuntimeException e) {
                if (this.connection != null && this.connection.getDatabase() != null) {
                    OSBTreeCollectionManager collectionManager;
                    if (this.connection.getDatabase().getTransaction().isActive()) {
                        this.connection.getDatabase().rollback(true);
                    }
                    if ((collectionManager = this.connection.getDatabase().getSbTreeCollectionManager()) != null) {
                        collectionManager.clearChangedIds();
                    }
                }
                throw e;
            }
        }
        catch (RuntimeException e) {
            if (tx.isActive()) {
                tx.rollback(true, -1);
            }
            throw e;
        }
    }

    @Override
    public OBinaryResponse executeGetGlobalConfiguration(OGetGlobalConfigurationRequest request) {
        OGlobalConfiguration cfg = OGlobalConfiguration.findByKey(request.getKey());
        String cfgValue = cfg != null ? (cfg.isHidden() ? "<hidden>" : cfg.getValueAsString()) : "";
        return new OGetGlobalConfigurationResponse(cfgValue);
    }

    @Override
    public OBinaryResponse executeListGlobalConfigurations(OListGlobalConfigurationsRequest request) {
        HashMap<String, String> configs = new HashMap<String, String>();
        for (OGlobalConfiguration cfg : OGlobalConfiguration.values()) {
            String value;
            String key;
            try {
                key = cfg.getKey();
            }
            catch (Exception e) {
                key = "?";
            }
            if (cfg.isHidden()) {
                value = "<hidden>";
            } else {
                try {
                    OContextConfiguration config = this.connection.getProtocol().getServer().getContextConfiguration();
                    value = config.getValueAsString(cfg) != null ? config.getValueAsString(cfg) : "";
                }
                catch (Exception e) {
                    value = "";
                }
            }
            configs.put(key, value);
        }
        return new OListGlobalConfigurationsResponse(configs);
    }

    @Override
    public OBinaryResponse executeFreezeDatabase(OFreezeDatabaseRequest request) {
        ODatabaseDocumentInternal database = this.server.openDatabase(request.getName(), this.connection.getServerUser().name, null, this.connection.getData(), true);
        this.connection.setDatabase(database);
        OLogManager.instance().info((Object)this, "Freezing database '%s'", this.connection.getDatabase().getURL());
        this.connection.getDatabase().freeze(true);
        return new OFreezeDatabaseResponse();
    }

    @Override
    public OBinaryResponse executeReleaseDatabase(OReleaseDatabaseRequest request) {
        ODatabaseDocumentInternal database = this.server.openDatabase(request.getName(), this.connection.getServerUser().name, null, this.connection.getData(), true);
        this.connection.setDatabase(database);
        OLogManager.instance().info((Object)this, "Realising database '%s'", this.connection.getDatabase().getURL());
        this.connection.getDatabase().release();
        return new OReleaseDatabaseResponse();
    }

    @Override
    public OBinaryResponse executeCleanOutRecord(OCleanOutRecordRequest request) {
        this.connection.getDatabase().cleanOutRecord(request.getRecordId(), request.getRecordVersion());
        if (request.getMode() < 2) {
            return new OCleanOutRecordResponse(true);
        }
        return null;
    }

    @Override
    public OBinaryResponse executeSBTreeCreate(OSBTCreateTreeRequest request) {
        OBonsaiCollectionPointer collectionPointer = null;
        try {
            ODatabaseDocumentInternal database = this.connection.getDatabase();
            OAbstractPaginatedStorage storage = (OAbstractPaginatedStorage)database.getStorage();
            OAtomicOperationsManager atomicOperationsManager = storage.getAtomicOperationsManager();
            collectionPointer = atomicOperationsManager.calculateInsideAtomicOperation(null, atomicOperation -> this.connection.getDatabase().getSbTreeCollectionManager().createSBTree(request.getClusterId(), atomicOperation, null));
        }
        catch (IOException e) {
            throw OException.wrapException(new ODatabaseException("Error during ridbag creation"), e);
        }
        return new OSBTCreateTreeResponse(collectionPointer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OBinaryResponse executeSBTGet(OSBTGetRequest request) {
        OSBTreeCollectionManager sbTreeCollectionManager = this.connection.getDatabase().getSbTreeCollectionManager();
        OSBTreeBonsai<OIdentifiable, Integer> tree = sbTreeCollectionManager.loadSBTree(request.getCollectionPointer());
        try {
            OIdentifiable key = tree.getKeySerializer().deserialize(request.getKeyStream(), 0);
            Integer result = tree.get(key);
            OBinarySerializer<Object> valueSerializer = result == null ? ONullSerializer.INSTANCE : tree.getValueSerializer();
            byte[] stream = new byte[1 + valueSerializer.getObjectSize(result, new Object[0])];
            OByteSerializer.INSTANCE.serialize(valueSerializer.getId(), stream, 0, new Object[0]);
            valueSerializer.serialize(result, stream, 1, new Object[0]);
            OSBTGetResponse oSBTGetResponse = new OSBTGetResponse(stream);
            return oSBTGetResponse;
        }
        finally {
            sbTreeCollectionManager.releaseSBTree(request.getCollectionPointer());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OBinaryResponse executeSBTFirstKey(OSBTFirstKeyRequest request) {
        OSBTreeCollectionManager sbTreeCollectionManager = this.connection.getDatabase().getSbTreeCollectionManager();
        OSBTreeBonsai<OIdentifiable, Integer> tree = sbTreeCollectionManager.loadSBTree(request.getCollectionPointer());
        try {
            OIdentifiable result = tree.firstKey();
            OBinarySerializer<Object> keySerializer = result == null ? ONullSerializer.INSTANCE : tree.getKeySerializer();
            byte[] stream = new byte[1 + keySerializer.getObjectSize(result, new Object[0])];
            OByteSerializer.INSTANCE.serialize(keySerializer.getId(), stream, 0, new Object[0]);
            keySerializer.serialize(result, stream, 1, new Object[0]);
            OSBTFirstKeyResponse oSBTFirstKeyResponse = new OSBTFirstKeyResponse(stream);
            return oSBTFirstKeyResponse;
        }
        finally {
            sbTreeCollectionManager.releaseSBTree(request.getCollectionPointer());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OBinaryResponse executeSBTFetchEntriesMajor(OSBTFetchEntriesMajorRequest request) {
        OSBTreeCollectionManager sbTreeCollectionManager = this.connection.getDatabase().getSbTreeCollectionManager();
        OSBTreeBonsai<OIdentifiable, Integer> tree = sbTreeCollectionManager.loadSBTree(request.getPointer());
        try {
            OBinarySerializer<OIdentifiable> keySerializer = tree.getKeySerializer();
            OIdentifiable key = keySerializer.deserialize(request.getKeyStream(), 0);
            OBinarySerializer<Integer> valueSerializer = tree.getValueSerializer();
            OTreeInternal.AccumulativeListener listener = new OTreeInternal.AccumulativeListener(request.getPageSize());
            tree.loadEntriesMajor(key, request.isInclusive(), true, listener);
            List result = listener.getResult();
            OSBTFetchEntriesMajorResponse<OIdentifiable, Integer> oSBTFetchEntriesMajorResponse = new OSBTFetchEntriesMajorResponse<OIdentifiable, Integer>(keySerializer, valueSerializer, result);
            return oSBTFetchEntriesMajorResponse;
        }
        finally {
            sbTreeCollectionManager.releaseSBTree(request.getPointer());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OBinaryResponse executeSBTGetRealSize(OSBTGetRealBagSizeRequest request) {
        OSBTreeCollectionManager sbTreeCollectionManager = this.connection.getDatabase().getSbTreeCollectionManager();
        OSBTreeBonsai<OIdentifiable, Integer> tree = sbTreeCollectionManager.loadSBTree(request.getCollectionPointer());
        try {
            int realSize = tree.getRealBagSize(request.getChanges());
            OSBTGetRealBagSizeResponse oSBTGetRealBagSizeResponse = new OSBTGetRealBagSizeResponse(realSize);
            return oSBTGetRealBagSizeResponse;
        }
        finally {
            sbTreeCollectionManager.releaseSBTree(request.getCollectionPointer());
        }
    }

    @Override
    public OBinaryResponse executeIncrementalBackup(OIncrementalBackupRequest request) {
        String fileName = this.connection.getDatabase().incrementalBackup(request.getBackupDirectory());
        return new OIncrementalBackupResponse(fileName);
    }

    @Override
    public OBinaryResponse executeImport(OImportRequest request) {
        ArrayList<String> result = new ArrayList<String>();
        OLogManager.instance().info((Object)this, "Starting database import", new Object[0]);
        try {
            ODatabaseImport imp = new ODatabaseImport(this.connection.getDatabase(), request.getImporPath(), iText -> {
                OLogManager.instance().debug((Object)this, iText, new Object[0]);
                if (iText != null) {
                    result.add(iText);
                }
            });
            imp.setOptions(request.getOptions());
            imp.importDatabase();
            imp.close();
            new File(request.getImporPath()).delete();
        }
        catch (IOException e) {
            throw OException.wrapException(new ODatabaseException("error on import"), e);
        }
        return new OImportResponse(result);
    }

    @Override
    public OBinaryResponse executeConnect(OConnectRequest request) {
        OBinaryProtocolHelper.checkProtocolVersion(this, request.getProtocolVersion());
        if (request.getProtocolVersion() > 36) {
            throw new OConfigurationException("You can use connect as first operation only for protocol  < 37 please use handshake for protocol >= 37");
        }
        this.connection.getData().driverName = request.getDriverName();
        this.connection.getData().driverVersion = request.getDriverVersion();
        this.connection.getData().protocolVersion = request.getProtocolVersion();
        this.connection.getData().clientId = request.getClientId();
        this.connection.getData().setSerializationImpl(request.getRecordFormat());
        this.connection.setTokenBased(request.isTokenBased());
        this.connection.getData().supportsLegacyPushMessages = request.isSupportPush();
        this.connection.getData().collectStats = request.isCollectStats();
        if (!request.isTokenBased()) {
            OLogManager.instance().warn((Object)this, "Session open with token flag false is not supported anymore please use token based sessions", new Object[0]);
            throw new OConfigurationException("Session open with token flag false is not supported anymore please use token based sessions");
        }
        this.connection.setServerUser(this.server.serverLogin(request.getUsername(), request.getPassword(), "server.connect"));
        if (this.connection.getServerUser() == null) {
            throw new OSecurityAccessException("Wrong user/password to [connect] to the remote OrientDB Server instance");
        }
        byte[] token = null;
        if (this.connection.getData().protocolVersion > 26) {
            this.connection.getData().serverUsername = this.connection.getServerUser().name;
            this.connection.getData().serverUser = true;
            token = Boolean.TRUE.equals(this.connection.getTokenBased()) ? this.server.getTokenHandler().getSignedBinaryToken(null, null, this.connection.getData()) : OCommonConst.EMPTY_BYTE_ARRAY;
        }
        return new OConnectResponse(this.connection.getId(), token);
    }

    @Override
    public OBinaryResponse executeConnect37(OConnect37Request request) {
        this.connection.getData().driverName = this.handshakeInfo.getDriverName();
        this.connection.getData().driverVersion = this.handshakeInfo.getDriverVersion();
        this.connection.getData().protocolVersion = this.handshakeInfo.getProtocolVersion();
        this.connection.getData().setSerializer(this.handshakeInfo.getSerializer());
        this.connection.setTokenBased(true);
        this.connection.getData().supportsLegacyPushMessages = false;
        this.connection.getData().collectStats = true;
        this.connection.setServerUser(this.server.serverLogin(request.getUsername(), request.getPassword(), "server.connect"));
        if (this.connection.getServerUser() == null) {
            throw new OSecurityAccessException("Wrong user/password to [connect] to the remote OrientDB Server instance");
        }
        byte[] token = null;
        if (this.connection.getData().protocolVersion > 26) {
            this.connection.getData().serverUsername = this.connection.getServerUser().name;
            this.connection.getData().serverUser = true;
            token = Boolean.TRUE.equals(this.connection.getTokenBased()) ? this.server.getTokenHandler().getSignedBinaryToken(null, null, this.connection.getData()) : OCommonConst.EMPTY_BYTE_ARRAY;
        }
        return new OConnectResponse(this.connection.getId(), token);
    }

    @Override
    public OBinaryResponse executeDatabaseOpen(OOpenRequest request) {
        OBinaryProtocolHelper.checkProtocolVersion(this, request.getProtocolVersion());
        if (request.getProtocolVersion() > 36) {
            throw new OConfigurationException("You can use open as first operation only for protocol  < 37 please use handshake for protocol >= 37");
        }
        this.connection.getData().driverName = request.getDriverName();
        this.connection.getData().driverVersion = request.getDriverVersion();
        this.connection.getData().protocolVersion = request.getProtocolVersion();
        this.connection.getData().clientId = request.getClientId();
        this.connection.getData().setSerializationImpl(request.getRecordFormat());
        if (!request.isUseToken()) {
            OLogManager.instance().warn((Object)this, "Session open with token flag false is not supported anymore please use token based sessions", new Object[0]);
            throw new OConfigurationException("Session open with token flag false is not supported anymore please use token based sessions");
        }
        this.connection.setTokenBased(request.isUseToken());
        this.connection.getData().supportsLegacyPushMessages = request.isSupportsPush();
        this.connection.getData().collectStats = request.isCollectStats();
        try {
            this.connection.setDatabase(this.server.openDatabase(request.getDatabaseName(), request.getUserName(), request.getUserPassword(), this.connection.getData()));
        }
        catch (OException e) {
            this.server.getClientConnectionManager().disconnect(this.connection);
            throw e;
        }
        byte[] token = null;
        if (Boolean.TRUE.equals(this.connection.getTokenBased())) {
            token = this.server.getTokenHandler().getSignedBinaryToken(this.connection.getDatabase(), this.connection.getDatabase().getUser(), this.connection.getData());
            this.server.getClientConnectionManager().connect(this.connection.getProtocol(), this.connection, token, this.server.getTokenHandler());
        }
        if (this.connection.getDatabase().getStorage() instanceof OStorageProxy) {
            this.connection.getDatabase().getMetadata().getSecurity().authenticate(request.getUserName(), request.getUserPassword());
        }
        OStorage storage = this.connection.getDatabase().getStorage();
        Set<String> clusters = storage.getClusterNames();
        byte[] tokenToSend = Boolean.TRUE.equals(this.connection.getTokenBased()) ? token : OCommonConst.EMPTY_BYTE_ARRAY;
        Object plugin = this.server.getPlugin("cluster");
        byte[] distriConf = null;
        if (plugin instanceof ODistributedServerManager) {
            ODocument distributedCfg = ((ODistributedServerManager)plugin).getClusterConfiguration();
            ODistributedConfiguration dbCfg = ((ODistributedServerManager)plugin).getDatabaseConfiguration(this.connection.getDatabase().getName());
            if (dbCfg != null) {
                distributedCfg.field("database", dbCfg.getDocument(), OType.EMBEDDED);
            }
            distriConf = OConnectionBinaryExecutor.getRecordBytes(this.connection, distributedCfg);
        }
        String[] clusterNames = new String[clusters.size()];
        int[] clusterIds = new int[clusters.size()];
        int counter = 0;
        for (String name : clusters) {
            int clusterId = storage.getClusterIdByName(name);
            if (clusterId < 0) continue;
            clusterNames[counter] = name;
            clusterIds[counter] = clusterId;
            ++counter;
        }
        if (counter < clusters.size()) {
            clusterNames = Arrays.copyOf(clusterNames, counter);
            clusterIds = Arrays.copyOf(clusterIds, counter);
        }
        return new OOpenResponse(this.connection.getId(), tokenToSend, clusterIds, clusterNames, distriConf, OConstants.getVersion());
    }

    @Override
    public OBinaryResponse executeDatabaseOpen37(OOpen37Request request) {
        this.connection.setTokenBased(true);
        this.connection.getData().supportsLegacyPushMessages = false;
        this.connection.getData().collectStats = true;
        this.connection.getData().driverName = this.handshakeInfo.getDriverName();
        this.connection.getData().driverVersion = this.handshakeInfo.getDriverVersion();
        this.connection.getData().protocolVersion = this.handshakeInfo.getProtocolVersion();
        this.connection.getData().setSerializer(this.handshakeInfo.getSerializer());
        try {
            this.connection.setDatabase(this.server.openDatabase(request.getDatabaseName(), request.getUserName(), request.getUserPassword(), this.connection.getData()));
        }
        catch (OException e) {
            this.server.getClientConnectionManager().disconnect(this.connection);
            throw e;
        }
        byte[] token = null;
        token = this.server.getTokenHandler().getSignedBinaryToken(this.connection.getDatabase(), this.connection.getDatabase().getUser(), this.connection.getData());
        this.server.getClientConnectionManager().connect(this.connection.getProtocol(), this.connection, token, this.server.getTokenHandler());
        return new OOpen37Response(this.connection.getId(), token);
    }

    @Override
    public OBinaryResponse executeShutdown(OShutdownRequest request) {
        OLogManager.instance().info((Object)this, "Received shutdown command from the remote client ", new Object[0]);
        String user = request.getRootUser();
        String passwd = request.getRootPassword();
        if (this.server.authenticate(user, passwd, "server.shutdown")) {
            OLogManager.instance().info((Object)this, "Remote client authenticated. Starting shutdown of server...", new Object[0]);
            this.runShutdownInNonDaemonThread();
            return new OShutdownResponse();
        }
        OLogManager.instance().error(this, "Authentication error of remote client: shutdown is aborted.", null, new Object[0]);
        throw new OSecurityAccessException("Invalid user/password to shutdown the server");
    }

    private void runShutdownInNonDaemonThread() {
        Thread shutdownThread = new Thread("OrientDB server shutdown thread"){

            @Override
            public void run() {
                OConnectionBinaryExecutor.this.server.shutdown();
            }
        };
        shutdownThread.setDaemon(false);
        shutdownThread.start();
    }

    @Override
    public OBinaryResponse executeReopen(OReopenRequest request) {
        return new OReopenResponse(this.connection.getId());
    }

    @Override
    public OBinaryResponse executeSetGlobalConfig(OSetGlobalConfigurationRequest request) {
        OGlobalConfiguration cfg = OGlobalConfiguration.findByKey(request.getKey());
        if (cfg != null) {
            cfg.setValue(request.getValue());
            if (!cfg.isChangeableAtRuntime().booleanValue()) {
                throw new OConfigurationException("Property '" + request.getKey() + "' cannot be changed at runtime. Change the setting at startup");
            }
        } else {
            throw new OConfigurationException("Property '" + request.getKey() + "' was not found in global configuration");
        }
        return new OSetGlobalConfigurationResponse();
    }

    public static byte[] getRecordBytes(OClientConnection connection, ORecord iRecord) {
        byte[] stream;
        String dbSerializerName = null;
        if (ODatabaseRecordThreadLocal.instance().getIfDefined() != null) {
            dbSerializerName = ((ODatabaseDocumentInternal)iRecord.getDatabase()).getSerializer().toString();
        }
        String name = connection.getData().getSerializationImpl();
        if (!(ORecordInternal.getRecordType(iRecord) != 100 || dbSerializerName != null && dbSerializerName.equals(name))) {
            ((ODocument)iRecord).deserializeFields(new String[0]);
            ORecordSerializer ser = ORecordSerializerFactory.instance().getFormat(name);
            stream = ser.toStream(iRecord);
        } else {
            stream = iRecord.toStream();
        }
        return stream;
    }

    @Override
    public OBinaryResponse executeQuery(OQueryRequest request) {
        ODatabaseDocumentInternal database = this.connection.getDatabase();
        OQueryMetadataUpdateListener metadataListener = new OQueryMetadataUpdateListener();
        database.getSharedContext().registerListener(metadataListener);
        if (database.getTransaction().isActive()) {
            ((OTransactionOptimistic)database.getTransaction()).resetChangesTracking();
        }
        OResultSet rs = OQueryRequest.QUERY == request.getOperationType() ? (request.isNamedParams() ? database.query(request.getStatement(), request.getNamedParameters()) : database.query(request.getStatement(), request.getPositionalParameters())) : (OQueryRequest.COMMAND == request.getOperationType() ? (request.isNamedParams() ? database.command(request.getStatement(), request.getNamedParameters()) : database.command(request.getStatement(), request.getPositionalParameters())) : (request.isNamedParams() ? database.execute(request.getLanguage(), request.getStatement(), request.getNamedParameters()) : database.execute(request.getLanguage(), request.getStatement(), request.getPositionalParameters())));
        Stream<OResult> stream = rs.stream();
        if (database.getActiveQueries().containsKey(((OLocalResultSetLifecycleDecorator)rs).getQueryId())) {
            stream = stream.limit(request.getRecordsPerPage());
        }
        List<OResultInternal> rsCopy = stream.map(r -> (OResultInternal)r).collect(Collectors.toList());
        boolean hasNext = rs.hasNext();
        boolean txChanges = false;
        if (database.getTransaction().isActive()) {
            txChanges = ((OTransactionOptimistic)database.getTransaction()).isChanged();
        }
        database.getSharedContext().unregisterListener(metadataListener);
        return new OQueryResponse(((OLocalResultSetLifecycleDecorator)rs).getQueryId(), txChanges, rsCopy, rs.getExecutionPlan(), hasNext, rs.getQueryStats(), metadataListener.isUpdated());
    }

    @Override
    public OBinaryResponse closeQuery(OCloseQueryRequest oQueryRequest) {
        String queryId = oQueryRequest.getQueryId();
        ODatabaseDocumentInternal db = this.connection.getDatabase();
        OResultSet query = db.getActiveQuery(queryId);
        if (query != null) {
            query.close();
        }
        return new OCloseQueryResponse();
    }

    @Override
    public OBinaryResponse executeQueryNextPage(OQueryNextPageRequest request) {
        OLocalResultSetLifecycleDecorator rs = (OLocalResultSetLifecycleDecorator)this.connection.getDatabase().getActiveQuery(request.getQueryId());
        if (rs == null) {
            throw new ODatabaseException(String.format("No query with id '%s' found probably expired session", request.getQueryId()));
        }
        ArrayList<OResultInternal> rsCopy = new ArrayList<OResultInternal>(request.getRecordsPerPage());
        for (int i = 0; rs.hasNext() && (rs.isDetached() || i < request.getRecordsPerPage()); ++i) {
            rsCopy.add((OResultInternal)rs.next());
        }
        boolean hasNext = rs.hasNext();
        return new OQueryResponse(rs.getQueryId(), false, rsCopy, rs.getExecutionPlan(), hasNext, rs.getQueryStats(), false);
    }

    @Override
    public OBinaryResponse executeBeginTransaction(OBeginTransactionRequest request) {
        OTransactionOptimisticServer tx = new OTransactionOptimisticServer(this.connection.getDatabase(), request.getTxId(), request.isUsingLog(), request.getOperations(), request.getIndexChanges());
        try {
            this.connection.getDatabase().rawBegin(tx);
        }
        catch (ORecordNotFoundException e) {
            throw e.getCause() instanceof OOfflineClusterException ? (OOfflineClusterException)e.getCause() : e;
        }
        return new OBeginTransactionResponse(tx.getId(), tx.getUpdatedRids());
    }

    @Override
    public OBinaryResponse executeBeginTransaction38(OBeginTransaction38Request request) {
        OTransactionOptimisticServer tx = new OTransactionOptimisticServer(this.connection.getDatabase(), request.getTxId(), request.isUsingLog(), request.getOperations(), request.getIndexChanges());
        try {
            this.connection.getDatabase().rawBegin(tx);
        }
        catch (ORecordNotFoundException e) {
            throw e.getCause() instanceof OOfflineClusterException ? (OOfflineClusterException)e.getCause() : e;
        }
        return new OBeginTransactionResponse(tx.getId(), tx.getUpdatedRids());
    }

    @Override
    public OBinaryResponse executeCommit37(OCommit37Request request) {
        OTransactionOptimisticServer tx;
        ODatabaseDocumentInternal database = this.connection.getDatabase();
        if (request.isHasContent()) {
            tx = new OTransactionOptimisticServer(database, request.getTxId(), request.isUsingLog(), request.getOperations(), request.getIndexChanges());
            try {
                database.rawBegin(tx);
            }
            catch (ORecordNotFoundException e) {
                throw e.getCause() instanceof OOfflineClusterException ? (OOfflineClusterException)e.getCause() : e;
            }
        } else if (database.getTransaction().isActive()) {
            tx = (OTransactionOptimisticServer)database.getTransaction();
        } else {
            throw new ODatabaseException("No transaction active on the server, send full content");
        }
        tx.assignClusters();
        database.commit();
        ArrayList<OCommit37Response.OCreatedRecordResponse> createdRecords = new ArrayList<OCommit37Response.OCreatedRecordResponse>(tx.getCreatedRecords().size());
        for (Map.Entry<ORecordId, ORecord> entry : tx.getCreatedRecords().entrySet()) {
            ORecord oRecord = entry.getValue();
            createdRecords.add(new OCommit37Response.OCreatedRecordResponse(entry.getKey(), (ORecordId)oRecord.getIdentity(), oRecord.getVersion()));
        }
        ArrayList<OCommit37Response.OUpdatedRecordResponse> updatedRecords = new ArrayList<OCommit37Response.OUpdatedRecordResponse>(tx.getUpdatedRecords().size());
        for (Map.Entry<ORecordId, ORecord> entry : tx.getUpdatedRecords().entrySet()) {
            updatedRecords.add(new OCommit37Response.OUpdatedRecordResponse(entry.getKey(), entry.getValue().getVersion()));
        }
        ArrayList<OCommit37Response.ODeletedRecordResponse> arrayList = new ArrayList<OCommit37Response.ODeletedRecordResponse>(tx.getDeletedRecord().size());
        for (ORID id : tx.getDeletedRecord()) {
            arrayList.add(new OCommit37Response.ODeletedRecordResponse(id));
        }
        OSBTreeCollectionManager oSBTreeCollectionManager = database.getSbTreeCollectionManager();
        HashMap<UUID, OBonsaiCollectionPointer> changedIds = null;
        if (oSBTreeCollectionManager != null) {
            changedIds = new HashMap<UUID, OBonsaiCollectionPointer>(oSBTreeCollectionManager.changedIds());
            oSBTreeCollectionManager.clearChangedIds();
        }
        return new OCommit37Response(createdRecords, updatedRecords, arrayList, changedIds);
    }

    @Override
    public OBinaryResponse executeCommit38(OCommit38Request request) {
        OTransactionOptimisticServer tx;
        ODatabaseDocumentInternal database = this.connection.getDatabase();
        if (request.isHasContent()) {
            tx = new OTransactionOptimisticServer(database, request.getTxId(), request.isUsingLog(), request.getOperations(), request.getIndexChanges());
            try {
                database.rawBegin(tx);
            }
            catch (ORecordNotFoundException e) {
                throw e.getCause() instanceof OOfflineClusterException ? (OOfflineClusterException)e.getCause() : e;
            }
        } else if (database.getTransaction().isActive()) {
            tx = (OTransactionOptimisticServer)database.getTransaction();
        } else {
            throw new ODatabaseException("No transaction active on the server, send full content");
        }
        tx.assignClusters();
        database.commit();
        ArrayList<OCommit37Response.OCreatedRecordResponse> createdRecords = new ArrayList<OCommit37Response.OCreatedRecordResponse>(tx.getCreatedRecords().size());
        for (Map.Entry<ORecordId, ORecord> entry : tx.getCreatedRecords().entrySet()) {
            ORecord oRecord = entry.getValue();
            createdRecords.add(new OCommit37Response.OCreatedRecordResponse(entry.getKey(), (ORecordId)oRecord.getIdentity(), oRecord.getVersion()));
        }
        ArrayList<OCommit37Response.OUpdatedRecordResponse> updatedRecords = new ArrayList<OCommit37Response.OUpdatedRecordResponse>(tx.getUpdatedRecords().size());
        for (Map.Entry<ORecordId, ORecord> entry : tx.getUpdatedRecords().entrySet()) {
            updatedRecords.add(new OCommit37Response.OUpdatedRecordResponse(entry.getKey(), entry.getValue().getVersion()));
        }
        ArrayList<OCommit37Response.ODeletedRecordResponse> arrayList = new ArrayList<OCommit37Response.ODeletedRecordResponse>(tx.getDeletedRecord().size());
        for (ORID id : tx.getDeletedRecord()) {
            arrayList.add(new OCommit37Response.ODeletedRecordResponse(id));
        }
        OSBTreeCollectionManager oSBTreeCollectionManager = database.getSbTreeCollectionManager();
        HashMap<UUID, OBonsaiCollectionPointer> changedIds = null;
        if (oSBTreeCollectionManager != null) {
            changedIds = new HashMap<UUID, OBonsaiCollectionPointer>(oSBTreeCollectionManager.changedIds());
            oSBTreeCollectionManager.clearChangedIds();
        }
        return new OCommit37Response(createdRecords, updatedRecords, arrayList, changedIds);
    }

    @Override
    public OBinaryResponse executeFetchTransaction(OFetchTransactionRequest request) {
        ODatabaseDocumentInternal database = this.connection.getDatabase();
        if (!database.getTransaction().isActive()) {
            throw new ODatabaseException("No Transaction Active");
        }
        OTransactionOptimistic tx = (OTransactionOptimistic)database.getTransaction();
        return new OFetchTransactionResponse(tx.getId(), tx.getRecordOperations(), tx.getIndexOperations(), tx.getUpdatedRids());
    }

    @Override
    public OBinaryResponse executeFetchTransaction38(OFetchTransaction38Request request) {
        ODatabaseDocumentInternal database = this.connection.getDatabase();
        if (!database.getTransaction().isActive()) {
            throw new ODatabaseException("No Transaction Active");
        }
        OTransactionOptimistic tx = (OTransactionOptimistic)database.getTransaction();
        return new OFetchTransaction38Response(tx.getId(), tx.getRecordOperations(), tx.getIndexOperations(), tx.getUpdatedRids(), database);
    }

    @Override
    public OBinaryResponse executeRollback(ORollbackTransactionRequest request) {
        ODatabaseDocumentInternal database = this.connection.getDatabase();
        if (database.getTransaction().isActive()) {
            database.rollback(true);
        }
        return new ORollbackTransactionResponse();
    }

    @Override
    public OBinaryResponse executeSubscribe(OSubscribeRequest request) {
        return new OSubscribeResponse(request.getPushRequest().execute(this));
    }

    @Override
    public OBinaryResponse executeUnsubscribe(OUnsubscribeRequest request) {
        return new OUnsubscribeResponse(request.getUnsubscribeRequest().execute(this));
    }

    @Override
    public OBinaryResponse executeSubscribeDistributedConfiguration(OSubscribeDistributedConfigurationRequest request) {
        OPushManager manager = this.server.getPushManager();
        manager.subscribeDistributeConfig((ONetworkProtocolBinary)this.connection.getProtocol());
        Set<String> dbs = this.server.listDatabases();
        ODistributedServerManager plugin = (ODistributedServerManager)this.server.getPlugin("cluster");
        if (plugin != null) {
            Orient.instance().submit(() -> {
                for (String db : dbs) {
                    plugin.notifyClients(db);
                }
            });
        }
        return new OSubscribeDistributedConfigurationResponse();
    }

    @Override
    public OBinaryResponse executeSubscribeStorageConfiguration(OSubscribeStorageConfigurationRequest request) {
        OPushManager manager = this.server.getPushManager();
        manager.subscribeStorageConfiguration(this.connection.getDatabase(), (ONetworkProtocolBinary)this.connection.getProtocol());
        return new OSubscribeStorageConfigurationResponse();
    }

    @Override
    public OBinaryResponse executeSubscribeSchema(OSubscribeSchemaRequest request) {
        OPushManager manager = this.server.getPushManager();
        manager.subscribeSchema(this.connection.getDatabase(), (ONetworkProtocolBinary)this.connection.getProtocol());
        return new OSubscribeSchemaResponse();
    }

    @Override
    public OBinaryResponse executeSubscribeIndexManager(OSubscribeIndexManagerRequest request) {
        OPushManager manager = this.server.getPushManager();
        manager.subscribeIndexManager(this.connection.getDatabase(), (ONetworkProtocolBinary)this.connection.getProtocol());
        return new OSubscribeIndexManagerResponse();
    }

    @Override
    public OBinaryResponse executeSubscribeFunctions(OSubscribeFunctionsRequest request) {
        OPushManager manager = this.server.getPushManager();
        manager.subscribeFunctions(this.connection.getDatabase(), (ONetworkProtocolBinary)this.connection.getProtocol());
        return new OSubscribeFunctionsResponse();
    }

    @Override
    public OBinaryResponse executeSubscribeSequences(OSubscribeSequencesRequest request) {
        OPushManager manager = this.server.getPushManager();
        manager.subscribeSequences(this.connection.getDatabase(), (ONetworkProtocolBinary)this.connection.getProtocol());
        return new OSubscribeSequencesResponse();
    }

    @Override
    public OBinaryResponse executeUnsubscribeLiveQuery(OUnsubscribeLiveQueryRequest request) {
        ODatabaseDocumentInternal database = this.connection.getDatabase();
        OLiveQueryHookV2.unsubscribe(request.getMonitorId(), database);
        return new OUnsubscribLiveQueryResponse();
    }

    @Override
    public OBinaryResponse executeSubscribeLiveQuery(OSubscribeLiveQueryRequest request) {
        ONetworkProtocolBinary protocol = (ONetworkProtocolBinary)this.connection.getProtocol();
        OServerLiveQueryResultListener listener = new OServerLiveQueryResultListener(protocol, this.connection.getDatabase().getSharedContext());
        OLiveQueryMonitor monitor = this.connection.getDatabase().live(request.getQuery(), (OLiveQueryResultListener)listener, request.getParams());
        listener.setMonitorId(monitor.getMonitorId());
        return new OSubscribeLiveQueryResponse(monitor.getMonitorId());
    }

    @Override
    public OBinaryResponse executeDistributedConnect(ODistributedConnectRequest request) {
        HandshakeInfo handshakeInfo = new HandshakeInfo(38, "OrientDB Distributed", "", 0, 0);
        ((ONetworkProtocolBinary)this.connection.getProtocol()).setHandshakeInfo(handshakeInfo);
        OServerUserConfiguration serverUser = this.server.serverLogin(request.getUsername(), request.getPassword(), "server.connect");
        if (serverUser == null) {
            throw new OSecurityAccessException("Wrong user/password to [connect] to the remote OrientDB Server instance");
        }
        this.connection.getData().driverName = "OrientDB Distributed";
        this.connection.getData().clientId = "OrientDB Distributed";
        this.connection.getData().setSerializer(ORecordSerializerNetworkV37.INSTANCE);
        this.connection.setTokenBased(true);
        this.connection.getData().supportsLegacyPushMessages = false;
        this.connection.getData().collectStats = false;
        int chosenProtocolVersion = Math.min(request.getDistributedProtocolVersion(), 2);
        if (chosenProtocolVersion < 2) {
            OLogManager.instance().error(this, "Rejected distributed connection from '%s' too old not supported", null, this.connection.getRemoteAddress());
            throw new ODatabaseException("protocol version too old rejected connection");
        }
        this.connection.setServerUser(serverUser);
        this.connection.getData().serverUsername = serverUser.name;
        this.connection.getData().serverUser = true;
        byte[] token = this.server.getTokenHandler().getDistributedToken(this.connection.getData());
        return new ODistributedConnectResponse(this.connection.getId(), token, chosenProtocolVersion);
    }

    @Override
    public OBinaryResponse executeExperimental(OExperimentalRequest request) {
        return new OExperimentalResponse(request.getRequest().execute(this));
    }

    @Override
    public OBinaryResponse executeLockRecord(OLockRecordRequest request) {
        ORecord record = (ORecord)this.connection.getDatabase().lock(request.getIdentity(), request.getTimeout(), TimeUnit.MILLISECONDS);
        byte[] bytes = OConnectionBinaryExecutor.getRecordBytes(this.connection, record);
        return new OLockRecordResponse(ORecordInternal.getRecordType(record), record.getVersion(), bytes);
    }

    @Override
    public OBinaryResponse executeUnlockRecord(OUnlockRecordRequest request) {
        this.connection.getDatabase().getTransaction().unlockRecord(request.getIdentity());
        return new OUnlockRecordResponse();
    }
}

