/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.server;

import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.orient.client.binary.OChannelBinaryAsynchClient;
import com.orientechnologies.orient.client.remote.message.OShutdownRequest;
import com.orientechnologies.orient.core.config.OContextConfiguration;
import com.orientechnologies.orient.enterprise.channel.binary.ONetworkProtocolException;
import com.orientechnologies.orient.server.network.OServerNetworkListener;
import java.io.IOException;
import java.util.Arrays;

public class OServerShutdownMain {
    public String networkAddress;
    public int[] networkPort;
    public OChannelBinaryAsynchClient channel;
    private OContextConfiguration contextConfig = new OContextConfiguration();
    private String rootUser;
    private String rootPassword;

    public OServerShutdownMain(String iServerAddress, String iServerPorts, String iRootUser, String iRootPassword) {
        this.rootUser = iRootUser;
        this.rootPassword = iRootPassword;
        this.networkAddress = iServerAddress;
        this.networkPort = OServerNetworkListener.getPorts(iServerPorts);
    }

    public void connect(int iTimeout) throws IOException {
        for (int port : this.networkPort) {
            try {
                this.channel = new OChannelBinaryAsynchClient(this.networkAddress, port, null, this.contextConfig, 38);
                break;
            }
            catch (Exception e) {
                OLogManager.instance().error(this, "Error on connecting to %s:%d", e, this.networkAddress, port);
            }
        }
        if (this.channel == null) {
            throw new ONetworkProtocolException("Cannot connect to server host '" + this.networkAddress + "', ports: " + Arrays.toString(this.networkPort));
        }
        OShutdownRequest request = new OShutdownRequest(this.rootUser, this.rootPassword);
        this.channel.writeByte(request.getCommand());
        this.channel.writeInt(0);
        this.channel.writeBytes(null);
        request.write(this.channel, null);
        this.channel.flush();
        this.channel.beginResponse(0, true);
    }

    public static void main(String[] iArgs) {
        String serverHost = "localhost";
        String serverPorts = "2424-2430";
        String rootPassword = "NOT_PRESENT";
        String rootUser = "root";
        boolean printUsage = false;
        for (int i = 0; i < iArgs.length; ++i) {
            String arg = iArgs[i];
            if ("-P".equals(arg) || "--ports".equals(arg)) {
                serverPorts = iArgs[i + 1];
            }
            if ("-h".equals(arg) || "--host".equals(arg)) {
                serverHost = iArgs[i + 1];
            }
            if ("-p".equals(arg) || "--password".equals(arg)) {
                rootPassword = iArgs[i + 1];
            }
            if ("-u".equals(arg) || "--user".equals(arg)) {
                rootUser = iArgs[i + 1];
            }
            if (!"-h".equals(arg) && !"--help".equals(arg)) continue;
            printUsage = true;
        }
        if ("NOT_PRESENT".equals(rootPassword) || printUsage) {
            System.out.println("allowed parameters");
            System.out.println("-h | --host hostname : name or ip of the host where OrientDB is running. Deafult to localhost ");
            System.out.println("-P | --ports  ports : ports in the form of single value or range. Default to 2424-2430");
            System.out.println("-p | --password password : the super user password");
            System.out.println("-u | --user username: the super user name. Default to root");
            System.out.println("example: shutdown.sh -h orientserver.mydomain -P 2424-2430 -u root -p securePassword");
        }
        System.out.println("Sending shutdown command to remote OrientDB Server instance...");
        try {
            new OServerShutdownMain(serverHost, serverPorts, rootUser, rootPassword).connect(5000);
            System.out.println("Shutdown executed correctly");
        }
        catch (Exception e) {
            System.out.println("Error: " + e.getLocalizedMessage());
        }
        System.out.println();
    }
}

