/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.server.config;

import com.orientechnologies.orient.server.config.OServerConfigurationLoaderXml;
import com.orientechnologies.orient.server.config.OServerEntryConfiguration;
import com.orientechnologies.orient.server.config.OServerHandlerConfiguration;
import com.orientechnologies.orient.server.config.OServerHookConfiguration;
import com.orientechnologies.orient.server.config.OServerNetworkConfiguration;
import com.orientechnologies.orient.server.config.OServerSecurityConfiguration;
import com.orientechnologies.orient.server.config.OServerStorageConfiguration;
import com.orientechnologies.orient.server.config.OServerUserConfiguration;
import com.orientechnologies.orient.server.config.distributed.OServerDistributedConfiguration;
import java.util.List;
import javax.xml.bind.annotation.XmlElementRef;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;

@XmlRootElement(name="orient-server")
public class OServerConfiguration {
    public static final String FILE_NAME = "server-config.xml";
    public static final OServerStorageConfiguration[] EMPTY_CONFIG_ARRAY = new OServerStorageConfiguration[0];
    @XmlTransient
    public String location;
    @XmlElementWrapper
    @XmlElementRef(type=OServerHandlerConfiguration.class)
    public List<OServerHandlerConfiguration> handlers;
    @XmlElementWrapper
    @XmlElementRef(type=OServerHookConfiguration.class)
    public List<OServerHookConfiguration> hooks;
    @XmlElementRef(type=OServerNetworkConfiguration.class)
    public OServerNetworkConfiguration network;
    @XmlElementWrapper
    @XmlElementRef(type=OServerStorageConfiguration.class)
    public OServerStorageConfiguration[] storages;
    @XmlElementWrapper(required=false)
    @XmlElementRef(type=OServerUserConfiguration.class)
    public OServerUserConfiguration[] users;
    @XmlElementRef(type=OServerSecurityConfiguration.class)
    public OServerSecurityConfiguration security;
    @XmlElementWrapper
    @XmlElementRef(type=OServerEntryConfiguration.class)
    public OServerEntryConfiguration[] properties;
    @XmlElementRef(type=OServerDistributedConfiguration.class)
    public OServerDistributedConfiguration distributed;
    public boolean isAfterFirstTime;
    public static final String DEFAULT_CONFIG_FILE = "config/orientdb-server-config.xml";
    public static final String PROPERTY_CONFIG_FILE = "orientdb.config.file";
    public static final String DEFAULT_ROOT_USER = "root";
    public static final String GUEST_USER = "guest";
    public static final String GUEST_PASS = "guest";

    public OServerConfiguration() {
    }

    public OServerConfiguration(OServerConfigurationLoaderXml iFactory) {
        this.location = FILE_NAME;
        this.network = new OServerNetworkConfiguration(iFactory);
        this.storages = EMPTY_CONFIG_ARRAY;
        this.security = new OServerSecurityConfiguration(iFactory);
    }

    public String getStoragePath(String iURL) {
        if (this.storages != null) {
            for (OServerStorageConfiguration stg : this.storages) {
                if (!stg.name.equals(iURL)) continue;
                return stg.path;
            }
        }
        return null;
    }

    public String getProperty(String iName) {
        return this.getProperty(iName, null);
    }

    public String getProperty(String iName, String iDefaultValue) {
        if (this.properties == null) {
            return null;
        }
        for (OServerEntryConfiguration p : this.properties) {
            if (!p.name.equals(iName)) continue;
            return p.value;
        }
        return null;
    }
}

