/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.server.handler;

import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.orient.core.command.OScriptExecutor;
import com.orientechnologies.orient.core.command.OScriptInterceptor;
import com.orientechnologies.orient.core.command.script.OCommandExecutorScript;
import com.orientechnologies.orient.core.command.script.OCommandScript;
import com.orientechnologies.orient.core.db.OrientDBInternal;
import com.orientechnologies.orient.core.exception.OSecurityException;
import com.orientechnologies.orient.server.OServer;
import com.orientechnologies.orient.server.config.OServerParameterConfiguration;
import com.orientechnologies.orient.server.plugin.OServerPluginAbstract;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;

public class OServerSideScriptInterpreter
extends OServerPluginAbstract {
    protected boolean enabled = false;
    protected Set<String> allowedLanguages = new HashSet<String>();
    protected OScriptInterceptor interceptor;
    private OServer server;

    @Override
    public void config(OServer iServer, OServerParameterConfiguration[] iParams) {
        this.server = iServer;
        for (OServerParameterConfiguration param : iParams) {
            if (param.name.equalsIgnoreCase("enabled")) {
                if (!Boolean.parseBoolean(param.value)) continue;
                this.enabled = true;
                continue;
            }
            if (param.name.equalsIgnoreCase("allowedLanguages")) {
                this.allowedLanguages = new HashSet<String>(Arrays.asList(param.value.toLowerCase(Locale.ENGLISH).split(",")));
                continue;
            }
            if (!param.name.equalsIgnoreCase("allowedPackages")) continue;
            OrientDBInternal.extract(iServer.getContext()).getScriptManager().addAllowedPackages(new HashSet<String>(Arrays.asList(param.value.split(","))));
        }
    }

    @Override
    public String getName() {
        return "script-interpreter";
    }

    @Override
    public void startup() {
        if (!this.enabled) {
            return;
        }
        OrientDBInternal.extract(this.server.getContext()).getScriptManager().getCommandManager().registerExecutor(OCommandScript.class, OCommandExecutorScript.class, iArgument -> {
            String language = ((OCommandScript)iArgument).getLanguage().toLowerCase(Locale.ENGLISH);
            if (!this.allowedLanguages.contains(language)) {
                throw new OSecurityException("Language '" + language + "' is not allowed to be executed");
            }
            return null;
        });
        this.interceptor = (db, language, script, params) -> {
            if (!this.allowedLanguages.contains(language)) {
                throw new OSecurityException("Language '" + language + "' is not allowed to be executed");
            }
        };
        OrientDBInternal.extract(this.server.getContext()).getScriptManager().getCommandManager().getScriptExecutors().entrySet().forEach(e -> ((OScriptExecutor)e.getValue()).registerInterceptor(this.interceptor));
        OLogManager.instance().warn((Object)this, "Authenticated clients can execute any kind of code into the server by using the following allowed languages: " + this.allowedLanguages, new Object[0]);
    }

    @Override
    public void shutdown() {
        if (!this.enabled) {
            return;
        }
        if (this.interceptor != null) {
            OrientDBInternal.extract(this.server.getContext()).getScriptManager().getCommandManager().getScriptExecutors().entrySet().forEach(e -> ((OScriptExecutor)e.getValue()).unregisterInterceptor(this.interceptor));
        }
        OrientDBInternal.extract(this.server.getContext()).getScriptManager().getCommandManager().unregisterExecutor(OCommandScript.class);
    }
}

