/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.server.network.protocol.http.command.all;

import com.orientechnologies.common.exception.OException;
import com.orientechnologies.orient.core.command.OBasicCommandContext;
import com.orientechnologies.orient.core.command.OCommandContext;
import com.orientechnologies.orient.core.command.script.OCommandScriptException;
import com.orientechnologies.orient.core.db.ODatabaseDocumentInternal;
import com.orientechnologies.orient.core.metadata.function.OFunction;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.server.network.protocol.http.OHttpRequest;
import com.orientechnologies.orient.server.network.protocol.http.OHttpRequestWrapper;
import com.orientechnologies.orient.server.network.protocol.http.OHttpResponse;
import com.orientechnologies.orient.server.network.protocol.http.OHttpResponseWrapper;
import com.orientechnologies.orient.server.network.protocol.http.command.OServerCommandAuthenticatedDbAbstract;
import java.io.IOException;

public abstract class OServerCommandAbstractLogic
extends OServerCommandAuthenticatedDbAbstract {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean execute(OHttpRequest iRequest, OHttpResponse iResponse) throws Exception {
        String[] parts = this.init(iRequest, iResponse);
        try (ODatabaseDocumentInternal db = null;){
            Object functionResult;
            db = this.getProfiledDatabaseInstance(iRequest);
            OFunction f = db.getMetadata().getFunctionLibrary().getFunction(parts[2]);
            if (f == null) {
                throw new IllegalArgumentException("Function '" + parts[2] + "' is not configured");
            }
            if (iRequest.getHttpMethod().equalsIgnoreCase("GET") && !f.isIdempotent()) {
                iResponse.send(400, "Bad request", "text/plain", "GET method is not allowed to execute function '" + parts[2] + "' because has been declared as non idempotent. Use POST instead.", null);
                boolean bl = false;
                return bl;
            }
            Object[] args = new String[parts.length - 3];
            for (int i = 3; i < parts.length; ++i) {
                args[i - 3] = parts[i];
            }
            OBasicCommandContext context = new OBasicCommandContext();
            context.setVariable("session", this.server.getHttpSessionManager().getSession(iRequest.getSessionId()));
            context.setVariable("request", new OHttpRequestWrapper(iRequest, (String[])args));
            context.setVariable("response", new OHttpResponseWrapper(iResponse));
            if (args.length == 0 && iRequest.getContent() != null && !iRequest.getContent().isEmpty()) {
                try {
                    ODocument params = new ODocument().fromJSON(iRequest.getContent());
                    functionResult = f.executeInContext((OCommandContext)context, params.toMap());
                }
                catch (Exception e) {
                    throw OException.wrapException(new OCommandScriptException("Error on parsing parameters from request body"), e);
                }
            } else {
                functionResult = f.executeInContext((OCommandContext)context, args);
            }
            this.handleResult(iRequest, iResponse, functionResult);
        }
        return false;
    }

    protected abstract String[] init(OHttpRequest var1, OHttpResponse var2);

    protected abstract void handleResult(OHttpRequest var1, OHttpResponse var2, Object var3) throws InterruptedException, IOException;
}

