/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.server.network.protocol.http.command.get;

import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.orient.core.OConstants;
import com.orientechnologies.orient.core.Orient;
import com.orientechnologies.orient.core.config.OStorageEntryConfiguration;
import com.orientechnologies.orient.core.db.ODatabase;
import com.orientechnologies.orient.core.db.ODatabaseDocumentInternal;
import com.orientechnologies.orient.core.db.document.ODatabaseDocument;
import com.orientechnologies.orient.core.exception.OSecurityAccessException;
import com.orientechnologies.orient.core.index.OIndex;
import com.orientechnologies.orient.core.index.OIndexDefinition;
import com.orientechnologies.orient.core.index.OIndexManagerAbstract;
import com.orientechnologies.orient.core.metadata.schema.OClass;
import com.orientechnologies.orient.core.metadata.schema.OClassImpl;
import com.orientechnologies.orient.core.metadata.schema.OProperty;
import com.orientechnologies.orient.core.metadata.schema.OPropertyImpl;
import com.orientechnologies.orient.core.metadata.security.ORole;
import com.orientechnologies.orient.core.metadata.security.OUser;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.serialization.serializer.OJSONWriter;
import com.orientechnologies.orient.core.storage.OStorage;
import com.orientechnologies.orient.server.OServer;
import com.orientechnologies.orient.server.network.protocol.http.OHttpRequest;
import com.orientechnologies.orient.server.network.protocol.http.OHttpResponse;
import com.orientechnologies.orient.server.network.protocol.http.command.get.OServerCommandGetConnect;
import java.io.IOException;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.Set;

public class OServerCommandGetDatabase
extends OServerCommandGetConnect {
    private static final String[] NAMES = new String[]{"GET|database/*"};

    public static void exportClass(ODatabaseDocument db, OJSONWriter json, OClass cls) throws IOException {
        Set<OIndex> indexes;
        Map<String, String> custom;
        json.beginObject();
        json.writeAttribute("name", cls.getName());
        json.writeAttribute("superClass", cls.getSuperClass() != null ? cls.getSuperClass().getName() : "");
        json.beginCollection("superClasses");
        int i = 0;
        for (OClass oClass : cls.getSuperClasses()) {
            json.write((i > 0 ? "," : "") + "\"" + oClass.getName() + "\"");
            ++i;
        }
        json.endCollection();
        json.writeAttribute("alias", cls.getShortName());
        json.writeAttribute("abstract", cls.isAbstract());
        json.writeAttribute("strictmode", cls.isStrictMode());
        json.writeAttribute("clusters", cls.getClusterIds());
        json.writeAttribute("defaultCluster", cls.getDefaultClusterId());
        json.writeAttribute("clusterSelection", cls.getClusterSelection().getName());
        if (cls instanceof OClassImpl && (custom = ((OClassImpl)cls).getCustomInternal()) != null && !custom.isEmpty()) {
            json.writeAttribute("custom", custom);
        }
        try {
            json.writeAttribute("records", db.countClass(cls.getName()));
        }
        catch (OSecurityAccessException e) {
            json.writeAttribute("records", "? (Unauthorized)");
        }
        catch (Exception e) {
            json.writeAttribute("records", "? (Error)");
        }
        if (cls.properties() != null && cls.properties().size() > 0) {
            json.beginCollection("properties");
            for (OProperty prop : cls.properties()) {
                Map<String, String> custom2;
                json.beginObject();
                json.writeAttribute("name", prop.getName());
                if (prop.getLinkedClass() != null) {
                    json.writeAttribute("linkedClass", prop.getLinkedClass().getName());
                }
                if (prop.getLinkedType() != null) {
                    json.writeAttribute("linkedType", prop.getLinkedType().toString());
                }
                json.writeAttribute("type", prop.getType().toString());
                json.writeAttribute("mandatory", prop.isMandatory());
                json.writeAttribute("readonly", prop.isReadonly());
                json.writeAttribute("notNull", prop.isNotNull());
                json.writeAttribute("min", prop.getMin());
                json.writeAttribute("max", prop.getMax());
                json.writeAttribute("regexp", prop.getRegexp());
                json.writeAttribute("collate", prop.getCollate() != null ? prop.getCollate().getName() : "default");
                json.writeAttribute("defaultValue", prop.getDefaultValue());
                if (prop instanceof OPropertyImpl && (custom2 = ((OPropertyImpl)prop).getCustomInternal()) != null && !custom2.isEmpty()) {
                    json.writeAttribute("custom", custom2);
                }
                json.endObject();
            }
            json.endCollection();
        }
        if (!(indexes = cls.getIndexes()).isEmpty()) {
            json.beginCollection("indexes");
            for (OIndex index : indexes) {
                json.beginObject();
                json.writeAttribute("name", index.getName());
                json.writeAttribute("type", index.getType());
                OIndexDefinition indexDefinition = index.getDefinition();
                if (indexDefinition != null && !indexDefinition.getFields().isEmpty()) {
                    json.writeAttribute("fields", indexDefinition.getFields());
                }
                json.endObject();
            }
            json.endCollection();
        }
        json.endObject();
    }

    @Override
    public void configure(OServer server) {
        super.configure(server);
    }

    @Override
    public boolean execute(OHttpRequest iRequest, OHttpResponse iResponse) throws Exception {
        String[] urlParts = this.checkSyntax(iRequest.getUrl(), 2, "Syntax error: database/<database>");
        iRequest.getData().commandInfo = "Database info";
        iRequest.getData().commandDetail = urlParts[1];
        this.exec(iRequest, iResponse, urlParts);
        return false;
    }

    @Override
    public String[] getNames() {
        return NAMES;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void exec(OHttpRequest iRequest, OHttpResponse iResponse, String[] urlParts) throws InterruptedException, IOException {
        try (ODatabase db = null;){
            db = urlParts.length > 2 ? this.server.openDatabase(urlParts[1], urlParts[2], urlParts[3]) : this.getProfiledDatabaseInstance(iRequest);
            StringWriter buffer = new StringWriter();
            OJSONWriter json = new OJSONWriter(buffer);
            json.beginObject();
            json.beginObject("server");
            json.writeAttribute("version", OConstants.getRawVersion());
            if (OConstants.getBuildNumber() != null) {
                json.writeAttribute("build", OConstants.getBuildNumber());
            }
            json.writeAttribute("osName", System.getProperty("os.name"));
            json.writeAttribute("osVersion", System.getProperty("os.version"));
            json.writeAttribute("osArch", System.getProperty("os.arch"));
            json.writeAttribute("javaVendor", System.getProperty("java.vm.vendor"));
            json.writeAttribute("javaVersion", System.getProperty("java.vm.version"));
            json.beginCollection("conflictStrategies");
            Set strategies = Orient.instance().getRecordConflictStrategy().getRegisteredImplementationNames();
            int i = 0;
            for (String strategy : strategies) {
                json.write((i > 0 ? "," : "") + "\"" + strategy + "\"");
                ++i;
            }
            json.endCollection();
            json.beginCollection("clusterSelectionStrategies");
            Set clusterSelectionStrategies = db.getMetadata().getSchema().getClusterSelectionFactory().getRegisteredNames();
            int j = 0;
            for (String strategy : clusterSelectionStrategies) {
                json.write((j > 0 ? "," : "") + "\"" + strategy + "\"");
                ++j;
            }
            json.endCollection();
            json.endObject();
            if (db.getMetadata().getImmutableSchemaSnapshot().getClasses() != null) {
                json.beginCollection("classes");
                ArrayList<String> classNames = new ArrayList<String>();
                for (OClass oClass : db.getMetadata().getSchema().getClasses()) {
                    classNames.add(oClass.getName());
                }
                Collections.sort(classNames);
                for (String string : classNames) {
                    OClass cls = db.getMetadata().getSchema().getClass(string);
                    try {
                        OServerCommandGetDatabase.exportClass((ODatabaseDocument)db, json, cls);
                    }
                    catch (Exception e) {
                        OLogManager.instance().error(this, "Error on exporting class '" + cls + "'", e, new Object[0]);
                    }
                }
                json.endCollection();
            }
            if (db.getClusterNames() != null) {
                json.beginCollection("clusters");
                OStorage storage = db.getStorage();
                for (String string : db.getClusterNames()) {
                    int clusterId = storage.getClusterIdByName(string);
                    if (clusterId < 0) continue;
                    try {
                        String conflictStrategy = storage.getClusterRecordConflictStrategy(clusterId);
                        json.beginObject();
                        json.writeAttribute("id", clusterId);
                        json.writeAttribute("name", string);
                        json.writeAttribute("records", storage.count(clusterId));
                        json.writeAttribute("conflictStrategy", conflictStrategy);
                        json.writeAttribute("size", "-");
                        json.writeAttribute("filled", "-");
                        json.writeAttribute("maxSize", "-");
                        json.writeAttribute("files", "-");
                    }
                    catch (Exception e) {
                        json.writeAttribute("records", "? (Unauthorized)");
                    }
                    json.endObject();
                }
                json.endCollection();
            }
            if (db.getUser() != null) {
                json.writeAttribute("currentUser", db.getUser().getName());
            }
            OIndexManagerAbstract idxManager = db.getMetadata().getIndexManagerInternal();
            json.beginCollection("indexes");
            for (OIndex oIndex : idxManager.getIndexes((ODatabaseDocumentInternal)db)) {
                json.beginObject();
                try {
                    json.writeAttribute("name", oIndex.getName());
                    json.writeAttribute("configuration", oIndex.getConfiguration());
                }
                catch (Exception e) {
                    OLogManager.instance().error(this, "Cannot serialize index configuration", e, new Object[0]);
                }
                json.endObject();
            }
            json.endCollection();
            json.beginObject("config");
            json.beginCollection("values");
            json.writeObjects(null, {"name", "dateFormat", "value", db.getStorage().getConfiguration().getDateFormat()}, {"name", "dateTimeFormat", "value", db.getStorage().getConfiguration().getDateTimeFormat()}, {"name", "localeCountry", "value", db.getStorage().getConfiguration().getLocaleCountry()}, {"name", "localeLanguage", "value", db.getStorage().getConfiguration().getLocaleLanguage()}, {"name", "charSet", "value", db.getStorage().getConfiguration().getCharset()}, {"name", "timezone", "value", db.getStorage().getConfiguration().getTimeZone().getID()}, {"name", "definitionVersion", "value", db.getStorage().getConfiguration().getVersion()}, {"name", "clusterSelection", "value", db.getStorage().getConfiguration().getClusterSelection()}, {"name", "minimumClusters", "value", db.getStorage().getConfiguration().getMinimumClusters()}, {"name", "conflictStrategy", "value", db.getStorage().getConfiguration().getConflictStrategy()});
            json.endCollection();
            json.beginCollection("properties");
            if (db.getStorage().getConfiguration().getProperties() != null) {
                for (OStorageEntryConfiguration oStorageEntryConfiguration : db.getStorage().getConfiguration().getProperties()) {
                    if (oStorageEntryConfiguration == null) continue;
                    json.beginObject();
                    json.writeAttribute("name", oStorageEntryConfiguration.name);
                    json.writeAttribute("value", oStorageEntryConfiguration.value);
                    json.endObject();
                }
            }
            json.endCollection();
            json.endObject();
            json.endObject();
            json.flush();
            iResponse.send(200, "OK", "application/json", buffer.toString(), null);
        }
    }

    private void exportSecurityInfo(ODatabaseDocument db, OJSONWriter json) throws IOException {
        json.beginCollection("users");
        for (ODocument doc : db.getMetadata().getSecurity().getAllUsers()) {
            OUser user = new OUser(doc);
            json.beginObject();
            json.writeAttribute("name", user.getName());
            json.writeAttribute("roles", user.getRoles() != null ? Arrays.toString(user.getRoles().toArray()) : "null");
            json.endObject();
        }
        json.endCollection();
        json.beginCollection("roles");
        for (ODocument doc : db.getMetadata().getSecurity().getAllRoles()) {
            ORole role = new ORole(doc);
            json.beginObject();
            json.writeAttribute("name", role.getName());
            json.writeAttribute("mode", role.getMode().toString());
            json.beginCollection("rules");
            if (role.getRules() != null) {
                for (Map.Entry<String, Byte> rule : role.getRules().entrySet()) {
                    json.beginObject();
                    json.writeAttribute("name", rule.getKey());
                    json.writeAttribute("create", role.allow(rule.getKey(), ORole.PERMISSION_CREATE));
                    json.writeAttribute("read", role.allow(rule.getKey(), ORole.PERMISSION_READ));
                    json.writeAttribute("update", role.allow(rule.getKey(), ORole.PERMISSION_UPDATE));
                    json.writeAttribute("delete", role.allow(rule.getKey(), ORole.PERMISSION_DELETE));
                    json.endObject();
                }
            }
            json.endCollection();
            json.endObject();
        }
        json.endCollection();
    }
}

