/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.server.network.protocol.http.command.get;

import com.orientechnologies.orient.core.command.script.OScriptManager;
import com.orientechnologies.orient.core.db.ODatabaseDocumentInternal;
import com.orientechnologies.orient.core.db.OrientDBInternal;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.server.network.protocol.http.OHttpRequest;
import com.orientechnologies.orient.server.network.protocol.http.OHttpResponse;
import com.orientechnologies.orient.server.network.protocol.http.command.OServerCommandAuthenticatedDbAbstract;
import java.util.HashSet;

public class OServerCommandGetSupportedLanguages
extends OServerCommandAuthenticatedDbAbstract {
    private static final String[] NAMES = new String[]{"GET|supportedLanguages/*"};

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean execute(OHttpRequest iRequest, OHttpResponse iResponse) throws Exception {
        String[] urlParts = this.checkSyntax(iRequest.getUrl(), 2, "Syntax error: supportedLanguages/<database>");
        iRequest.getData().commandInfo = "Returns the supported languages";
        try (ODatabaseDocumentInternal db = null;){
            db = this.getProfiledDatabaseInstance(iRequest);
            ODocument result = new ODocument();
            HashSet<String> languages = new HashSet<String>();
            OScriptManager scriptManager = OrientDBInternal.extract(this.server.getContext()).getScriptManager();
            for (String language : scriptManager.getSupportedLanguages()) {
                if (scriptManager.getFormatters() == null || scriptManager.getFormatters().get(language) == null) continue;
                languages.add(language);
            }
            result.field("languages", languages);
            iResponse.writeRecord(result);
        }
        return false;
    }

    @Override
    public String[] getNames() {
        return NAMES;
    }
}

