/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.server.network.protocol.http.command.post;

import com.orientechnologies.common.collection.OMultiValue;
import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.orient.core.db.ODatabaseDocumentInternal;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.sql.executor.OResultSet;
import com.orientechnologies.orient.server.network.protocol.http.OHttpRequest;
import com.orientechnologies.orient.server.network.protocol.http.OHttpResponse;
import com.orientechnologies.orient.server.network.protocol.http.command.OServerCommandDocumentAbstract;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class OServerCommandPostBatch
extends OServerCommandDocumentAbstract {
    private static final String[] NAMES = new String[]{"POST|batch/*"};

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean execute(OHttpRequest iRequest, OHttpResponse iResponse) throws Exception {
        this.checkSyntax(iRequest.getUrl(), 2, "Syntax error: batch/<database>");
        iRequest.getData().commandInfo = "Execute multiple requests in one shot";
        ODatabaseDocumentInternal db = null;
        ODocument batch = null;
        List lastResult = null;
        try {
            Collection operations;
            Boolean tx;
            db = this.getProfiledDatabaseInstance(iRequest);
            if (db.getTransaction().isActive()) {
                OLogManager.instance().warn((Object)this, "Found database instance from the pool with a pending transaction. Forcing rollback before using it", new Object[0]);
                db.rollback(true);
            }
            if ((tx = (Boolean)(batch = new ODocument().fromJSON(iRequest.getContent())).field("transaction")) == null) {
                tx = false;
            }
            try {
                operations = (Collection)batch.field("operations");
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Expected 'operations' field as a collection of objects", e);
            }
            if (operations == null || operations.isEmpty()) {
                throw new IllegalArgumentException("Input JSON has no operations to execute");
            }
            boolean txBegun = false;
            if (tx.booleanValue() && !db.getTransaction().isActive()) {
                db.begin();
                txBegun = true;
            }
            for (Map operation : operations) {
                OResultSet result;
                String language;
                ODocument doc;
                String type = (String)operation.get("type");
                if (type.equals("c")) {
                    doc = this.getRecord(operation);
                    doc.save();
                    lastResult = doc;
                    continue;
                }
                if (type.equals("u")) {
                    doc = this.getRecord(operation);
                    doc.save();
                    lastResult = doc;
                    continue;
                }
                if (type.equals("d")) {
                    doc = this.getRecord(operation);
                    db.delete(doc.getIdentity());
                    lastResult = doc.getIdentity();
                    continue;
                }
                if (type.equals("cmd")) {
                    language = (String)operation.get("language");
                    if (language == null) {
                        throw new IllegalArgumentException("language parameter is null");
                    }
                    Object command = operation.get("command");
                    if (command == null) {
                        throw new IllegalArgumentException("command parameter is null");
                    }
                    Object params = operation.get("parameters");
                    if (params instanceof Collection) {
                        params = ((Collection)params).toArray();
                    }
                    String commandAsString = null;
                    if (command != null) {
                        if (OMultiValue.isMultiValue(command)) {
                            for (Object object : OMultiValue.getMultiValueIterable(command)) {
                                if (commandAsString == null) {
                                    commandAsString = object.toString();
                                    continue;
                                }
                                commandAsString = commandAsString + ";" + object.toString();
                            }
                        } else {
                            commandAsString = command.toString();
                        }
                    }
                    result = params == null ? db.execute(language, commandAsString, new Object[0]) : db.execute(language, commandAsString, (Object[])params);
                    lastResult = result.stream().map(x -> x.toElement()).collect(Collectors.toList());
                    result.close();
                    continue;
                }
                if (!type.equals("script")) continue;
                language = (String)operation.get("language");
                if (language == null) {
                    throw new IllegalArgumentException("language parameter is null");
                }
                Object script = operation.get("script");
                if (script == null) {
                    throw new IllegalArgumentException("script parameter is null");
                }
                StringBuilder text = new StringBuilder(1024);
                if (OMultiValue.isMultiValue(script)) {
                    int i = 0;
                    for (Object e : OMultiValue.getMultiValueIterable(script)) {
                        if (e == null) continue;
                        if (i++ > 0) {
                            if (!text.toString().trim().endsWith(";")) {
                                text.append(";");
                            }
                            text.append("\n");
                        }
                        text.append(e.toString());
                    }
                } else {
                    text.append(script);
                }
                Object params = operation.get("parameters");
                if (params instanceof Collection) {
                    params = ((Collection)params).toArray();
                }
                result = params == null ? db.execute(language, text.toString(), new Object[0]) : db.execute(language, text.toString(), (Object[])params);
                lastResult = result.stream().map(x -> x.toElement()).collect(Collectors.toList());
                result.close();
            }
            if (txBegun) {
                db.commit();
            }
            try {
                iResponse.writeResult(lastResult);
            }
            catch (RuntimeException e) {
                OLogManager.instance().error(this, "Error (%s) on serializing result of batch command:\n%s", e, batch.toJSON("prettyPrint"));
                throw e;
            }
        }
        finally {
            if (db != null) {
                db.close();
            }
        }
        return false;
    }

    public ODocument getRecord(Map<Object, Object> operation) {
        Object record = operation.get("record");
        ODocument doc = record instanceof Map ? new ODocument((Map)record) : (ODocument)record;
        return doc;
    }

    @Override
    public String[] getNames() {
        return NAMES;
    }
}

