/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.server.security;

import com.orientechnologies.orient.core.db.ODatabaseSession;
import com.orientechnologies.orient.core.metadata.security.ORole;
import com.orientechnologies.orient.core.metadata.security.ORule;
import com.orientechnologies.orient.core.metadata.security.OSecurityExternal;
import com.orientechnologies.orient.core.metadata.security.OSecurityPolicy;
import com.orientechnologies.orient.core.metadata.security.OSecurityRole;
import com.orientechnologies.orient.core.metadata.security.OSystemUser;
import com.orientechnologies.orient.core.metadata.security.OUser;
import com.orientechnologies.orient.core.record.OElement;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.server.OServer;
import com.orientechnologies.orient.server.config.OServerUserConfiguration;
import java.util.HashMap;

public class OSecurityServerExternal
extends OSecurityExternal {
    private OServer server;

    public OSecurityServerExternal(OServer server) {
        this.server = server;
    }

    @Override
    public OUser getUser(ODatabaseSession session, String username) {
        OServerUserConfiguration serverUser;
        OUser user = super.getUser(session, username);
        if (user == null && username != null && (serverUser = this.server.getUser(username)) != null) {
            user = new OSystemUser(username, "null", "Server");
            user.addRole(this.createRole(serverUser));
        }
        return user;
    }

    public ORole createRole(OServerUserConfiguration serverUser) {
        ORole role = new ORole(serverUser.name, null, OSecurityRole.ALLOW_MODES.ALLOW_ALL_BUT);
        if (serverUser.resources.equalsIgnoreCase("*")) {
            this.createRoot(role);
        } else {
            this.mapPermission(role, serverUser);
        }
        return role;
    }

    private void mapPermission(ORole role, OServerUserConfiguration user) {
        String[] strings;
        for (String string : strings = user.resources.split(",")) {
            ORule.ResourceGeneric generic = ORule.mapLegacyResourceToGenericResource(string);
            if (generic == null) continue;
            role.addRule(generic, null, ORole.PERMISSION_ALL);
        }
    }

    private void createRoot(ORole role) {
        role.addRule(ORule.ResourceGeneric.BYPASS_RESTRICTED, null, ORole.PERMISSION_ALL);
        role.addRule(ORule.ResourceGeneric.ALL, null, ORole.PERMISSION_ALL);
        role.addRule(ORule.ResourceGeneric.CLASS, null, ORole.PERMISSION_ALL);
        role.addRule(ORule.ResourceGeneric.CLUSTER, null, ORole.PERMISSION_ALL);
        role.addRule(ORule.ResourceGeneric.SYSTEM_CLUSTERS, null, ORole.PERMISSION_ALL);
        role.addRule(ORule.ResourceGeneric.DATABASE, null, ORole.PERMISSION_ALL);
        role.addRule(ORule.ResourceGeneric.SCHEMA, null, ORole.PERMISSION_ALL);
        role.addRule(ORule.ResourceGeneric.COMMAND, null, ORole.PERMISSION_ALL);
        role.addRule(ORule.ResourceGeneric.COMMAND_GREMLIN, null, ORole.PERMISSION_ALL);
        role.addRule(ORule.ResourceGeneric.FUNCTION, null, ORole.PERMISSION_ALL);
        this.createSecurityPolicyWithBitmask(role, "*", ORole.PERMISSION_ALL);
    }

    public void createSecurityPolicyWithBitmask(OSecurityRole role, String resource, int legacyPolicy) {
        String policyName = "default_" + legacyPolicy;
        OSecurityPolicy policy = new OSecurityPolicy(new ODocument().field("name", policyName));
        policy.setCreateRule((legacyPolicy & ORole.PERMISSION_CREATE) > 0 ? "true" : "false");
        policy.setReadRule((legacyPolicy & ORole.PERMISSION_READ) > 0 ? "true" : "false");
        policy.setBeforeUpdateRule((legacyPolicy & ORole.PERMISSION_UPDATE) > 0 ? "true" : "false");
        policy.setAfterUpdateRule((legacyPolicy & ORole.PERMISSION_UPDATE) > 0 ? "true" : "false");
        policy.setDeleteRule((legacyPolicy & ORole.PERMISSION_DELETE) > 0 ? "true" : "false");
        policy.setExecuteRule((legacyPolicy & ORole.PERMISSION_EXECUTE) > 0 ? "true" : "false");
        this.addSecurityPolicy(role, resource, policy);
    }

    public void addSecurityPolicy(OSecurityRole role, String resource, OSecurityPolicy policy) {
        ODocument roleDoc = role.getDocument();
        if (roleDoc == null) {
            return;
        }
        HashMap<String, OElement> policies = (HashMap<String, OElement>)roleDoc.getProperty("policies");
        if (policies == null) {
            policies = new HashMap<String, OElement>();
            roleDoc.setProperty("policies", policies);
        }
        policies.put(resource, policy.getElement());
    }
}

