/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.server.token;

import com.orientechnologies.orient.core.id.ORID;
import com.orientechnologies.orient.core.id.ORecordId;
import com.orientechnologies.orient.core.metadata.security.jwt.OJwtHeader;
import com.orientechnologies.orient.server.binary.impl.OBinaryToken;
import com.orientechnologies.orient.server.token.OrientJwtHeader;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.Map;

public class OBinaryTokenSerializer {
    private final String[] types;
    private final String[] keys;
    private final String[] algorithms;
    private final String[] dbTypes;
    private final Map<String, Byte> associetedDdTypes;
    private final Map<String, Byte> associetedKeys;
    private final Map<String, Byte> associetedAlgorithms;
    private final Map<String, Byte> associetedTypes;

    public OBinaryTokenSerializer(String[] dbTypes, String[] keys2, String[] algorithms, String[] entityTypes) {
        this.dbTypes = dbTypes;
        this.keys = keys2;
        this.algorithms = algorithms;
        this.types = entityTypes;
        this.associetedDdTypes = this.createMap(dbTypes);
        this.associetedKeys = this.createMap(keys2);
        this.associetedAlgorithms = this.createMap(algorithms);
        this.associetedTypes = this.createMap(entityTypes);
    }

    public Map<String, Byte> createMap(String[] entries) {
        HashMap<String, Byte> newMap = new HashMap<String, Byte>();
        for (int i = 0; i < entries.length; ++i) {
            newMap.put(entries[i], (byte)i);
        }
        return newMap;
    }

    public OBinaryToken deserialize(InputStream stream) throws IOException {
        DataInputStream input = new DataInputStream(stream);
        OrientJwtHeader header = new OrientJwtHeader();
        header.setType(this.types[input.readByte()]);
        header.setKeyId(this.keys[input.readByte()]);
        header.setAlgorithm(this.algorithms[input.readByte()]);
        OBinaryToken token = new OBinaryToken();
        token.setHeader(header);
        token.setDatabase(this.readString(input));
        byte pos = input.readByte();
        if (pos >= 0) {
            token.setDatabaseType(this.dbTypes[pos]);
        }
        short cluster = input.readShort();
        long position = input.readLong();
        if (cluster != -1 && position != -1L) {
            token.setUserRid(new ORecordId(cluster, position));
        }
        token.setExpiry(input.readLong());
        token.setServerUser(input.readBoolean());
        if (token.isServerUser()) {
            token.setUserName(this.readString(input));
        }
        token.setProtocolVersion(input.readShort());
        token.setSerializer(this.readString(input));
        token.setDriverName(this.readString(input));
        token.setDriverVersion(this.readString(input));
        return token;
    }

    private String readString(DataInputStream input) throws IOException {
        short s = input.readShort();
        if (s >= 0) {
            byte[] str = new byte[s];
            input.readFully(str);
            return new String(str, "UTF-8");
        }
        return null;
    }

    public void serialize(OBinaryToken token, OutputStream stream) throws IOException {
        DataOutputStream output = new DataOutputStream(stream);
        OJwtHeader header = token.getHeader();
        output.writeByte(this.associetedTypes.get(header.getType()).byteValue());
        output.writeByte(this.associetedKeys.get(header.getKeyId()).byteValue());
        output.writeByte(this.associetedAlgorithms.get(header.getAlgorithm()).byteValue());
        String toWrite = token.getDatabase();
        this.writeString(output, toWrite);
        if (token.getDatabaseType() == null) {
            output.writeByte(-1);
        } else {
            output.writeByte(this.associetedDdTypes.get(token.getDatabaseType()).byteValue());
        }
        ORID id = token.getUserId();
        if (id == null) {
            output.writeShort(-1);
            output.writeLong(-1L);
        } else {
            output.writeShort(id.getClusterId());
            output.writeLong(id.getClusterPosition());
        }
        output.writeLong(token.getExpiry());
        output.writeBoolean(token.isServerUser());
        if (token.isServerUser()) {
            this.writeString(output, token.getUserName());
        }
        output.writeShort(token.getProtocolVersion());
        this.writeString(output, token.getSerializer());
        this.writeString(output, token.getDriverName());
        this.writeString(output, token.getDriverVersion());
    }

    private void writeString(DataOutputStream output, String toWrite) throws UnsupportedEncodingException, IOException {
        if (toWrite == null) {
            output.writeShort(-1);
        } else {
            byte[] str = toWrite.getBytes("UTF-8");
            output.writeShort(str.length);
            output.write(str);
        }
    }
}

