/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.server.token;

import com.orientechnologies.common.exception.OException;
import com.orientechnologies.common.exception.OSystemException;
import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.common.util.OCommonConst;
import com.orientechnologies.orient.core.config.OContextConfiguration;
import com.orientechnologies.orient.core.config.OGlobalConfiguration;
import com.orientechnologies.orient.core.db.ODatabaseDocumentInternal;
import com.orientechnologies.orient.core.db.document.ODatabaseDocument;
import com.orientechnologies.orient.core.id.ORecordId;
import com.orientechnologies.orient.core.metadata.security.OSecurityUser;
import com.orientechnologies.orient.core.metadata.security.OToken;
import com.orientechnologies.orient.core.metadata.security.OTokenException;
import com.orientechnologies.orient.core.metadata.security.jwt.OJwtHeader;
import com.orientechnologies.orient.core.metadata.security.jwt.OJwtPayload;
import com.orientechnologies.orient.core.metadata.security.jwt.OKeyProvider;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.security.OSecurityManager;
import com.orientechnologies.orient.server.OClientConnection;
import com.orientechnologies.orient.server.OServer;
import com.orientechnologies.orient.server.OTokenHandler;
import com.orientechnologies.orient.server.binary.impl.OBinaryToken;
import com.orientechnologies.orient.server.config.OServerUserConfiguration;
import com.orientechnologies.orient.server.network.protocol.ONetworkProtocolData;
import com.orientechnologies.orient.server.token.DefaultKeyProvider;
import com.orientechnologies.orient.server.token.JsonWebToken;
import com.orientechnologies.orient.server.token.OBinaryTokenSerializer;
import com.orientechnologies.orient.server.token.OrientJwtHeader;
import com.orientechnologies.orient.server.token.OrientJwtPayload;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Base64;
import java.util.Random;
import java.util.UUID;
import javax.crypto.Mac;

public class OTokenHandlerImpl
implements OTokenHandler {
    public static final String ENCRYPTION_ALGORITHM_DEFAULT = "HmacSHA256";
    private static String algorithm = "HmacSHA256";
    private static final ThreadLocal<Mac> threadLocalMac = new MacThreadLocal();
    protected static final int JWT_DELIMITER = 46;
    private OBinaryTokenSerializer binarySerializer;
    private long sessionInMills = 3600000L;
    private OKeyProvider keyProvider;
    private Random keyGenerator = new Random();

    public OTokenHandlerImpl(OServer server) {
        String algorithm;
        byte[] key = null;
        OContextConfiguration config = server.getContextConfiguration();
        String configKey = config.getValueAsString(OGlobalConfiguration.NETWORK_TOKEN_SECRETKEY);
        if (configKey == null || configKey.length() == 0) {
            configKey = config.getValueAsString(OGlobalConfiguration.OAUTH2_SECRETKEY);
        }
        if (configKey != null && configKey.length() > 0) {
            key = Base64.getUrlDecoder().decode(configKey);
        }
        if (key == null) {
            key = OSecurityManager.instance().digestSHA256(String.valueOf(this.keyGenerator.nextLong()));
        }
        this.keyProvider = new DefaultKeyProvider(key);
        Long sessionTimeout = config.getValueAsLong(OGlobalConfiguration.NETWORK_TOKEN_EXPIRE_TIMEOUT);
        if (sessionTimeout != null) {
            this.sessionInMills = sessionTimeout * 1000L * 60L;
        }
        if ((algorithm = config.getValueAsString(OGlobalConfiguration.NETWORK_TOKEN_ENCRYPTION_ALGORITHM)) != null) {
            OTokenHandlerImpl.algorithm = algorithm;
        }
        try {
            Mac.getInstance(algorithm);
        }
        catch (NoSuchAlgorithmException nsa) {
            throw new IllegalArgumentException("Can't find encryption algorithm '" + algorithm + "'", nsa);
        }
        String[] stringArray = new String[1];
        stringArray[0] = OTokenHandlerImpl.algorithm;
        this.binarySerializer = new OBinaryTokenSerializer(new String[]{"plocal", "memory"}, this.keyProvider.getKeys(), stringArray, new String[]{"OrientDB", "node"});
    }

    protected OTokenHandlerImpl() {
    }

    protected OTokenHandlerImpl(byte[] key, long sessionLength, String algorithm) {
        this.keyProvider = new DefaultKeyProvider(key);
        OTokenHandlerImpl.algorithm = algorithm;
        this.sessionInMills = sessionLength * 1000L * 60L;
        String[] stringArray = new String[1];
        stringArray[0] = OTokenHandlerImpl.algorithm;
        this.binarySerializer = new OBinaryTokenSerializer(new String[]{"plocal", "memory"}, this.keyProvider.getKeys(), stringArray, new String[]{"OrientDB"});
    }

    @Override
    public OToken parseWebToken(byte[] tokenBytes) {
        JsonWebToken token = null;
        int firstDot = -1;
        int secondDot = -1;
        for (int x = 0; x < tokenBytes.length; ++x) {
            if (tokenBytes[x] != 46) continue;
            if (firstDot == -1) {
                firstDot = x;
                continue;
            }
            secondDot = x;
            break;
        }
        if (firstDot == -1) {
            throw new RuntimeException("Token data too short: missed header");
        }
        if (secondDot == -1) {
            throw new RuntimeException("Token data too short: missed signature");
        }
        byte[] decodedHeader = Base64.getUrlDecoder().decode(ByteBuffer.wrap(tokenBytes, 0, firstDot)).array();
        byte[] decodedPayload = Base64.getUrlDecoder().decode(ByteBuffer.wrap(tokenBytes, firstDot + 1, secondDot - (firstDot + 1))).array();
        byte[] decodedSignature = Base64.getUrlDecoder().decode(ByteBuffer.wrap(tokenBytes, secondDot + 1, tokenBytes.length - (secondDot + 1))).array();
        OrientJwtHeader header = this.deserializeWebHeader(decodedHeader);
        OJwtPayload deserializeWebPayload = this.deserializeWebPayload(header.getType(), decodedPayload);
        token = new JsonWebToken(header, deserializeWebPayload);
        token.setIsVerified(this.verifyTokenSignature(header, tokenBytes, 0, secondDot, decodedSignature));
        return token;
    }

    @Override
    public boolean validateToken(OToken token, String command, String database) {
        boolean valid = false;
        if (!(token instanceof JsonWebToken)) {
            return false;
        }
        OrientJwtPayload payload = (OrientJwtPayload)((JsonWebToken)token).getPayload();
        if (token.getDatabase().equalsIgnoreCase(database) && token.isNowValid()) {
            valid = true;
        }
        token.setIsValid(valid);
        return valid;
    }

    @Override
    public boolean validateBinaryToken(OToken token) {
        boolean valid = false;
        if (token instanceof OBinaryToken && "node".equals(((OBinaryToken)token).getHeader().getType())) {
            valid = true;
        } else {
            long curTime = System.currentTimeMillis();
            if (token.getExpiry() > curTime && token.getExpiry() - (this.sessionInMills + 1L) < curTime) {
                valid = true;
            }
        }
        token.setIsValid(valid);
        return valid;
    }

    @Override
    public byte[] getSignedWebToken(ODatabaseDocument db, OSecurityUser user) {
        ByteArrayOutputStream tokenByteOS = new ByteArrayOutputStream(1024);
        OrientJwtHeader header = new OrientJwtHeader();
        header.setAlgorithm("HS256");
        header.setKeyId("");
        OJwtPayload payload = this.createPayload(db, user);
        header.setType(this.getPayloadType(payload));
        try {
            byte[] bytes = this.serializeWebHeader(header);
            tokenByteOS.write(Base64.getUrlEncoder().encode(ByteBuffer.wrap(bytes, 0, bytes.length)).array());
            tokenByteOS.write(46);
            bytes = this.serializeWebPayload(payload);
            tokenByteOS.write(Base64.getUrlEncoder().encode(ByteBuffer.wrap(bytes, 0, bytes.length)).array());
            byte[] unsignedToken = tokenByteOS.toByteArray();
            tokenByteOS.write(46);
            bytes = this.signToken(header, unsignedToken);
            tokenByteOS.write(Base64.getUrlEncoder().encode(ByteBuffer.wrap(bytes, 0, bytes.length)).array());
        }
        catch (Exception ex) {
            throw OException.wrapException(new OSystemException("Error on token parsing"), ex);
        }
        return tokenByteOS.toByteArray();
    }

    @Override
    public byte[] getSignedWebTokenServerUser(OServerUserConfiguration user) {
        ByteArrayOutputStream tokenByteOS = new ByteArrayOutputStream(1024);
        OrientJwtHeader header = new OrientJwtHeader();
        header.setAlgorithm("HS256");
        header.setKeyId("");
        OJwtPayload payload = this.createPayloadServerUser(user);
        header.setType(this.getPayloadType(payload));
        try {
            byte[] bytes = this.serializeWebHeader(header);
            tokenByteOS.write(Base64.getUrlEncoder().encode(ByteBuffer.wrap(bytes, 0, bytes.length)).array());
            tokenByteOS.write(46);
            bytes = this.serializeWebPayload(payload);
            tokenByteOS.write(Base64.getUrlEncoder().encode(ByteBuffer.wrap(bytes, 0, bytes.length)).array());
            byte[] unsignedToken = tokenByteOS.toByteArray();
            tokenByteOS.write(46);
            bytes = this.signToken(header, unsignedToken);
            tokenByteOS.write(Base64.getUrlEncoder().encode(ByteBuffer.wrap(bytes, 0, bytes.length)).array());
        }
        catch (Exception ex) {
            throw OException.wrapException(new OSystemException("Error on token parsing"), ex);
        }
        return tokenByteOS.toByteArray();
    }

    @Override
    public boolean validateServerUserToken(OToken token, String command, String database) {
        boolean valid = false;
        if (!(token instanceof JsonWebToken)) {
            return false;
        }
        OrientJwtPayload payload = (OrientJwtPayload)((JsonWebToken)token).getPayload();
        if (token.isNowValid()) {
            valid = true;
        }
        token.setIsValid(valid);
        return valid;
    }

    @Override
    public byte[] getDistributedToken(ONetworkProtocolData data) {
        try {
            OBinaryToken token = new OBinaryToken();
            OrientJwtHeader header = new OrientJwtHeader();
            header.setAlgorithm(algorithm);
            header.setKeyId(this.keyProvider.getDefaultKey());
            header.setType("node");
            token.setHeader(header);
            token.setServerUser(true);
            token.setUserName(data.serverUsername);
            token.setExpiry(0L);
            token.setProtocolVersion(data.protocolVersion);
            token.setSerializer(data.getSerializationImpl());
            token.setDriverName(data.driverName);
            token.setDriverVersion(data.driverVersion);
            return this.serializeSignedToken(token);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw OException.wrapException(new OSystemException("Error on token parsing"), e);
        }
    }

    @Override
    public byte[] getSignedBinaryToken(ODatabaseDocumentInternal db, OSecurityUser user, ONetworkProtocolData data) {
        try {
            OBinaryToken token = new OBinaryToken();
            long curTime = System.currentTimeMillis();
            OrientJwtHeader header = new OrientJwtHeader();
            header.setAlgorithm(algorithm);
            header.setKeyId(this.keyProvider.getDefaultKey());
            header.setType("OrientDB");
            token.setHeader(header);
            if (db != null) {
                token.setDatabase(db.getName());
                token.setDatabaseType(db.getStorage().getUnderlying().getType());
            }
            if (data.serverUser) {
                token.setServerUser(true);
                token.setUserName(data.serverUsername);
            }
            if (user != null) {
                token.setUserRid(user.getIdentity().getIdentity());
            }
            token.setExpiry(curTime + this.sessionInMills);
            token.setProtocolVersion(data.protocolVersion);
            token.setSerializer(data.getSerializationImpl());
            token.setDriverName(data.driverName);
            token.setDriverVersion(data.driverVersion);
            return this.serializeSignedToken(token);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw OException.wrapException(new OSystemException("Error on token parsing"), e);
        }
    }

    private byte[] serializeSignedToken(OBinaryToken token) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        this.binarySerializer.serialize(token, baos);
        byte[] signature = this.signToken(token.getHeader(), baos.toByteArray());
        baos.write(signature);
        return baos.toByteArray();
    }

    @Override
    public ONetworkProtocolData getProtocolDataFromToken(OClientConnection connection, OToken token) {
        if (token instanceof OBinaryToken) {
            OBinaryToken binary = (OBinaryToken)token;
            ONetworkProtocolData data = new ONetworkProtocolData();
            data.protocolVersion = binary.getProtocolVersion();
            data.setSerializationImpl(binary.getSerializer());
            data.driverName = binary.getDriverName();
            data.driverVersion = binary.getDriverVersion();
            data.serverUser = binary.isServerUser();
            data.serverUsername = binary.getUserName();
            data.serverUsername = binary.getUserName();
            data.supportsLegacyPushMessages = connection.getData().supportsLegacyPushMessages;
            data.collectStats = connection.getData().collectStats;
            return data;
        }
        return null;
    }

    @Override
    public OToken parseNotVerifyBinaryToken(byte[] binaryToken) {
        ByteArrayInputStream bais = new ByteArrayInputStream(binaryToken);
        return this.deserializeBinaryToken(bais);
    }

    @Override
    public OToken parseBinaryToken(byte[] binaryToken) {
        try {
            ByteArrayInputStream bais = new ByteArrayInputStream(binaryToken);
            OBinaryToken token = this.deserializeBinaryToken(bais);
            int end = binaryToken.length - bais.available();
            byte[] decodedSignature = new byte[bais.available()];
            bais.read(decodedSignature);
            token.setIsVerified(this.verifyTokenSignature(token.getHeader(), binaryToken, 0, end, decodedSignature));
            return token;
        }
        catch (Exception e) {
            throw OException.wrapException(new OSystemException("Error on token parsing"), e);
        }
    }

    @Override
    public byte[] renewIfNeeded(OToken token) {
        if (token == null) {
            throw new IllegalArgumentException("Token is null");
        }
        long curTime = System.currentTimeMillis();
        if (token.getExpiry() - curTime < this.sessionInMills / 2L && token.getExpiry() >= curTime) {
            long expiryMinutes = this.sessionInMills;
            long currTime = System.currentTimeMillis();
            token.setExpiry(currTime + expiryMinutes);
            try {
                if (token instanceof OBinaryToken) {
                    return this.serializeSignedToken((OBinaryToken)token);
                }
                throw new OTokenException("renew of web token not supported");
            }
            catch (IOException e) {
                throw OException.wrapException(new OSystemException("Error on token parsing"), e);
            }
        }
        return OCommonConst.EMPTY_BYTE_ARRAY;
    }

    public long getSessionInMills() {
        return this.sessionInMills;
    }

    @Override
    public boolean isEnabled() {
        return true;
    }

    protected OrientJwtHeader deserializeWebHeader(byte[] decodedHeader) {
        ODocument doc = new ODocument();
        try {
            doc.fromJSON(new String(decodedHeader, "UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            throw OException.wrapException(new OSystemException("Header is not encoded in UTF-8 format"), e);
        }
        OrientJwtHeader header = new OrientJwtHeader();
        header.setType((String)doc.field("typ"));
        header.setAlgorithm((String)doc.field("alg"));
        header.setKeyId((String)doc.field("kid"));
        return header;
    }

    protected OJwtPayload deserializeWebPayload(String type, byte[] decodedPayload) {
        if (!"OrientDB".equals(type)) {
            throw new OSystemException("Payload class not registered:" + type);
        }
        ODocument doc = new ODocument();
        try {
            doc.fromJSON(new String(decodedPayload, "UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            throw OException.wrapException(new OSystemException("Payload encoding format differs from UTF-8"), e);
        }
        OrientJwtPayload payload = new OrientJwtPayload();
        payload.setUserName((String)doc.field("username"));
        payload.setIssuer((String)doc.field("iss"));
        payload.setExpiry((Long)doc.field("exp"));
        payload.setIssuedAt((Long)doc.field("iat"));
        payload.setNotBefore((Long)doc.field("nbf"));
        payload.setDatabase((String)doc.field("sub"));
        payload.setAudience((String)doc.field("aud"));
        payload.setTokenId((String)doc.field("jti"));
        int cluster = (Integer)doc.field("uidc");
        long pos = (Long)doc.field("uidp");
        payload.setUserRid(new ORecordId(cluster, pos));
        payload.setDatabaseType((String)doc.field("bdtyp"));
        return payload;
    }

    protected byte[] serializeWebHeader(OJwtHeader header) throws Exception {
        if (header == null) {
            throw new IllegalArgumentException("Token header is null");
        }
        ODocument doc = new ODocument();
        doc.field("typ", header.getType());
        doc.field("alg", header.getAlgorithm());
        doc.field("kid", header.getKeyId());
        return doc.toJSON().getBytes("UTF-8");
    }

    protected byte[] serializeWebPayload(OJwtPayload payload) throws Exception {
        if (payload == null) {
            throw new IllegalArgumentException("Token payload is null");
        }
        ODocument doc = new ODocument();
        doc.field("username", payload.getUserName());
        doc.field("iss", payload.getIssuer());
        doc.field("exp", payload.getExpiry());
        doc.field("iat", payload.getIssuedAt());
        doc.field("nbf", payload.getNotBefore());
        doc.field("sub", payload.getDatabase());
        doc.field("aud", payload.getAudience());
        doc.field("jti", payload.getTokenId());
        doc.field("uidc", ((OrientJwtPayload)payload).getUserRid().getClusterId());
        doc.field("uidp", ((OrientJwtPayload)payload).getUserRid().getClusterPosition());
        doc.field("bdtyp", ((OrientJwtPayload)payload).getDatabaseType());
        return doc.toJSON().getBytes("UTF-8");
    }

    protected OJwtPayload createPayloadServerUser(OServerUserConfiguration serverUser) {
        if (serverUser == null) {
            throw new IllegalArgumentException("User is null");
        }
        OrientJwtPayload payload = new OrientJwtPayload();
        payload.setAudience("OrientDBServer");
        payload.setDatabase("-");
        payload.setUserRid(ORecordId.EMPTY_RECORD_ID);
        long expiryMinutes = this.sessionInMills;
        long currTime = System.currentTimeMillis();
        payload.setIssuedAt(currTime);
        payload.setNotBefore(currTime);
        payload.setUserName(serverUser.name);
        payload.setTokenId(UUID.randomUUID().toString());
        payload.setExpiry(currTime + expiryMinutes);
        return payload;
    }

    protected OJwtPayload createPayload(ODatabaseDocument db, OSecurityUser user) {
        if (user == null) {
            throw new IllegalArgumentException("User is null");
        }
        OrientJwtPayload payload = new OrientJwtPayload();
        payload.setAudience("OrientDB");
        payload.setDatabase(db.getName());
        payload.setUserRid(user.getDocument().getIdentity());
        long expiryMinutes = this.sessionInMills;
        long currTime = System.currentTimeMillis();
        payload.setIssuedAt(currTime);
        payload.setNotBefore(currTime);
        payload.setUserName(user.getName());
        payload.setTokenId(UUID.randomUUID().toString());
        payload.setExpiry(currTime + expiryMinutes);
        return payload;
    }

    protected String getPayloadType(OJwtPayload payload) {
        return "OrientDB";
    }

    protected OKeyProvider getKeyProvider() {
        return this.keyProvider;
    }

    private boolean verifyTokenSignature(OJwtHeader header, byte[] base, int baseOffset, int baseLength, byte[] signature) {
        Mac mac = threadLocalMac.get();
        try {
            mac.init(this.getKeyProvider().getKey(header));
            mac.update(base, baseOffset, baseLength);
            byte[] calculatedSignature = mac.doFinal();
            boolean valid = MessageDigest.isEqual(calculatedSignature, signature);
            if (!valid) {
                OLogManager.instance().warn((Object)this, "Token signature failure: %s", Base64.getEncoder().encodeToString(base));
            }
            boolean bl = valid;
            return bl;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw OException.wrapException(new OSystemException("Token signature cannot be verified"), e);
        }
        finally {
            mac.reset();
        }
    }

    private byte[] signToken(OJwtHeader header, byte[] unsignedToken) {
        Mac mac = threadLocalMac.get();
        try {
            mac.init(this.getKeyProvider().getKey(header));
            byte[] byArray = mac.doFinal(unsignedToken);
            return byArray;
        }
        catch (Exception ex) {
            throw OException.wrapException(new OSystemException("Error on token parsing"), ex);
        }
        finally {
            mac.reset();
        }
    }

    private OBinaryToken deserializeBinaryToken(InputStream bais) {
        try {
            return this.binarySerializer.deserialize(bais);
        }
        catch (Exception e) {
            throw OException.wrapException(new OSystemException("Cannot deserialize binary token"), e);
        }
    }

    public void setSessionInMills(long sessionInMills) {
        this.sessionInMills = sessionInMills;
    }

    private static class MacThreadLocal
    extends ThreadLocal<Mac> {
        private MacThreadLocal() {
        }

        @Override
        protected Mac initialValue() {
            try {
                return Mac.getInstance(algorithm);
            }
            catch (NoSuchAlgorithmException nsa) {
                throw new IllegalArgumentException("Can't find encryption algorithm '" + algorithm + "'", nsa);
            }
        }
    }
}

