/*
 * Decompiled with CFR 0.152.
 */
package com.tinkerpop.blueprints.impls.orient;

import com.orientechnologies.orient.core.metadata.schema.OClass;
import com.orientechnologies.orient.core.metadata.schema.OSchema;
import com.orientechnologies.orient.core.metadata.schema.OType;
import com.orientechnologies.orient.core.record.OElement;
import com.orientechnologies.orient.core.record.ORecord;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.sql.executor.OResultSet;
import com.tinkerpop.blueprints.CloseableIterable;
import com.tinkerpop.blueprints.Edge;
import com.tinkerpop.blueprints.Element;
import com.tinkerpop.blueprints.Vertex;
import com.tinkerpop.blueprints.impls.orient.OrientBaseGraph;
import com.tinkerpop.blueprints.impls.orient.OrientEdge;
import com.tinkerpop.blueprints.impls.orient.OrientElement;
import com.tinkerpop.blueprints.impls.orient.OrientElementIterable;
import com.tinkerpop.blueprints.impls.orient.OrientIndex;
import com.tinkerpop.blueprints.impls.orient.OrientVertex;
import com.tinkerpop.blueprints.util.ExceptionFactory;
import com.tinkerpop.blueprints.util.StringFactory;
import java.util.ArrayList;

public class OrientIndexAuto<T extends OrientElement>
implements OrientIndex<T> {
    private static final String ELEMENT_FIELD = "element";
    private static final String VERTEX = "Vertex";
    private static final String EDGE = "Edge";
    private static final String CONFIG_CLASS_PREFIX = "___42_record_map_config_auto_42____";
    private static final String INDEX_SUFFIX = "_index";
    private static final String REVERT_INDEX_SUFFIX = "_revert_index";
    private static final String CLASS_PREFIX = "___42_record_map_auto_42___";
    private static final String KEY_FIELD = "key";
    private static final String VALUE_FIELD = "value";
    private static final String CLASS_NAME_FIELD = "className";
    private final String indexName;
    private final Class<? extends Element> indexClass;
    private final OrientBaseGraph graph;

    public static <T extends OrientElement> OrientIndexAuto<T> create(OrientBaseGraph graph, String indexName, Class<T> indexClass) {
        String indexClassName;
        OSchema schema = graph.getRawGraph().getMetadata().getSchema();
        if (schema.getClass(indexClassName = OrientIndexAuto.generateClassName(indexName)) != null) {
            throw ExceptionFactory.indexAlreadyExists(indexName);
        }
        OClass cls = schema.createClass(indexClassName);
        OClass configCls = schema.createClass(OrientIndexAuto.generateConfigClassName(indexName));
        cls.createProperty(KEY_FIELD, OType.STRING);
        cls.createProperty(VALUE_FIELD, OType.STRING);
        cls.createProperty(ELEMENT_FIELD, OType.LINK);
        cls.createIndex(OrientIndexAuto.generateIndexName(indexClassName), OClass.INDEX_TYPE.NOTUNIQUE, KEY_FIELD, VALUE_FIELD);
        cls.createIndex(OrientIndexAuto.generateRevertIndexName(indexClassName), OClass.INDEX_TYPE.NOTUNIQUE, ELEMENT_FIELD);
        String className = Vertex.class.isAssignableFrom(indexClass) ? VERTEX : (Edge.class.isAssignableFrom(indexClass) ? EDGE : indexClass.getName());
        ODocument document = new ODocument(configCls);
        document.field(CLASS_NAME_FIELD, className);
        document.save();
        return new OrientIndexAuto<T>(graph, indexName, indexClass);
    }

    public static <T extends OrientElement> OrientIndexAuto<T> load(OrientBaseGraph graph, String indexName, Class<T> indexClass) {
        Class loadedClass;
        String className;
        String indexClassName = OrientIndexAuto.generateClassName(indexName);
        OSchema schema = graph.getRawGraph().getMetadata().getSchema();
        if (schema.getClass(indexClassName) == null) {
            return null;
        }
        try (OResultSet resultSet = graph.getRawGraph().query("select className from " + OrientIndexAuto.generateConfigClassName(indexName), new Object[0]);){
            if (!resultSet.hasNext()) {
                throw new IllegalStateException("Index " + indexName + " is broken can not find configuration");
            }
            className = (String)resultSet.next().getProperty(CLASS_NAME_FIELD);
        }
        if (VERTEX.equals(className)) {
            loadedClass = Vertex.class;
        } else if (EDGE.equals(className)) {
            loadedClass = Edge.class;
        } else {
            try {
                loadedClass = Class.forName(className);
            }
            catch (ClassNotFoundException e) {
                throw new IllegalArgumentException("Index class '" + className + "' is not registered. Supported ones: Vertex, Edge and custom class that extends them", e);
            }
        }
        if (indexClass != null && !indexClass.isAssignableFrom(loadedClass)) {
            throw ExceptionFactory.indexDoesNotSupportClass(indexName, indexClass);
        }
        return new OrientIndexAuto<T>(graph, indexName, loadedClass);
    }

    public static void drop(OrientBaseGraph graph, String indexName) {
        String configClassName;
        String indexClassName;
        OSchema schema = graph.getRawGraph().getMetadata().getSchema();
        if (schema.getClass(indexClassName = OrientIndexAuto.generateClassName(indexName)) != null) {
            schema.dropClass(indexClassName);
        }
        if (schema.getClass(configClassName = OrientIndexAuto.generateConfigClassName(indexName)) != null) {
            schema.dropClass(configClassName);
        }
    }

    static boolean isIndexClass(String className) {
        return className.contains(CLASS_PREFIX);
    }

    private static String generateConfigClassName(String indexName) {
        return CONFIG_CLASS_PREFIX + indexName;
    }

    private static String generateIndexName(String indexClassName) {
        return indexClassName + INDEX_SUFFIX;
    }

    private static String generateRevertIndexName(String indexClassName) {
        return indexClassName + REVERT_INDEX_SUFFIX;
    }

    private static String generateClassName(String indexName) {
        return CLASS_PREFIX + indexName;
    }

    static String extractIndexName(String indexClassName) {
        return indexClassName.substring(CLASS_PREFIX.length());
    }

    private OrientIndexAuto(OrientBaseGraph graph, String indexName, Class<? extends Element> indexClass) {
        this.graph = graph;
        this.indexName = indexName;
        this.indexClass = indexClass;
    }

    @Override
    public String getIndexName() {
        return this.indexName;
    }

    @Override
    public Class<T> getIndexClass() {
        return this.indexClass;
    }

    @Override
    public void put(String key, Object value, T element) {
        String indexClassName = OrientIndexAuto.generateClassName(this.indexName);
        this.graph.setCurrentGraphInThreadLocal();
        this.graph.autoStartTransaction();
        ODocument document = new ODocument(indexClassName);
        document.field(KEY_FIELD, key);
        document.field(VALUE_FIELD, value.toString());
        ODocument doc = ((OrientElement)element).getRecord();
        if (!doc.getIdentity().isValid()) {
            doc.save();
        }
        document.field(ELEMENT_FIELD, doc.getIdentity());
        document.save();
    }

    @Override
    public CloseableIterable<T> get(String key, Object value) {
        this.graph.setCurrentGraphInThreadLocal();
        String indexClassName = OrientIndexAuto.generateClassName(this.indexName);
        ArrayList<OrientElement> result = new ArrayList<OrientElement>();
        try (OResultSet resultSet = this.graph.getRawGraph().query("select element from " + indexClassName + " where " + KEY_FIELD + " = ? and " + VALUE_FIELD + " = ? ", key, value.toString());){
            while (resultSet.hasNext()) {
                OElement element = resultSet.next().getElementProperty(ELEMENT_FIELD);
                if (element.isVertex()) {
                    result.add(new OrientVertex(this.graph, element));
                    continue;
                }
                if (element.isEdge()) {
                    result.add(new OrientEdge(this.graph, element));
                    continue;
                }
                throw new IllegalStateException("Fetched record is not part of graph type system, its type is " + element.getSchemaType());
            }
        }
        return new OrientElementIterable(this.graph, result);
    }

    @Override
    public CloseableIterable<T> query(String key, Object query) {
        throw new UnsupportedOperationException();
    }

    @Override
    public long count(String key, Object value) {
        this.graph.setCurrentGraphInThreadLocal();
        String indexClassName = OrientIndexAuto.generateClassName(this.indexName);
        try (OResultSet resultSet = this.graph.getRawGraph().query("select count(*) as count from " + indexClassName + " where " + KEY_FIELD + " = ? and " + VALUE_FIELD + " = ? ", key, value.toString());){
            if (resultSet.hasNext()) {
                long l = (Long)resultSet.next().getProperty("count");
                return l;
            }
        }
        return 0L;
    }

    @Override
    public void remove(String key, Object value, T element) {
        this.graph.setCurrentGraphInThreadLocal();
        this.graph.autoStartTransaction();
        String indexClassName = OrientIndexAuto.generateClassName(this.indexName);
        this.graph.getRawGraph().command("delete from " + indexClassName + " where " + KEY_FIELD + " = ? and " + VALUE_FIELD + " = ? and " + ELEMENT_FIELD + " = ?", key, value.toString(), ((OrientElement)element).getIdentity()).close();
    }

    @Override
    public void removeElement(T element) {
        this.graph.setCurrentGraphInThreadLocal();
        this.graph.autoStartTransaction();
        String indexClassName = OrientIndexAuto.generateClassName(this.indexName);
        try (OResultSet resultSet = this.graph.getRawGraph().query("select * from " + indexClassName + " where " + ELEMENT_FIELD + " = ?", ((OrientElement)element).getIdentity());){
            while (resultSet.hasNext()) {
                resultSet.next().getRecord().ifPresent(ORecord::delete);
            }
        }
    }

    public String toString() {
        return StringFactory.indexString(this);
    }
}

