/*
 * Decompiled with CFR 0.152.
 */
package com.tinkerpop.blueprints.impls.orient;

import com.orientechnologies.orient.core.db.document.ODatabaseDocumentTx;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.id.ORID;
import com.orientechnologies.orient.core.index.OCompositeKey;
import com.orientechnologies.orient.core.index.OIndex;
import com.orientechnologies.orient.core.index.OIndexInternal;
import com.orientechnologies.orient.core.index.OIndexTxAwareMultiValue;
import com.orientechnologies.orient.core.index.OIndexTxAwareOneValue;
import com.orientechnologies.orient.core.index.OSimpleKeyIndexDefinition;
import com.orientechnologies.orient.core.metadata.schema.OClass;
import com.orientechnologies.orient.core.metadata.schema.OType;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.sql.query.OSQLSynchQuery;
import com.tinkerpop.blueprints.CloseableIterable;
import com.tinkerpop.blueprints.Edge;
import com.tinkerpop.blueprints.Element;
import com.tinkerpop.blueprints.Vertex;
import com.tinkerpop.blueprints.impls.orient.OrientBaseGraph;
import com.tinkerpop.blueprints.impls.orient.OrientElement;
import com.tinkerpop.blueprints.impls.orient.OrientElementIterable;
import com.tinkerpop.blueprints.impls.orient.OrientIndex;
import com.tinkerpop.blueprints.util.StringFactory;
import com.tinkerpop.blueprints.util.WrappingCloseableIterable;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class OrientIndexManual<T extends OrientElement>
implements OrientIndex<T> {
    public static final String CONFIG_CLASSNAME = "blueprintsIndexClass";
    public static final String CONFIG_RECORD_MAP_NAME = "record_map_name";
    protected static final String VERTEX = "Vertex";
    protected static final String EDGE = "Edge";
    protected static final String SEPARATOR = "!=!";
    protected OrientBaseGraph graph;
    protected OIndex underlying;
    protected OIndex recordKeyValueIndex;
    protected Class<? extends Element> indexClass;

    protected OrientIndexManual(OrientBaseGraph graph, String indexName, Class<? extends Element> indexClass, OType iType) {
        this.graph = graph;
        this.indexClass = indexClass;
        this.create(indexName, this.indexClass, iType);
    }

    protected OrientIndexManual(OrientBaseGraph orientGraph, OIndex rawIndex) {
        this.graph = orientGraph;
        OIndexInternal rawIndexInternal = rawIndex.getInternal();
        this.underlying = rawIndexInternal == null ? rawIndex : (rawIndexInternal instanceof OIndexTxAwareMultiValue ? rawIndexInternal : new OIndexTxAwareMultiValue(orientGraph.getRawGraph(), rawIndexInternal));
        ODocument metadata = rawIndex.getMetadata();
        if (metadata == null) {
            this.load(rawIndex.getConfiguration());
        } else {
            this.load(metadata);
        }
    }

    @Override
    public String getIndexName() {
        return this.underlying.getName();
    }

    @Override
    public Class<T> getIndexClass() {
        return this.indexClass;
    }

    @Override
    public void put(String key, Object value, T element) {
        String keyTemp = key + SEPARATOR + value;
        ODocument doc = ((OrientElement)element).getRecord();
        if (!doc.getIdentity().isValid()) {
            doc.save();
        }
        this.graph.setCurrentGraphInThreadLocal();
        this.graph.autoStartTransaction();
        this.underlying.put(keyTemp, doc);
        this.recordKeyValueIndex.put(new OCompositeKey(doc.getIdentity(), keyTemp), doc.getIdentity());
    }

    @Override
    public CloseableIterable<T> get(String key, Object iValue) {
        Collection records;
        String keyTemp = key + SEPARATOR + iValue;
        try (Stream<ORID> rids = this.underlying.getInternal().getRids(keyTemp);){
            records = rids.collect(Collectors.toList());
        }
        if (records == null || records.isEmpty()) {
            return new WrappingCloseableIterable(Collections.emptySet());
        }
        return new OrientElementIterable(this.graph, records);
    }

    @Override
    public CloseableIterable<T> query(String key, Object query) throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    @Override
    public long count(String key, Object value) {
        String keyTemp = key + SEPARATOR + value;
        try (Stream<ORID> rids = this.underlying.getInternal().getRids(keyTemp);){
            long l = rids.count();
            return l;
        }
    }

    @Override
    public void remove(String key, Object value, T element) {
        String keyTemp = key + SEPARATOR + value;
        this.graph.setCurrentGraphInThreadLocal();
        this.graph.autoStartTransaction();
        try {
            this.underlying.remove(keyTemp, ((OrientElement)element).getRecord());
            this.recordKeyValueIndex.remove(new OCompositeKey(((OrientElement)element).getIdentity(), keyTemp), ((OrientElement)element).getIdentity());
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    public String toString() {
        return StringFactory.indexString(this);
    }

    public OIndex getUnderlying() {
        return this.underlying;
    }

    public void close() {
        if (this.underlying != null) {
            this.underlying = null;
        }
        this.graph = null;
    }

    @Override
    public void removeElement(T element) {
        this.graph.setCurrentGraphInThreadLocal();
        this.graph.autoStartTransaction();
        OSQLSynchQuery query = new OSQLSynchQuery("select from index:" + this.recordKeyValueIndex.getName() + " where key between [" + ((OrientElement)element).getIdentity() + "] and [" + ((OrientElement)element).getIdentity() + "]");
        Object entries = this.graph.getRawGraph().query(query, new Object[0]);
        for (ODocument entry : entries) {
            OCompositeKey key = (OCompositeKey)entry.field("key");
            List<Object> keys2 = key.getKeys();
            this.underlying.remove(keys2.get(1).toString(), ((OrientElement)element).getIdentity());
            this.recordKeyValueIndex.remove(key, ((OrientElement)element).getIdentity());
        }
    }

    private void create(String indexName, Class<? extends Element> indexClass, OType iKeyType) {
        this.indexClass = indexClass;
        if (iKeyType == null) {
            iKeyType = OType.STRING;
        }
        ODatabaseDocumentTx db = this.graph.getRawGraph();
        this.recordKeyValueIndex = db.getMetadata().getIndexManagerInternal().createIndex(db, "__@recordmap@___" + indexName, OClass.INDEX_TYPE.DICTIONARY.toString(), new OSimpleKeyIndexDefinition(OType.LINK, OType.STRING), null, null, null);
        if (!db.getStorage().isRemote()) {
            this.recordKeyValueIndex = new OIndexTxAwareOneValue(db, this.recordKeyValueIndex.getInternal());
        }
        String className = Vertex.class.isAssignableFrom(indexClass) ? VERTEX : (Edge.class.isAssignableFrom(indexClass) ? EDGE : indexClass.getName());
        ODocument metadata = new ODocument();
        metadata.field(CONFIG_CLASSNAME, className);
        metadata.field(CONFIG_RECORD_MAP_NAME, this.recordKeyValueIndex.getName());
        this.underlying = !db.getStorage().isRemote() ? new OIndexTxAwareMultiValue(db, db.getMetadata().getIndexManagerInternal().createIndex(db, indexName, OClass.INDEX_TYPE.NOTUNIQUE.toString(), new OSimpleKeyIndexDefinition(iKeyType), null, null, metadata).getInternal()) : db.getMetadata().getIndexManagerInternal().createIndex(db, indexName, OClass.INDEX_TYPE.NOTUNIQUE.toString(), new OSimpleKeyIndexDefinition(iKeyType), null, null, metadata);
    }

    private void load(ODocument metadata) {
        OIndex index;
        OIndexInternal indexInternal;
        String indexClassName = (String)metadata.field(CONFIG_CLASSNAME);
        String recordKeyValueMap = (String)metadata.field(CONFIG_RECORD_MAP_NAME);
        if (VERTEX.equals(indexClassName)) {
            this.indexClass = Vertex.class;
        } else if (EDGE.equals(indexClassName)) {
            this.indexClass = Edge.class;
        } else {
            try {
                this.indexClass = Class.forName(indexClassName);
            }
            catch (ClassNotFoundException e) {
                throw new IllegalArgumentException("Index class '" + indexClassName + "' is not registered. Supported ones: Vertex, Edge and custom class that extends them", e);
            }
        }
        ODatabaseDocumentTx database = this.graph.getRawGraph();
        this.recordKeyValueIndex = recordKeyValueMap == null ? this.buildKeyValueIndex(metadata) : ((indexInternal = (index = database.getMetadata().getIndexManagerInternal().getIndex(database, recordKeyValueMap)).getInternal()) != null ? new OIndexTxAwareOneValue(database, indexInternal) : index);
    }

    private OIndex buildKeyValueIndex(ODocument metadata) {
        ODatabaseDocumentTx database = this.graph.getRawGraph();
        OIndex index = database.getMetadata().getIndexManagerInternal().createIndex(database, "__@recordmap@___" + this.underlying.getName(), OClass.INDEX_TYPE.DICTIONARY.toString(), new OSimpleKeyIndexDefinition(OType.LINK, OType.STRING), null, null, null);
        OIndexInternal indexInternal = index.getInternal();
        OIndex recordKeyValueIndex = indexInternal != null ? new OIndexTxAwareOneValue(this.graph.getRawGraph(), indexInternal) : index;
        Object entries = this.graph.getRawGraph().query(new OSQLSynchQuery("select  from index:" + this.underlying.getName()), new Object[0]);
        for (ODocument entry : entries) {
            OIdentifiable rid = (OIdentifiable)entry.field("rid");
            if (rid == null) continue;
            recordKeyValueIndex.put(new OCompositeKey(rid, entry.field("key")), rid);
        }
        metadata.field(CONFIG_RECORD_MAP_NAME, recordKeyValueIndex.getName());
        return recordKeyValueIndex;
    }
}

