/*
 * Decompiled with CFR 0.152.
 */
package com.tinkerpop.blueprints.util.wrappers.batch.cache;

import com.tinkerpop.blueprints.Vertex;
import com.tinkerpop.blueprints.util.wrappers.batch.cache.VertexCache;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

abstract class AbstractIDVertexCache
implements VertexCache {
    static final int INITIAL_CAPACITY = 1000;
    static final int INITIAL_TX_CAPACITY = 100;
    private final Map<Object, Object> map = new HashMap<Object, Object>(1000);
    private final Set<Object> mapKeysInCurrentTx = new HashSet<Object>(100);

    AbstractIDVertexCache() {
    }

    @Override
    public Object getEntry(Object externalId) {
        return this.map.get(externalId);
    }

    @Override
    public void set(Vertex vertex, Object externalId) {
        this.setId(vertex, externalId);
    }

    @Override
    public void setId(Object vertexId, Object externalId) {
        this.map.put(externalId, vertexId);
        this.mapKeysInCurrentTx.add(externalId);
    }

    @Override
    public boolean contains(Object externalId) {
        return this.map.containsKey(externalId);
    }

    @Override
    public void newTransaction() {
        for (Object id : this.mapKeysInCurrentTx) {
            Object o = this.map.get(id);
            assert (null != o);
            if (!(o instanceof Vertex)) continue;
            Vertex v = (Vertex)o;
            this.map.put(id, v.getId());
        }
        this.mapKeysInCurrentTx.clear();
    }
}

