/*
 * Decompiled with CFR 0.152.
 */
package com.tinkerpop.blueprints.util.wrappers.batch.cache;

import com.carrotsearch.hppc.LongArrayList;
import com.carrotsearch.hppc.LongObjectMap;
import com.carrotsearch.hppc.LongObjectOpenHashMap;
import com.carrotsearch.hppc.procedures.LongProcedure;
import com.tinkerpop.blueprints.Vertex;
import com.tinkerpop.blueprints.util.wrappers.batch.cache.VertexCache;

public class LongIDVertexCache
implements VertexCache {
    private final LongObjectMap<Object> map = new LongObjectOpenHashMap<Object>(1000);
    private final LongArrayList mapKeysInCurrentTx = new LongArrayList(100);
    private final LongProcedure newTransactionProcedure = new VertexConverterLP();

    private static long getID(Object externalID) {
        if (!(externalID instanceof Number)) {
            throw new IllegalArgumentException("Number expected.");
        }
        return ((Number)externalID).longValue();
    }

    @Override
    public Object getEntry(Object externalId) {
        return this.map.get(LongIDVertexCache.getID(externalId));
    }

    @Override
    public void set(Vertex vertex, Object externalId) {
        this.setId(vertex, externalId);
    }

    @Override
    public void setId(Object vertexId, Object externalId) {
        long id = LongIDVertexCache.getID(externalId);
        this.map.put(id, vertexId);
        this.mapKeysInCurrentTx.add(id);
    }

    @Override
    public boolean contains(Object externalId) {
        return this.map.containsKey(LongIDVertexCache.getID(externalId));
    }

    @Override
    public void newTransaction() {
        this.mapKeysInCurrentTx.forEach(this.newTransactionProcedure);
        this.mapKeysInCurrentTx.clear();
    }

    private class VertexConverterLP
    implements LongProcedure {
        private VertexConverterLP() {
        }

        @Override
        public void apply(long l) {
            Object o = LongIDVertexCache.this.map.get(l);
            assert (null != o);
            if (o instanceof Vertex) {
                LongIDVertexCache.this.map.put(l, ((Vertex)o).getId());
            }
        }
    }
}

