/*
 * Decompiled with CFR 0.152.
 */
package com.tinkerpop.blueprints.util.wrappers.event.listener;

import com.tinkerpop.blueprints.Edge;
import com.tinkerpop.blueprints.Vertex;
import com.tinkerpop.blueprints.util.wrappers.event.listener.GraphChangedListener;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicLong;

public class StubGraphChangedListener
implements GraphChangedListener {
    private final AtomicLong addEdgeEvent = new AtomicLong(0L);
    private final AtomicLong addVertexEvent = new AtomicLong(0L);
    private final AtomicLong vertexPropertyChangedEvent = new AtomicLong(0L);
    private final AtomicLong vertexPropertyRemovedEvent = new AtomicLong(0L);
    private final AtomicLong vertexRemovedEvent = new AtomicLong(0L);
    private final AtomicLong edgePropertyChangedEvent = new AtomicLong(0L);
    private final AtomicLong edgePropertyRemovedEvent = new AtomicLong(0L);
    private final AtomicLong edgeRemovedEvent = new AtomicLong(0L);
    private final ConcurrentLinkedQueue<String> order = new ConcurrentLinkedQueue();

    public void reset() {
        this.addEdgeEvent.set(0L);
        this.addVertexEvent.set(0L);
        this.vertexPropertyChangedEvent.set(0L);
        this.vertexPropertyRemovedEvent.set(0L);
        this.vertexRemovedEvent.set(0L);
        this.edgePropertyChangedEvent.set(0L);
        this.edgePropertyRemovedEvent.set(0L);
        this.edgeRemovedEvent.set(0L);
        this.order.clear();
    }

    public List<String> getOrder() {
        return new ArrayList<String>(this.order);
    }

    @Override
    public void vertexAdded(Vertex vertex) {
        this.addVertexEvent.incrementAndGet();
        this.order.add("v-added-" + vertex.getId());
    }

    @Override
    public void vertexPropertyChanged(Vertex vertex, String s, Object o, Object n) {
        this.vertexPropertyChangedEvent.incrementAndGet();
        this.order.add("v-property-changed-" + vertex.getId() + "-" + s + ":" + o + "->" + n);
    }

    @Override
    public void vertexPropertyRemoved(Vertex vertex, String s, Object o) {
        this.vertexPropertyRemovedEvent.incrementAndGet();
        this.order.add("v-property-removed-" + vertex.getId() + "-" + s + ":" + o);
    }

    @Override
    public void vertexRemoved(Vertex vertex, Map<String, Object> props2) {
        this.vertexRemovedEvent.incrementAndGet();
        this.order.add("v-removed-" + vertex.getId());
    }

    @Override
    public void edgeAdded(Edge edge) {
        this.addEdgeEvent.incrementAndGet();
        this.order.add("e-added-" + edge.getId());
    }

    @Override
    public void edgePropertyChanged(Edge edge, String s, Object o, Object n) {
        this.edgePropertyChangedEvent.incrementAndGet();
        this.order.add("e-property-changed-" + edge.getId() + "-" + s + ":" + o + "->" + n);
    }

    @Override
    public void edgePropertyRemoved(Edge edge, String s, Object o) {
        this.edgePropertyRemovedEvent.incrementAndGet();
        this.order.add("e-property-removed-" + edge.getId() + "-" + s + ":" + o);
    }

    @Override
    public void edgeRemoved(Edge edge, Map<String, Object> props2) {
        this.edgeRemovedEvent.incrementAndGet();
        this.order.add("e-removed-" + edge.getId());
    }

    public long addEdgeEventRecorded() {
        return this.addEdgeEvent.get();
    }

    public long addVertexEventRecorded() {
        return this.addVertexEvent.get();
    }

    public long vertexPropertyChangedEventRecorded() {
        return this.vertexPropertyChangedEvent.get();
    }

    public long vertexPropertyRemovedEventRecorded() {
        return this.vertexPropertyRemovedEvent.get();
    }

    public long vertexRemovedEventRecorded() {
        return this.vertexRemovedEvent.get();
    }

    public long edgePropertyChangedEventRecorded() {
        return this.edgePropertyChangedEvent.get();
    }

    public long edgePropertyRemovedEventRecorded() {
        return this.edgePropertyRemovedEvent.get();
    }

    public long edgeRemovedEventRecorded() {
        return this.edgeRemovedEvent.get();
    }
}

