/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.configuration;

import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Vector;
import org.apache.commons.collections.ExtendedProperties;
import org.apache.commons.configuration.AbstractConfiguration;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.ConfigurationMap;
import org.apache.commons.configuration.MapConfiguration;
import org.apache.commons.lang.StringUtils;

public final class ConfigurationConverter {
    private ConfigurationConverter() {
    }

    public static Configuration getConfiguration(ExtendedProperties eprops) {
        return new MapConfiguration(eprops);
    }

    public static Configuration getConfiguration(Properties props2) {
        return new MapConfiguration(props2);
    }

    public static ExtendedProperties getExtendedProperties(Configuration config) {
        ExtendedProperties props2 = new ExtendedProperties();
        Iterator keys2 = config.getKeys();
        while (keys2.hasNext()) {
            String key = (String)keys2.next();
            Vector property = config.getProperty(key);
            if (property instanceof List) {
                property = new Vector(property);
            }
            props2.setProperty(key, property);
        }
        return props2;
    }

    public static Properties getProperties(Configuration config) {
        Properties props2 = new Properties();
        char delimiter = config instanceof AbstractConfiguration ? (char)((AbstractConfiguration)config).getListDelimiter() : (char)',';
        Iterator keys2 = config.getKeys();
        while (keys2.hasNext()) {
            String key = (String)keys2.next();
            List list = config.getList(key);
            props2.setProperty(key, StringUtils.join(list.iterator(), delimiter));
        }
        return props2;
    }

    public static Map getMap(Configuration config) {
        return new ConfigurationMap(config);
    }
}

