/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivy.osgi.obr.xml;

import java.io.OutputStream;
import java.text.ParseException;
import java.util.Iterator;
import java.util.Set;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.sax.SAXTransformerFactory;
import javax.xml.transform.sax.TransformerHandler;
import javax.xml.transform.stream.StreamResult;
import org.apache.ivy.core.IvyContext;
import org.apache.ivy.osgi.core.BundleCapability;
import org.apache.ivy.osgi.core.BundleInfo;
import org.apache.ivy.osgi.core.BundleRequirement;
import org.apache.ivy.osgi.core.ExportPackage;
import org.apache.ivy.osgi.core.ManifestParser;
import org.apache.ivy.osgi.repo.ManifestAndLocation;
import org.apache.ivy.osgi.util.Version;
import org.apache.ivy.osgi.util.VersionRange;
import org.apache.ivy.util.Message;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class OBRXMLWriter {
    public static ContentHandler newHandler(OutputStream out, String encoding, boolean indent) throws TransformerConfigurationException {
        SAXTransformerFactory tf = (SAXTransformerFactory)SAXTransformerFactory.newInstance();
        TransformerHandler hd = tf.newTransformerHandler();
        Transformer serializer = tf.newTransformer();
        StreamResult stream = new StreamResult(out);
        serializer.setOutputProperty("encoding", encoding);
        serializer.setOutputProperty("indent", indent ? "yes" : "no");
        hd.setResult(stream);
        return hd;
    }

    public static void writeManifests(Iterator it, ContentHandler handler, boolean quiet) throws SAXException {
        int level = quiet ? 4 : 1;
        handler.startDocument();
        AttributesImpl atts = new AttributesImpl();
        handler.startElement("", "repository", "repository", atts);
        int nbOk = 0;
        int nbRejected = 0;
        while (it.hasNext()) {
            BundleInfo bundleInfo;
            ManifestAndLocation manifestAndLocation = (ManifestAndLocation)it.next();
            try {
                bundleInfo = ManifestParser.parseManifest(manifestAndLocation.getManifest());
                bundleInfo.setUri(manifestAndLocation.getUri());
                ++nbOk;
            }
            catch (ParseException e) {
                ++nbRejected;
                IvyContext.getContext().getMessageLogger().log("Rejected " + manifestAndLocation.getUri() + ": " + e.getMessage(), level);
                continue;
            }
            OBRXMLWriter.saxBundleInfo(bundleInfo, handler);
        }
        handler.endElement("", "repository", "repository");
        handler.endDocument();
        Message.info(nbOk + " bundle" + (nbOk > 1 ? "s" : "") + " added, " + nbRejected + " bundle" + (nbRejected > 1 ? "s" : "") + " rejected.");
    }

    public static void writeBundles(Iterator it, ContentHandler handler) throws SAXException {
        handler.startDocument();
        AttributesImpl atts = new AttributesImpl();
        handler.startElement("", "repository", "repository", atts);
        while (it.hasNext()) {
            BundleInfo bundleInfo = (BundleInfo)it.next();
            OBRXMLWriter.saxBundleInfo(bundleInfo, handler);
        }
        handler.endElement("", "repository", "repository");
        handler.endDocument();
    }

    private static void saxBundleInfo(BundleInfo bundleInfo, ContentHandler handler) throws SAXException {
        AttributesImpl atts = new AttributesImpl();
        OBRXMLWriter.addAttr(atts, "symbolicname", bundleInfo.getSymbolicName());
        OBRXMLWriter.addAttr(atts, "version", bundleInfo.getRawVersion());
        if (bundleInfo.getUri() != null) {
            OBRXMLWriter.addAttr(atts, "uri", bundleInfo.getUri().toString());
        }
        handler.startElement("", "resource", "resource", atts);
        Iterator itCapabilities = bundleInfo.getCapabilities().iterator();
        while (itCapabilities.hasNext()) {
            BundleCapability capability = (BundleCapability)itCapabilities.next();
            OBRXMLWriter.saxCapability(capability, handler);
        }
        Iterator itRequirement = bundleInfo.getRequirements().iterator();
        while (itRequirement.hasNext()) {
            BundleRequirement requirement = (BundleRequirement)itRequirement.next();
            OBRXMLWriter.saxRequirement(requirement, handler);
        }
        handler.endElement("", "resource", "resource");
        handler.characters("\n".toCharArray(), 0, 1);
    }

    private static void saxCapability(BundleCapability capability, ContentHandler handler) throws SAXException {
        AttributesImpl atts = new AttributesImpl();
        String type = capability.getType();
        OBRXMLWriter.addAttr(atts, "name", type);
        handler.startElement("", "capability", "capability", atts);
        if (!type.equals("bundle")) {
            if (type.equals("package")) {
                Set uses;
                OBRXMLWriter.saxCapabilityProperty("package", capability.getName(), handler);
                Version v = capability.getRawVersion();
                if (v != null) {
                    OBRXMLWriter.saxCapabilityProperty("version", v.toString(), handler);
                }
                if ((uses = ((ExportPackage)capability).getUses()) != null && !uses.isEmpty()) {
                    StringBuffer builder = new StringBuffer();
                    Iterator itUse = uses.iterator();
                    while (itUse.hasNext()) {
                        String use2 = (String)itUse.next();
                        if (builder.length() != 0) {
                            builder.append(',');
                        }
                        builder.append(use2);
                    }
                    OBRXMLWriter.saxCapabilityProperty("uses", builder.toString(), handler);
                }
            } else if (type.equals("service")) {
                OBRXMLWriter.saxCapabilityProperty("service", capability.getName(), handler);
                Version v = capability.getRawVersion();
                if (v != null) {
                    OBRXMLWriter.saxCapabilityProperty("version", v.toString(), handler);
                }
            }
        }
        handler.endElement("", "capability", "capability");
        handler.characters("\n".toCharArray(), 0, 1);
    }

    private static void saxCapabilityProperty(String n, String v, ContentHandler handler) throws SAXException {
        OBRXMLWriter.saxCapabilityProperty(n, null, v, handler);
    }

    private static void saxCapabilityProperty(String n, String t, String v, ContentHandler handler) throws SAXException {
        AttributesImpl atts = new AttributesImpl();
        OBRXMLWriter.addAttr(atts, "n", n);
        if (t != null) {
            OBRXMLWriter.addAttr(atts, "t", t);
        }
        OBRXMLWriter.addAttr(atts, "v", v);
        handler.startElement("", "p", "p", atts);
        handler.endElement("", "p", "p");
        handler.characters("\n".toCharArray(), 0, 1);
    }

    private static void saxRequirement(BundleRequirement requirement, ContentHandler handler) throws SAXException {
        AttributesImpl atts = new AttributesImpl();
        OBRXMLWriter.addAttr(atts, "name", requirement.getType());
        if ("optional".equals(requirement.getResolution())) {
            OBRXMLWriter.addAttr(atts, "optional", Boolean.TRUE.toString());
        }
        OBRXMLWriter.addAttr(atts, "filter", OBRXMLWriter.buildFilter(requirement));
        handler.startElement("", "require", "require", atts);
        handler.endElement("", "require", "require");
        handler.characters("\n".toCharArray(), 0, 1);
    }

    private static String buildFilter(BundleRequirement requirement) {
        StringBuffer filter = new StringBuffer();
        VersionRange v = requirement.getVersion();
        if (v != null) {
            OBRXMLWriter.appendVersion(filter, v);
        }
        filter.append('(');
        filter.append(requirement.getType());
        filter.append("=");
        filter.append(requirement.getName());
        filter.append(')');
        if (v != null) {
            filter.append(')');
        }
        return filter.toString();
    }

    private static void appendVersion(StringBuffer filter, VersionRange v) {
        Version end;
        filter.append("(&");
        Version start = v.getStartVersion();
        if (start != null) {
            if (!v.isStartExclusive()) {
                filter.append("(version>=");
                filter.append(start.toString());
                filter.append(')');
            } else {
                filter.append("(!");
                filter.append("(version<=");
                filter.append(start.toString());
                filter.append("))");
            }
        }
        if ((end = v.getEndVersion()) != null) {
            if (!v.isEndExclusive()) {
                filter.append("(version<=");
                filter.append(end.toString());
                filter.append(')');
            } else {
                filter.append("(!");
                filter.append("(version>=");
                filter.append(end.toString());
                filter.append("))");
            }
        }
    }

    private static void addAttr(AttributesImpl atts, String name, String value) {
        if (value != null) {
            atts.addAttribute("", name, name, "CDATA", value);
        }
    }

    private static void addAttr(AttributesImpl atts, String name, Object value) {
        if (value != null) {
            atts.addAttribute("", name, name, "CDATA", value.toString());
        }
    }
}

