/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.orientdb;

import com.google.common.base.Preconditions;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.id.ORID;
import com.orientechnologies.orient.core.record.OElement;
import com.orientechnologies.orient.core.record.ORecord;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.storage.OStorage;
import java.util.Arrays;
import java.util.Iterator;
import org.apache.tinkerpop.gremlin.orientdb.OGraph;
import org.apache.tinkerpop.gremlin.orientdb.OrientProperty;
import org.apache.tinkerpop.gremlin.structure.Element;
import org.apache.tinkerpop.gremlin.structure.Graph;
import org.apache.tinkerpop.gremlin.structure.Property;
import org.apache.tinkerpop.gremlin.structure.T;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.apache.tinkerpop.gremlin.structure.util.ElementHelper;

public abstract class OrientElement
implements Element,
OIdentifiable {
    protected OElement rawElement;
    protected OGraph graph;

    public OrientElement(OGraph graph, OElement rawElement) {
        if (rawElement == null) {
            throw new IllegalArgumentException("rawElement must not be null!");
        }
        this.graph = (OGraph)Preconditions.checkNotNull((Object)graph);
        this.rawElement = (OElement)Preconditions.checkNotNull((Object)rawElement);
    }

    @Override
    public ORID id() {
        return this.rawElement.getIdentity();
    }

    @Override
    public String label() {
        this.graph.tx().readWrite();
        String internalClassName = this.getRawElement().getSchemaType().get().getName();
        return this.graph.classNameToLabel(internalClassName);
    }

    @Override
    public Graph graph() {
        return this.graph;
    }

    @Override
    public <V> Property<V> property(String key, V value) {
        return this.property(key, value, true);
    }

    private <V> Property<V> property(String key, V value, boolean saveDocument) {
        if (key == null) {
            throw Property.Exceptions.propertyKeyCanNotBeNull();
        }
        if (value == null) {
            throw Property.Exceptions.propertyValueCanNotBeNull();
        }
        if (Graph.Hidden.isHidden(key)) {
            throw Property.Exceptions.propertyKeyCanNotBeAHiddenKey(key);
        }
        this.graph.tx().readWrite();
        OElement doc = this.getRawElement();
        doc.setProperty(key, value);
        if (saveDocument) {
            doc.save();
        }
        return new OrientProperty<V>(key, value, this);
    }

    @Override
    public <V> Property<V> property(String key) {
        ODocument doc = (ODocument)this.getRawElement().getRecord();
        if (doc.containsField(key)) {
            return new OrientProperty(key, this.getRawElement().getProperty(key), this);
        }
        return Property.empty();
    }

    public void property(Object ... keyValues) {
        ElementHelper.legalPropertyKeyValueArray(keyValues);
        if (ElementHelper.getIdValue(keyValues).isPresent()) {
            throw Vertex.Exceptions.userSuppliedIdsNotSupported();
        }
        for (int i = 0; i < keyValues.length; i += 2) {
            if (keyValues[i].equals(T.id) || keyValues[i].equals(T.label)) continue;
            this.property((String)keyValues[i], keyValues[i + 1], false);
        }
        this.getRawElement().save();
    }

    @Override
    public <V> Iterator<? extends Property<V>> properties(String ... propertyKeys) {
        this.graph.tx().readWrite();
        ODocument record = (ODocument)this.rawElement.getRecord();
        if (propertyKeys.length > 0) {
            return Arrays.asList(propertyKeys).stream().filter(p -> record.containsField((String)p)).map(entry -> new OrientProperty((String)entry, this.rawElement.getProperty((String)entry), this)).iterator();
        }
        return record.getPropertyNames().stream().map(entry -> new OrientProperty((String)entry, this.rawElement.getProperty((String)entry), this)).iterator();
    }

    @Override
    public void remove() {
        this.graph.tx().readWrite();
        this.rawElement.delete();
    }

    public void save() {
        this.rawElement.save();
    }

    public OGraph getGraph() {
        return this.graph;
    }

    public abstract OElement getRawElement();

    public final int hashCode() {
        return ElementHelper.hashCode(this);
    }

    @Override
    public final boolean equals(Object object) {
        return ElementHelper.areEqual(this, object);
    }

    @Override
    public ORID getIdentity() {
        return this.rawElement.getIdentity();
    }

    @Override
    public <T extends ORecord> T getRecord() {
        return (T)this.rawElement;
    }

    @Override
    public void lock(boolean iExclusive) {
        this.rawElement.lock(iExclusive);
    }

    @Override
    public boolean isLocked() {
        return this.rawElement.isLocked();
    }

    @Override
    public OStorage.LOCKING_STRATEGY lockingStrategy() {
        return this.rawElement.lockingStrategy();
    }

    @Override
    public void unlock() {
        this.rawElement.unlock();
    }

    @Override
    public int compareTo(OIdentifiable o) {
        return this.rawElement.compareTo(o);
    }

    @Override
    public int compare(OIdentifiable o1, OIdentifiable o2) {
        return this.rawElement.compare(o1, o2);
    }
}

