/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.orientdb;

import com.orientechnologies.common.exception.OException;
import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.common.util.OCallable;
import com.orientechnologies.orient.core.command.OCommandRequest;
import com.orientechnologies.orient.core.db.ODatabaseDocumentInternal;
import com.orientechnologies.orient.core.db.ODatabaseRecordThreadLocal;
import com.orientechnologies.orient.core.db.ODatabaseSession;
import com.orientechnologies.orient.core.db.document.ODatabaseDocument;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.db.record.ORecordElement;
import com.orientechnologies.orient.core.exception.ORecordNotFoundException;
import com.orientechnologies.orient.core.id.ORID;
import com.orientechnologies.orient.core.id.ORecordId;
import com.orientechnologies.orient.core.index.OIndex;
import com.orientechnologies.orient.core.index.OIndexManager;
import com.orientechnologies.orient.core.index.OPropertyIndexDefinition;
import com.orientechnologies.orient.core.metadata.schema.OClass;
import com.orientechnologies.orient.core.metadata.schema.OProperty;
import com.orientechnologies.orient.core.metadata.schema.OSchema;
import com.orientechnologies.orient.core.metadata.schema.OType;
import com.orientechnologies.orient.core.record.OElement;
import com.orientechnologies.orient.core.record.ORecord;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.record.impl.ODocumentInternal;
import com.orientechnologies.orient.core.sql.executor.OResultSet;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.concurrent.ThreadLocalRandom;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.Stream;
import org.apache.commons.configuration.BaseConfiguration;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.lang.NotImplementedException;
import org.apache.tinkerpop.gremlin.orientdb.ODBFeatures;
import org.apache.tinkerpop.gremlin.orientdb.OElementFactory;
import org.apache.tinkerpop.gremlin.orientdb.OGraph;
import org.apache.tinkerpop.gremlin.orientdb.OrientEdge;
import org.apache.tinkerpop.gremlin.orientdb.OrientElement;
import org.apache.tinkerpop.gremlin.orientdb.OrientGraphBaseFactory;
import org.apache.tinkerpop.gremlin.orientdb.OrientGraphFactory;
import org.apache.tinkerpop.gremlin.orientdb.OrientNoTransaction;
import org.apache.tinkerpop.gremlin.orientdb.OrientTransaction;
import org.apache.tinkerpop.gremlin.orientdb.OrientVertex;
import org.apache.tinkerpop.gremlin.orientdb.StreamUtils;
import org.apache.tinkerpop.gremlin.orientdb.executor.OGremlinResultSet;
import org.apache.tinkerpop.gremlin.orientdb.io.OrientIoRegistry;
import org.apache.tinkerpop.gremlin.orientdb.traversal.strategy.optimization.OrientGraphCountStrategy;
import org.apache.tinkerpop.gremlin.orientdb.traversal.strategy.optimization.OrientGraphMatchStepStrategy;
import org.apache.tinkerpop.gremlin.orientdb.traversal.strategy.optimization.OrientGraphStepStrategy;
import org.apache.tinkerpop.gremlin.process.computer.GraphComputer;
import org.apache.tinkerpop.gremlin.process.traversal.TraversalStrategies;
import org.apache.tinkerpop.gremlin.structure.Edge;
import org.apache.tinkerpop.gremlin.structure.Element;
import org.apache.tinkerpop.gremlin.structure.Graph;
import org.apache.tinkerpop.gremlin.structure.T;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.apache.tinkerpop.gremlin.structure.io.Io;
import org.apache.tinkerpop.gremlin.structure.util.ElementHelper;
import org.apache.tinkerpop.gremlin.structure.util.StringFactory;

@Graph.OptIns(value={@Graph.OptIn(value="org.apache.tinkerpop.gremlin.structure.StructureStandardSuite"), @Graph.OptIn(value="org.apache.tinkerpop.gremlin.structure.StructureIntegrateSuite"), @Graph.OptIn(value="org.apache.tinkerpop.gremlin.process.ProcessStandardSuite"), @Graph.OptIn(value="org.apache.tinkerpop.gremlin.process.ProcessComputerSuite"), @Graph.OptIn(value="org.apache.tinkerpop.gremlin.orientdb.gremlintest.suite.OrientDBDebugSuite")})
public final class OrientGraph
implements OGraph {
    private static final Map<String, String> INTERNAL_CLASSES_TO_TINKERPOP_CLASSES;
    public static final String CONFIG_URL = "orient-url";
    public static final String CONFIG_DB_NAME = "orient-db-name";
    public static final String CONFIG_DB_TYPE = "orient-db-type";
    public static final String CONFIG_USER = "orient-user";
    public static final String CONFIG_PASS = "orient-pass";
    public static final String CONFIG_CREATE = "orient-create";
    public static final String CONFIG_OPEN = "orient-open";
    public static final String CONFIG_TRANSACTIONAL = "orient-transactional";
    public static final String CONFIG_POOL_SIZE = "orient-max-poolsize";
    public static final String CONFIG_MAX_PARTITION_SIZE = "orient-max-partitionsize";
    public static final String CONFIG_LABEL_AS_CLASSNAME = "orient-label-as-classname";
    protected ODatabaseDocument database;
    protected final Graph.Features features;
    protected final Configuration configuration;
    protected final String user;
    protected final String password;
    protected OrientGraphBaseFactory factory;
    protected boolean shouldCloseFactory = false;
    protected OElementFactory elementFactory;
    protected OrientTransaction tx;

    public static OrientGraph open() {
        return OrientGraph.open("memory:orientdb-" + ThreadLocalRandom.current().nextInt(Integer.MAX_VALUE), "admin", "admin");
    }

    public static OrientGraph open(String url) {
        return OrientGraph.open(url, "admin", "admin");
    }

    public static OrientGraph open(String url, String user, String password) {
        BaseConfiguration configuration = new BaseConfiguration();
        configuration.setProperty(CONFIG_URL, url);
        configuration.setProperty(CONFIG_USER, user);
        configuration.setProperty(CONFIG_PASS, password);
        return OrientGraph.open(configuration);
    }

    public static OrientGraph open(Configuration config) {
        OrientGraphFactory factory = new OrientGraphFactory(config);
        if (config.containsKey(CONFIG_POOL_SIZE)) {
            factory.setupPool(config.getInt(CONFIG_MAX_PARTITION_SIZE, 64), config.getInt(CONFIG_POOL_SIZE));
        }
        return new OrientGraph(factory, config, true);
    }

    public OrientGraph(OrientGraphBaseFactory factory, ODatabaseDocument database, Configuration configuration, String user, String password) {
        this.factory = factory;
        this.user = user;
        this.password = password;
        this.database = database;
        this.configuration = configuration;
        if (configuration.getBoolean(CONFIG_TRANSACTIONAL, false)) {
            this.features = ODBFeatures.OrientFeatures.INSTANCE_TX;
            this.tx = new OrientTransaction(this);
        } else {
            this.features = ODBFeatures.OrientFeatures.INSTANCE_NOTX;
            this.tx = new OrientNoTransaction(this);
        }
        this.elementFactory = new OElementFactory(this);
    }

    public OrientGraph(OrientGraphBaseFactory factory, Configuration configuration) {
        this(factory, configuration, false);
    }

    public OrientGraph(OrientGraphBaseFactory factory, Configuration configuration, boolean closeFactory) {
        this.factory = factory;
        this.database = factory.getDatabase(true, true);
        this.user = "";
        this.password = "";
        this.makeActive();
        this.configuration = configuration;
        if (configuration.getBoolean(CONFIG_TRANSACTIONAL, false)) {
            this.features = ODBFeatures.OrientFeatures.INSTANCE_TX;
            this.tx = new OrientTransaction(this);
        } else {
            this.features = ODBFeatures.OrientFeatures.INSTANCE_NOTX;
            this.tx = new OrientNoTransaction(this);
        }
        this.shouldCloseFactory = closeFactory;
        this.elementFactory = new OElementFactory(this);
    }

    @Override
    public Graph.Features features() {
        return this.features;
    }

    public ODatabaseDocument database() {
        return this.database;
    }

    private void makeActiveDb() {
        ODatabaseDocumentInternal tlDb = ODatabaseRecordThreadLocal.instance().getIfDefined();
        if (this.database != null && tlDb != this.database) {
            this.database.activateOnCurrentThread();
        }
    }

    public void makeActive() {
        this.makeActiveDb();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <R> R executeOutsideTx(Function<ODatabaseDocument, R> lamba) {
        if (this.tx().isOpen()) {
            ODatabaseDocument oldDb = this.getRawDatabase();
            ODatabaseDocumentInternal newDb = null;
            try {
                newDb = ((ODatabaseDocumentInternal)oldDb).copy();
                newDb.activateOnCurrentThread();
                R r = lamba.apply(newDb);
                return r;
            }
            finally {
                if (newDb != null) {
                    newDb.close();
                }
                oldDb.activateOnCurrentThread();
            }
        }
        return lamba.apply(this.getRawDatabase());
    }

    @Override
    public Vertex addVertex(Object ... keyValues) {
        this.tx().readWrite();
        this.makeActive();
        ElementHelper.legalPropertyKeyValueArray(keyValues);
        if (ElementHelper.getIdValue(keyValues).isPresent()) {
            throw Vertex.Exceptions.userSuppliedIdsNotSupported();
        }
        String label = ElementHelper.getLabelValue(keyValues).orElse("V");
        OrientVertex vertex = this.elementFactory().createVertex(label);
        vertex.property(keyValues);
        vertex.save();
        return vertex;
    }

    public OGremlinResultSet executeSql(String sql, Object ... params) {
        this.tx().readWrite();
        this.makeActive();
        OResultSet resultSet = this.database.command(sql, params);
        return new OGremlinResultSet(this, resultSet);
    }

    @Override
    public OGremlinResultSet executeSql(String sql, Map params) {
        this.makeActive();
        OResultSet resultSet = this.database.command(sql, params);
        return new OGremlinResultSet(this, resultSet);
    }

    public OGremlinResultSet querySql(String sql, Object ... params) {
        this.tx().readWrite();
        this.makeActive();
        OResultSet resultSet = this.database.query(sql, params);
        return new OGremlinResultSet(this, resultSet);
    }

    @Override
    public OGremlinResultSet querySql(String sql, Map params) {
        this.makeActive();
        OResultSet resultSet = this.database.query(sql, params);
        return new OGremlinResultSet(this, resultSet);
    }

    public OGremlinResultSet execute(String language, String script, Map params) {
        this.makeActive();
        OResultSet resultSet = this.database.execute(language, script, params);
        return new OGremlinResultSet(this, resultSet);
    }

    @Deprecated
    public Object executeCommand(OCommandRequest command) {
        return command.execute(new Object[0]);
    }

    @Override
    public <C extends GraphComputer> C compute(Class<C> graphComputerClass) throws IllegalArgumentException {
        throw new NotImplementedException();
    }

    @Override
    public GraphComputer compute() throws IllegalArgumentException {
        throw new NotImplementedException();
    }

    @Override
    public OElementFactory elementFactory() {
        return this.elementFactory;
    }

    @Override
    public Iterator<Vertex> vertices(Object ... vertexIds) {
        this.tx().readWrite();
        this.makeActive();
        return this.elements("V", r -> this.elementFactory().wrapVertex(this.getRawDocument((ORecord)r).asVertex().orElseThrow(() -> new IllegalArgumentException(String.format("Cannot get a Vertex from document %s", r)))), vertexIds);
    }

    @Override
    public String labelToClassName(String label, String prefix) {
        if (this.configuration.getBoolean(CONFIG_LABEL_AS_CLASSNAME, true)) {
            return label;
        }
        return label.equals(prefix) ? prefix : prefix + "_" + label;
    }

    @Override
    public String classNameToLabel(String className) {
        if (INTERNAL_CLASSES_TO_TINKERPOP_CLASSES.containsKey(className)) {
            return INTERNAL_CLASSES_TO_TINKERPOP_CLASSES.get(className);
        }
        if (this.configuration.getBoolean(CONFIG_LABEL_AS_CLASSNAME, true)) {
            return className;
        }
        return className.substring(2);
    }

    public <T> T executeWithRetry(int nRetries, Function<OrientGraph, T> function) {
        if (!this.features.graph().supportsTransactions()) {
            throw Graph.Exceptions.transactionsNotSupported();
        }
        ODatabaseDocument rawDatabase = this.getRawDatabase();
        return (T)rawDatabase.executeWithRetry(nRetries, (ODatabaseSession db) -> function.apply(this));
    }

    protected Object convertValue(OIndex idx, Object iValue) {
        if (iValue != null) {
            OType[] types = idx.getKeyTypes();
            iValue = types.length == 0 ? iValue.toString() : OType.convert(iValue, types[0].getDefaultJavaType());
        }
        return iValue;
    }

    @Override
    public Stream<OrientVertex> getIndexedVertices(OIndex index, Iterator<Object> valueIter) {
        return this.getIndexedElements(index, valueIter, OrientVertex::new);
    }

    @Override
    public Stream<OrientEdge> getIndexedEdges(OIndex index, Iterator<Object> valueIter) {
        return this.getIndexedElements(index, valueIter, OrientEdge::new);
    }

    private <ElementType extends OrientElement> Stream<ElementType> getIndexedElements(OIndex index, Iterator<Object> valuesIter, BiFunction<OrientGraph, OIdentifiable, ElementType> newElement) {
        this.makeActive();
        if (index == null) {
            return Collections.emptyList().stream();
        }
        if (!valuesIter.hasNext()) {
            return index.getInternal().stream().map(id -> (OrientElement)newElement.apply(this, (OIdentifiable)id.second));
        }
        Stream<Object> convertedValues = StreamUtils.asStream(valuesIter).map(value -> this.convertValue(index, value));
        Stream<OIdentifiable> ids = convertedValues.flatMap(v -> this.lookupInIndex(index, v)).filter(r -> r != null);
        Stream<ORecord> records = ids.map(id -> id.getRecord());
        return records.map(r -> (OrientElement)newElement.apply(this, this.getRawDocument((ORecord)r)));
    }

    private Stream<OIdentifiable> lookupInIndex(OIndex index, Object value) {
        Object fromIndex = index.get(value);
        if (fromIndex instanceof Iterable) {
            return StreamUtils.asStream(((Iterable)fromIndex).iterator());
        }
        return Stream.of((OIdentifiable)fromIndex);
    }

    private OIndexManager getIndexManager() {
        return this.database.getMetadata().getIndexManager();
    }

    private OSchema getSchema() {
        return this.database.getMetadata().getSchema();
    }

    public Set<String> getIndexedKeys(String className) {
        Iterator<OIndex> indexes = this.getIndexManager().getClassIndexes(className).iterator();
        HashSet<String> indexedKeys = new HashSet<String>();
        indexes.forEachRemaining(index -> index.getDefinition().getFields().forEach(indexedKeys::add));
        return indexedKeys;
    }

    @Override
    public Set<String> getIndexedKeys(Class<? extends Element> elementClass, String label) {
        if (Vertex.class.isAssignableFrom(elementClass)) {
            return this.getVertexIndexedKeys(label);
        }
        if (Edge.class.isAssignableFrom(elementClass)) {
            return this.getEdgeIndexedKeys(label);
        }
        throw new IllegalArgumentException("Class is not indexable: " + elementClass);
    }

    public Set<String> getIndexedKeys(Class<? extends Element> elementClass) {
        if (Vertex.class.isAssignableFrom(elementClass)) {
            return this.getIndexedKeys("V");
        }
        if (Edge.class.isAssignableFrom(elementClass)) {
            return this.getIndexedKeys("E");
        }
        throw new IllegalArgumentException("Class is not indexable: " + elementClass);
    }

    public Set<String> getVertexIndexedKeys(String label) {
        String className = this.labelToClassName(label, "V");
        OClass cls = this.getSchema().getClass(className);
        if (cls != null && cls.isSubClassOf("V")) {
            return this.getIndexedKeys(className);
        }
        return new HashSet<String>();
    }

    public Set<String> getEdgeIndexedKeys(String label) {
        String className = this.labelToClassName(label, "E");
        OClass cls = this.getSchema().getClass(className);
        if (cls != null && cls.isSubClassOf("E")) {
            return this.getIndexedKeys(className);
        }
        return new HashSet<String>();
    }

    @Override
    public Iterator<Edge> edges(Object ... edgeIds) {
        this.tx().readWrite();
        this.makeActive();
        return this.elements("E", r -> this.elementFactory().wrapEdge(this.getRawDocument((ORecord)r).asEdge().orElseThrow(() -> new IllegalArgumentException(String.format("Cannot get an Edge from document %s", r)))), edgeIds);
    }

    protected <A extends Element> Iterator<A> elements(String elementClass, Function<ORecord, A> toA, Object ... elementIds) {
        boolean polymorphic = true;
        if (elementIds.length == 0) {
            Iterator itty = this.database.browseClass(elementClass, polymorphic).iterator();
            return StreamUtils.asStream(itty).map(toA).iterator();
        }
        Stream<ORID> ids = Stream.of(elementIds).map(OrientGraph::createRecordId);
        Stream<ORecord> records = ids.filter(ORID::isValid).map(id -> this.getRecord((ORID)id)).filter(r -> r != null);
        return records.map(toA).iterator();
    }

    protected ORecord getRecord(ORID id) {
        try {
            return id.getRecord();
        }
        catch (ORecordNotFoundException e) {
            throw new NoSuchElementException("The " + this.getClass().getSimpleName().toLowerCase() + " with id " + id + " of type " + id.getClass().getSimpleName() + " does not exist in the graph");
        }
    }

    private ORID checkId(ORID id) {
        if (!id.isValid()) {
            throw new IllegalArgumentException("Invalid id " + id);
        }
        return id;
    }

    protected static ORID createRecordId(Object id) {
        if (id instanceof ORecordId) {
            return (ORecordId)id;
        }
        if (id instanceof String) {
            return new ORecordId((String)id);
        }
        if (id instanceof OrientElement) {
            return ((OrientElement)id).id();
        }
        throw new IllegalArgumentException("Orient IDs have to be a String or ORecordId - you provided a " + id.getClass());
    }

    protected OElement getRawDocument(ORecord record) {
        if (record == null) {
            throw new NoSuchElementException();
        }
        ODocument currentDocument = (ODocument)(record = record.getRecord());
        if (currentDocument.getInternalStatus() == ORecordElement.STATUS.NOT_LOADED) {
            currentDocument.load();
        }
        if (ODocumentInternal.getImmutableSchemaClass(currentDocument) == null) {
            throw new IllegalArgumentException("Cannot determine the graph element type because the document class is null. Probably this is a projection, use the EXPAND() function");
        }
        return currentDocument;
    }

    @Override
    public OrientTransaction tx() {
        this.makeActive();
        return this.tx;
    }

    public void drop() {
        this.factory.drop();
    }

    public boolean isClosed() {
        this.makeActive();
        return this.database == null || this.database.isClosed();
    }

    public void begin() {
        this.makeActive();
        this.tx().doOpen();
    }

    public void commit() {
        this.makeActive();
        this.tx().commit();
    }

    public void rollback() {
        this.makeActive();
        this.tx().rollback();
    }

    @Override
    public Graph.Variables variables() {
        this.makeActive();
        throw new NotImplementedException();
    }

    @Override
    public Configuration configuration() {
        return this.configuration;
    }

    @Override
    public void close() {
        this.makeActive();
        String url = this.database.getURL();
        try {
            this.tx().close();
        }
        finally {
            try {
                if (!this.database.isClosed()) {
                    this.database.close();
                    if (this.shouldCloseFactory) {
                        this.factory.close();
                    }
                }
            }
            catch (Exception e) {
                OLogManager.instance().error(this, "Error during context close for db " + url, e, new Object[0]);
            }
        }
    }

    @Override
    public String createVertexClass(String label) {
        this.makeActive();
        String className = this.labelToClassName(label, "V");
        this.createClass(className, "V");
        return className;
    }

    @Override
    public String createEdgeClass(String label) {
        this.makeActive();
        String className = this.labelToClassName(label, "E");
        this.createClass(className, "E");
        return className;
    }

    public void createClass(String className, String superClassName) {
        this.makeActive();
        OClass superClass = this.database.getMetadata().getSchema().getClass(superClassName);
        if (superClass == null) {
            Collection<OClass> allClasses = this.database.getMetadata().getSchema().getClasses();
            throw new IllegalArgumentException("unable to find class " + superClassName + ". Available classes: " + allClasses);
        }
        this.createClass(className, superClass);
    }

    @Override
    public boolean existClass(String label) {
        this.makeActive();
        OSchema schema = this.database.getMetadata().getSchema();
        OClass cls = schema.getClass(label);
        return cls != null;
    }

    public void createClass(String className, OClass superClass) {
        this.makeActive();
        OSchema schema = this.database.getMetadata().getSchema();
        OClass cls = schema.getClass(className);
        if (cls == null) {
            try {
                this.executeOutsideTx(db -> {
                    OSchema s = db.getMetadata().getSchema();
                    s.createClass(className, superClass);
                    return null;
                });
                if (this.tx().isOpen()) {
                    schema.reload();
                }
            }
            catch (OException e) {
                throw new IllegalArgumentException(e);
            }
            OLogManager.instance().info((Object)this, "created class '" + className + "' as subclass of '" + superClass + "'", new Object[0]);
        } else if (!cls.isSubClassOf(superClass)) {
            throw new IllegalArgumentException("unable to create class '" + className + "' as subclass of '" + superClass + "'. different super class.");
        }
    }

    @Override
    public ODatabaseDocument getRawDatabase() {
        this.makeActive();
        return this.database;
    }

    protected <E> String getClassName(Class<T> elementClass) {
        if (elementClass.isAssignableFrom(Vertex.class)) {
            return "V";
        }
        if (elementClass.isAssignableFrom(Edge.class)) {
            return "E";
        }
        throw new IllegalArgumentException("Class '" + elementClass + "' is neither a Vertex, nor an Edge");
    }

    protected void prepareIndexConfiguration(Configuration config) {
        String defaultIndexType = OClass.INDEX_TYPE.NOTUNIQUE.name();
        OType defaultKeyType = OType.STRING;
        Object defaultClassName = null;
        Object defaultCollate = null;
        Object defaultMetadata = null;
        if (!config.containsKey("type")) {
            config.setProperty("type", defaultIndexType);
        }
        if (!config.containsKey("keytype")) {
            config.setProperty("keytype", (Object)defaultKeyType);
        }
        if (!config.containsKey("class")) {
            config.setProperty("class", defaultClassName);
        }
        if (!config.containsKey("collate")) {
            config.setProperty("collate", defaultCollate);
        }
        if (!config.containsKey("metadata")) {
            config.setProperty("metadata", defaultMetadata);
        }
    }

    public <E extends Element> void createVertexIndex(String key, String label, Configuration configuration) {
        String className = this.labelToClassName(label, "V");
        this.createVertexClass(label);
        this.createIndex(key, className, configuration);
    }

    public <E extends Element> void createEdgeIndex(String key, String label, Configuration configuration) {
        String className = this.labelToClassName(label, "E");
        this.createEdgeClass(label);
        this.createIndex(key, className, configuration);
    }

    private <E extends Element> void createIndex(final String key, final String className, final Configuration configuration) {
        this.makeActive();
        this.prepareIndexConfiguration(configuration);
        OCallable<OClass, OrientGraph> callable = new OCallable<OClass, OrientGraph>(){

            @Override
            public OClass call(OrientGraph g) {
                String indexType = configuration.getString("type");
                OType keyType = (OType)((Object)configuration.getProperty("keytype"));
                String collate = configuration.getString("collate");
                ODocument metadata = (ODocument)configuration.getProperty("metadata");
                ODatabaseDocument db = OrientGraph.this.getRawDatabase();
                OSchema schema = db.getMetadata().getSchema();
                OClass cls = schema.getClass(className);
                OProperty property = cls.getProperty(key);
                if (property != null) {
                    keyType = property.getType();
                }
                OPropertyIndexDefinition indexDefinition = new OPropertyIndexDefinition(className, key, keyType);
                if (collate != null) {
                    indexDefinition.setCollate(collate);
                }
                db.getMetadata().getIndexManager().createIndex(className + "." + key, indexType, indexDefinition, cls.getPolymorphicClusterIds(), null, metadata);
                return null;
            }
        };
        this.execute(callable, "create key index on '", className, ".", key, "'");
    }

    public <RET> RET execute(OCallable<RET, OrientGraph> iCallable, String ... iOperationStrings) throws RuntimeException {
        this.makeActive();
        if (OLogManager.instance().isWarnEnabled() && iOperationStrings.length > 0) {
            StringBuilder msg = new StringBuilder(256);
            for (String s : iOperationStrings) {
                msg.append(s);
            }
            OLogManager.instance().warn((Object)this, msg.toString(), new Object[0]);
        }
        return iCallable.call(this);
    }

    @Override
    public <I extends Io> I io(Io.Builder<I> builder) {
        return (I)OGraph.super.io(builder.onMapper(mb -> mb.addRegistry(OrientIoRegistry.getInstance())));
    }

    public String toString() {
        return StringFactory.graphString(this, this.database.getURL());
    }

    protected boolean isTransactionActive() {
        return this.getRawDatabase().getTransaction().isActive();
    }

    public void setElementFactory(OElementFactory elementFactory) {
        this.elementFactory = elementFactory;
    }

    static {
        TraversalStrategies.GlobalCache.registerStrategies(OrientGraph.class, TraversalStrategies.GlobalCache.getStrategies(Graph.class).clone().addStrategies(OrientGraphStepStrategy.instance(), OrientGraphCountStrategy.instance(), OrientGraphMatchStepStrategy.instance()));
        INTERNAL_CLASSES_TO_TINKERPOP_CLASSES = new HashMap<String, String>();
        INTERNAL_CLASSES_TO_TINKERPOP_CLASSES.put("V", "vertex");
        INTERNAL_CLASSES_TO_TINKERPOP_CLASSES.put("E", "edge");
    }
}

